/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.ei.service;

import com.mongodb.client.gridfs.model.GridFSFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.ei.node.dto.ExportFormat;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.services.FileService;
import org.qubership.atp.ei.node.services.ObjectSaverToDiskService;
import org.qubership.atp.mia.ei.component.ExportImportUtils;
import org.qubership.atp.mia.ei.service.ExportStrategy;
import org.qubership.atp.mia.exceptions.ei.MiaExportCopyToFileException;
import org.qubership.atp.mia.exceptions.ei.MiaExportFileNotFoundException;
import org.qubership.atp.mia.model.configuration.CompoundConfiguration;
import org.qubership.atp.mia.model.configuration.ProcessConfiguration;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.configuration.SectionConfiguration;
import org.qubership.atp.mia.model.ei.ExportImportCommonConfiguration;
import org.qubership.atp.mia.model.ei.ExportImportCompound;
import org.qubership.atp.mia.model.ei.ExportImportDirectory;
import org.qubership.atp.mia.model.ei.ExportImportEntities;
import org.qubership.atp.mia.model.ei.ExportImportFile;
import org.qubership.atp.mia.model.ei.ExportImportHeaderConfiguration;
import org.qubership.atp.mia.model.ei.ExportImportPotHeaderConfiguration;
import org.qubership.atp.mia.model.ei.ExportImportProcess;
import org.qubership.atp.mia.model.ei.ExportImportSection;
import org.qubership.atp.mia.model.file.ProjectDirectory;
import org.qubership.atp.mia.model.file.ProjectFile;
import org.qubership.atp.mia.service.configuration.CompoundConfigurationService;
import org.qubership.atp.mia.service.configuration.ProcessConfigurationService;
import org.qubership.atp.mia.service.configuration.ProjectConfigurationService;
import org.qubership.atp.mia.service.configuration.SectionConfigurationService;
import org.qubership.atp.mia.service.file.GridFsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AtpExportStrategy
implements ExportStrategy {
    private static final Logger log = LoggerFactory.getLogger(AtpExportStrategy.class);
    private final FileService fileService;
    private final GridFsService gridFsService;
    private final ObjectSaverToDiskService objectSaverToDiskService;
    private final ProjectConfigurationService projectConfigurationService;

    @Override
    public ExportFormat getFormat() {
        return ExportFormat.ATP;
    }

    @Override
    public void export(ExportImportData exportData, Path path) {
        try {
            ProjectConfiguration projectConfiguration = this.projectConfigurationService.getConfigByProjectId(exportData.getProjectId());
            this.exportSections(projectConfiguration, exportData, path);
            this.exportProcesses(projectConfiguration, exportData, path);
            this.exportCompound(projectConfiguration, exportData, path);
            this.exportGeneralConfiguration(projectConfiguration, exportData, path);
            this.exportFiles(projectConfiguration, exportData, path);
        }
        catch (Exception e) {
            log.error("Export failed with exception {}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
    }

    private void exportCompound(ProjectConfiguration projectConfiguration, ExportImportData exportData, Path path) {
        List<UUID> exportCompoundIds = ((Set)exportData.getExportScope().getEntities().getOrDefault(ExportImportEntities.MIA_COMPOUNDS.getValue(), new HashSet())).stream().map(UUID::fromString).collect(Collectors.toList());
        List<CompoundConfiguration> compounds = CompoundConfigurationService.filterCompounds(projectConfiguration.getCompounds(), exportCompoundIds).stream().filter(Objects::nonNull).collect(Collectors.toList());
        compounds.forEach(c -> this.objectSaverToDiskService.exportAtpEntity(c.getId(), (Object)new ExportImportCompound((CompoundConfiguration)c), path.resolve(ExportImportEntities.MIA_SECTION.getValue())));
        compounds.stream().flatMap(c -> c.getProcesses().stream()).filter(Objects::nonNull).forEach(p -> this.objectSaverToDiskService.exportAtpEntity(p.getId(), (Object)new ExportImportProcess((ProcessConfiguration)p), path.resolve(ExportImportEntities.MIA_SECTION.getValue())));
        log.info("Compounds exported");
    }

    private void exportProcesses(ProjectConfiguration projectConfiguration, ExportImportData exportData, Path path) {
        List<UUID> exportProcessIds = ((Set)exportData.getExportScope().getEntities().getOrDefault(ExportImportEntities.MIA_PROCESSES.getValue(), new HashSet())).stream().map(UUID::fromString).collect(Collectors.toList());
        ProcessConfigurationService.filterProcess(projectConfiguration.getProcesses(), exportProcessIds).stream().filter(Objects::nonNull).forEach(p -> this.objectSaverToDiskService.exportAtpEntity(p.getId(), (Object)new ExportImportProcess((ProcessConfiguration)p), path.resolve(ExportImportEntities.MIA_SECTION.getValue())));
        log.info("Processes exported");
    }

    private void exportSections(ProjectConfiguration projectConfiguration, ExportImportData exportData, Path path) {
        List<UUID> exportSectionIds = ((Set)exportData.getExportScope().getEntities().getOrDefault(ExportImportEntities.MIA_SECTION.getValue(), new HashSet())).stream().map(UUID::fromString).collect(Collectors.toList());
        SectionConfigurationService.filterSections(projectConfiguration.getSections(), exportSectionIds).stream().filter(Objects::nonNull).forEach(s -> this.objectSaverToDiskService.exportAtpEntity(s.getId(), (Object)new ExportImportSection((SectionConfiguration)s), path.resolve(ExportImportEntities.MIA_SECTION.getValue())));
        log.info("Sections exported");
    }

    private void exportGeneralConfiguration(ProjectConfiguration projectConfiguration, ExportImportData exportData, Path path) {
        boolean isPotConfiguration;
        Map entities = exportData.getExportScope().getEntities();
        boolean isCommonConfiguration = entities.containsKey(ExportImportEntities.MIA_COMMON_CONFIGURATION.getValue()) && !((Set)entities.get(ExportImportEntities.MIA_COMMON_CONFIGURATION.getValue())).isEmpty();
        boolean isHeaderConfiguration = entities.containsKey(ExportImportEntities.MIA_HEADER_CONFIGURATION.getValue()) && !((Set)entities.get(ExportImportEntities.MIA_HEADER_CONFIGURATION.getValue())).isEmpty();
        boolean bl = isPotConfiguration = entities.containsKey(ExportImportEntities.MIA_POT_HEADER_CONFIGURATION.getValue()) && !((Set)entities.get(ExportImportEntities.MIA_POT_HEADER_CONFIGURATION.getValue())).isEmpty();
        if (isCommonConfiguration) {
            this.objectSaverToDiskService.exportAtpEntity(projectConfiguration.getProjectId(), (Object)new ExportImportCommonConfiguration(projectConfiguration.getCommonConfiguration()), path.resolve(ExportImportEntities.MIA_PROJECT_CONFIGURATION.getValue()));
            log.info("CommonConfiguration exported");
        }
        if (isHeaderConfiguration) {
            this.objectSaverToDiskService.exportAtpEntity(projectConfiguration.getProjectId(), (Object)new ExportImportHeaderConfiguration(projectConfiguration.getHeaderConfiguration()), path.resolve(ExportImportEntities.MIA_PROJECT_CONFIGURATION.getValue()));
            log.info("HeaderConfiguration exported");
        }
        if (isPotConfiguration) {
            this.objectSaverToDiskService.exportAtpEntity(projectConfiguration.getProjectId(), (Object)new ExportImportPotHeaderConfiguration(projectConfiguration.getPotHeaderConfiguration()), path.resolve(ExportImportEntities.MIA_PROJECT_CONFIGURATION.getValue()));
            log.info("PotHeaderConfiguration exported");
        }
    }

    private void exportFiles(ProjectConfiguration projectConfiguration, ExportImportData exportData, Path path) {
        Map<UUID, ProjectDirectory> idToDirectory = ExportImportUtils.createMapIdToExistingDirectory(projectConfiguration);
        ((Set)exportData.getExportScope().getEntities().getOrDefault(ExportImportEntities.MIA_DIRECTORY.getValue(), new HashSet())).stream().map(UUID::fromString).map(idToDirectory::get).forEach(dir -> this.exportForDirectories((ProjectDirectory)dir, path));
        Map<UUID, ProjectFile> idToFile = ExportImportUtils.createMapIdToExistingFile(projectConfiguration);
        ((Set)exportData.getExportScope().getEntities().getOrDefault(ExportImportEntities.MIA_FILES.getValue(), new HashSet())).stream().map(UUID::fromString).map(idToFile::get).forEach(file -> this.exportForFiles(path, (ProjectFile)file));
        log.info("Files exported");
    }

    private void exportForFiles(Path path, ProjectFile exportFile) {
        GridFSFile gridFsFile = this.gridFsService.getFile(exportFile.getGridFsObjectId()).orElseThrow(() -> new MiaExportFileNotFoundException(exportFile.getName(), exportFile.getGridFsObjectId()));
        ExportImportFile eiFile = new ExportImportFile(exportFile);
        this.objectSaverToDiskService.exportAtpEntity(eiFile.getId(), (Object)eiFile, path.resolve(ExportImportEntities.MIA_FILES.getValue()));
        Path miaFilePath = this.fileService.createDirectory(path.resolve(ExportImportEntities.MIA_FILES.getValue()).resolve(ExportImportEntities.GRID_FS_FILE.getValue()).resolve(eiFile.getSourceId().toString()));
        Path targetPath = this.fileService.createFile(exportFile.getName(), miaFilePath);
        byte[] fileStream = this.gridFsService.getByteArrayFromGridFsFile(gridFsFile);
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(fileStream);){
            Files.copy(inputStream, targetPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new MiaExportCopyToFileException(exportFile.getName(), e);
        }
    }

    private void exportForDirectories(ProjectDirectory directory, Path path) {
        ExportImportDirectory exportImportDirectory = new ExportImportDirectory(directory);
        this.objectSaverToDiskService.exportAtpEntity(exportImportDirectory.getId(), (Object)exportImportDirectory, path.resolve(ExportImportEntities.MIA_FILES.getValue()));
        log.info("Directories exported");
    }

    public AtpExportStrategy(FileService fileService, GridFsService gridFsService, ObjectSaverToDiskService objectSaverToDiskService, ProjectConfigurationService projectConfigurationService) {
        this.fileService = fileService;
        this.gridFsService = gridFsService;
        this.objectSaverToDiskService = objectSaverToDiskService;
        this.projectConfigurationService = projectConfigurationService;
    }
}

