/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.kafka.listeners;

import java.util.UUID;
import org.qubership.atp.mia.kafka.model.KafkaRequestImport;
import org.qubership.atp.mia.kafka.model.KafkaResponseImport;
import org.qubership.atp.mia.kafka.service.ItfImportFinishNotificationService;
import org.qubership.atp.mia.kafka.service.ItfImportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"kafka.enable"}, havingValue="true")
public class StartItfImportEventListener {
    private static final Logger log = LoggerFactory.getLogger(StartItfImportEventListener.class);
    private final ItfImportService exportService;
    private final ItfImportFinishNotificationService itfImportFinishNotificationService;

    @KafkaListener(id="${kafka.itf.import.group}", groupId="${kafka.itf.import.group}", topics={"${kafka.itf.import.topic}"}, containerFactory="itfImportContainerFactory", autoStartup="true")
    public void listen(@Payload KafkaRequestImport event) {
        log.info("Start ITF import by event from kafka [{}]", (Object)event);
        try {
            this.exportService.importRequest(event);
        }
        catch (Exception e) {
            KafkaResponseImport response = this.exportService.generateErrorImportResponse(event, e);
            this.itfImportFinishNotificationService.notify(UUID.fromString(response.getId()), response);
        }
    }

    public StartItfImportEventListener(ItfImportService exportService, ItfImportFinishNotificationService itfImportFinishNotificationService) {
        this.exportService = exportService;
        this.itfImportFinishNotificationService = itfImportFinishNotificationService;
    }
}

