/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.kafka.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.UUID;
import org.qubership.atp.mia.kafka.model.KafkaResponseImport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.kafka.core.KafkaTemplate;

@ConditionalOnProperty(value={"kafka.enable"})
public class ItfImportFinishNotificationService {
    private static final Logger log = LoggerFactory.getLogger(ItfImportFinishNotificationService.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final KafkaTemplate<UUID, String> kafkaTemplate;
    private final String topicName;

    public ItfImportFinishNotificationService(String topicName, KafkaTemplate<UUID, String> kafkaTemplate) {
        this.topicName = topicName;
        this.kafkaTemplate = kafkaTemplate;
    }

    public void notify(UUID uuid, KafkaResponseImport importResult) {
        try {
            String payload = objectMapper.writeValueAsString((Object)importResult);
            log.info("ITF import ended with ID #{} and payload {}", (Object)uuid, (Object)payload);
            this.kafkaTemplate.send(this.topicName, (Object)uuid, (Object)payload);
        }
        catch (Exception e) {
            log.error("ITF import notify error. Cannot put terminate event to kafka for {}", (Throwable)e);
        }
    }
}

