/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.kafka.service;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import lombok.NonNull;
import org.qubership.atp.common.lock.LockManager;
import org.qubership.atp.mia.exceptions.itflite.ItfEmptyIdException;
import org.qubership.atp.mia.exceptions.itflite.ItfMethodEmptyException;
import org.qubership.atp.mia.exceptions.itflite.ItfMiaPathEmptyException;
import org.qubership.atp.mia.exceptions.itflite.ItfProcessNameEmptyException;
import org.qubership.atp.mia.exceptions.itflite.ItfProjectIdEmptyException;
import org.qubership.atp.mia.exceptions.itflite.ItfSameRequestInProgressException;
import org.qubership.atp.mia.exceptions.itflite.ItfUrlEmptyException;
import org.qubership.atp.mia.exceptions.itflite.ItfUuidEmptyException;
import org.qubership.atp.mia.exceptions.itflite.ProcessNotCreatedException;
import org.qubership.atp.mia.kafka.model.KafkaRequestImport;
import org.qubership.atp.mia.kafka.model.KafkaRequestImportDetails;
import org.qubership.atp.mia.kafka.model.KafkaResponseImport;
import org.qubership.atp.mia.kafka.model.KafkaResponseImportStatus;
import org.qubership.atp.mia.kafka.service.ItfImportFinishNotificationService;
import org.qubership.atp.mia.model.configuration.ProcessConfiguration;
import org.qubership.atp.mia.model.impl.executable.Command;
import org.qubership.atp.mia.model.impl.executable.GeneralModel;
import org.qubership.atp.mia.model.impl.executable.ProcessSettings;
import org.qubership.atp.mia.model.impl.executable.Rest;
import org.qubership.atp.mia.model.impl.executable.Soap;
import org.qubership.atp.mia.service.MiaContext;
import org.qubership.atp.mia.service.configuration.ProcessConfigurationService;
import org.qubership.atp.mia.service.configuration.ProjectConfigurationService;
import org.qubership.atp.mia.service.configuration.SectionConfigurationService;
import org.qubership.atp.mia.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"kafka.enable"})
public class ItfImportService {
    private static final Logger log = LoggerFactory.getLogger(ItfImportService.class);
    private final MiaContext miaContext;
    private final ProjectConfigurationService configurationService;
    private final ProcessConfigurationService processConfigurationService;
    private final SectionConfigurationService sectionConfigurationService;
    private final LockManager lockManager;
    private final ItfImportFinishNotificationService itfImportFinishNotificationService;
    private Map<String, String> requestMap = new HashMap<String, String>();

    public KafkaResponseImport generateErrorImportResponse(KafkaRequestImport request, Exception e) {
        KafkaResponseImport response = this.generateImportResponse(request);
        response.setStatus(KafkaResponseImportStatus.ERROR);
        response.setErrorMessage(e.getMessage());
        return response;
    }

    public KafkaResponseImport generateFinishedImportResponse(KafkaRequestImport request, String processName) {
        KafkaResponseImport response = this.generateImportResponse(request);
        response.setStatus(KafkaResponseImportStatus.DONE);
        response.setMiaUrl(this.miaContext.prepareMiaURL(request.getMiaPath(), processName));
        response.setErrorMessage("");
        return response;
    }

    public void importRequest(KafkaRequestImport request) {
        this.miaContext.setContext(UUID.fromString(request.getProjectId()), null);
        this.lockManager.executeWithLock("itf request " + request.getMiaPath() + " " + request.getProjectId(), () -> {
            if (this.validateRequestInputs(request)) {
                String mapKey = request.getMiaPath() + request.getProjectId();
                if (this.requestMap.containsKey(mapKey) && !this.requestMap.get(mapKey).equals(request.getRequest().getId())) {
                    throw new ItfSameRequestInProgressException(this.requestMap.get(mapKey));
                }
                this.requestMap.put(mapKey, request.getRequest().getId());
                try {
                    this.execute(request);
                }
                finally {
                    this.requestMap.remove(mapKey);
                }
            }
        });
    }

    private void execute(KafkaRequestImport request) {
        String processName = (request.getMiaProcessName() + "_" + request.getId()).replaceAll("[- ]", "");
        Utils.nameProcessValidator(processName);
        log.info("Create process for ID: {} and name: {}", (Object)request.getId(), (Object)processName);
        this.processConfigurationService.addProcess(this.configurationService.getConfigByProjectId(UUID.fromString(request.getProjectId())), this.processConfigurationService.toDto(this.mapToProcess(request, processName)));
        log.info("Process {} is created.", (Object)processName);
        if (!this.miaContext.getConfig().getProcesses().stream().anyMatch(p -> p.getName().equals(processName))) {
            throw new ProcessNotCreatedException();
        }
        log.info("Sending response to Itf for ID: {} and process : {} ", (Object)request.getId(), (Object)processName);
        this.sendResponseToItf(request, processName);
    }

    private KafkaResponseImport generateImportResponse(@NonNull KafkaRequestImport request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String requestId = request.getId();
        String itfRequestId = request.getRequest().getId();
        return new KafkaResponseImport(requestId, itfRequestId);
    }

    private ProcessConfiguration mapToProcess(KafkaRequestImport request, String processName) {
        GeneralModel newCommand;
        String body;
        String url = Utils.urlEvaluator(request.getRequest().getUrl(), request.getRequest().getQueryParameters());
        String string = body = request.getRequest().getBody() != null ? request.getRequest().getBody().getContent() : "";
        if (request.getRequest().getTransportType() == KafkaRequestImportDetails.KafkaRequestImportType.REST) {
            String headers = Utils.prepareRestHeaders(request.getRequest().getRequestHeaders());
            newCommand = ((Command.CommandBuilder)((Command.CommandBuilder)((GeneralModel.GeneralModelBuilder)Command.builder().rest(Rest.builder().method(request.getRequest().getHttpMethod()).body(body).endpoint(url).headers(headers).build())).type(request.getRequest().getTransportType().toString())).name(request.getMiaProcessName())).build();
        } else {
            LinkedHashMap<String, String> soapDefaultValue = new LinkedHashMap<String, String>();
            soapDefaultValue.put("default_key", "default_value");
            newCommand = ((Command.CommandBuilder)((Command.CommandBuilder)((Command.CommandBuilder)((GeneralModel.GeneralModelBuilder)Command.builder().soap(Soap.builder().endpoint(url).request(body).build())).type(request.getRequest().getTransportType().toString())).name(request.getMiaProcessName())).atpValues(soapDefaultValue)).build();
        }
        return ((ProcessConfiguration.ProcessConfigurationBuilder)((ProcessConfiguration.ProcessConfigurationBuilder)((ProcessConfiguration.ProcessConfigurationBuilder)((ProcessConfiguration.ProcessConfigurationBuilder)ProcessConfiguration.builder().name(processName)).inSections(Collections.singletonList(this.sectionConfigurationService.findSectionByPath(UUID.fromString(request.getProjectId()), request.getMiaPath())))).sections(Collections.singletonList(this.sectionConfigurationService.findSectionByPath(UUID.fromString(request.getProjectId()), request.getMiaPath()).getName()))).processSettings((ProcessSettings)((ProcessSettings.ProcessSettingsBuilder)((ProcessSettings.ProcessSettingsBuilder)ProcessSettings.builder().name(processName)).command((Command)newCommand)).build())).build();
    }

    private String sendResponseToItf(KafkaRequestImport request, String processName) {
        KafkaResponseImport response = this.generateFinishedImportResponse(request, processName);
        this.itfImportFinishNotificationService.notify(UUID.fromString(request.getId()), response);
        return processName;
    }

    private boolean validateRequestInputs(KafkaRequestImport request) {
        if (Strings.isNullOrEmpty((String)request.getId())) {
            throw new ItfUuidEmptyException();
        }
        if (Strings.isNullOrEmpty((String)request.getProjectId())) {
            throw new ItfProjectIdEmptyException();
        }
        if (Strings.isNullOrEmpty((String)request.getMiaPath())) {
            throw new ItfMiaPathEmptyException();
        }
        if (Strings.isNullOrEmpty((String)request.getMiaProcessName())) {
            throw new ItfProcessNameEmptyException();
        }
        if (Strings.isNullOrEmpty((String)request.getRequest().getId())) {
            throw new ItfEmptyIdException();
        }
        if (Strings.isNullOrEmpty((String)request.getRequest().getHttpMethod())) {
            throw new ItfMethodEmptyException();
        }
        if (Strings.isNullOrEmpty((String)request.getRequest().getUrl())) {
            throw new ItfUrlEmptyException();
        }
        return true;
    }

    public ItfImportService(MiaContext miaContext, ProjectConfigurationService configurationService, ProcessConfigurationService processConfigurationService, SectionConfigurationService sectionConfigurationService, LockManager lockManager, ItfImportFinishNotificationService itfImportFinishNotificationService) {
        this.miaContext = miaContext;
        this.configurationService = configurationService;
        this.processConfigurationService = processConfigurationService;
        this.sectionConfigurationService = sectionConfigurationService;
        this.lockManager = lockManager;
        this.itfImportFinishNotificationService = itfImportFinishNotificationService;
    }
}

