/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.configuration;

import com.vladmihalcea.hibernate.type.json.JsonBinaryType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.javers.core.metamodel.annotation.DiffIgnore;
import org.javers.core.metamodel.annotation.DiffInclude;
import org.javers.core.metamodel.annotation.Value;
import org.qubership.atp.mia.model.configuration.CommandPrefix;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;

@Entity
@Table(name="project_common_configuration")
@TypeDef(name="jsonb", typeClass=JsonBinaryType.class)
@Value
public class CommonConfiguration
implements Serializable {
    private static final long serialVersionUID = -1842137845749660674L;
    @Id
    @Column(name="project_id")
    private UUID projectId;
    @Column(name="default_system")
    @DiffInclude
    private String defaultSystem;
    @Column(name="use_variables_inside_variable")
    @DiffInclude
    private boolean useVariablesInsideVariable = false;
    @Column(name="variable_format")
    @DiffInclude
    private String variableFormat;
    @Column(name="save_files_to_working_dir")
    @DiffInclude
    private boolean saveFilesToWorkingDir;
    @Column(name="save_sql_tables_to_file")
    @DiffInclude
    private boolean saveSqlTablesToFile;
    @Column(name="common_variables", columnDefinition="jsonb")
    @Type(type="jsonb")
    @DiffInclude
    private HashMap<String, String> commonVariables;
    @Column(name="next_bill_date_sql")
    @DiffInclude
    private String nextBillDateSql;
    @Column(name="reset_cache_sql")
    @DiffInclude
    private String resetCacheSql;
    @Column(name="ethalon_files_path")
    @DiffInclude
    private String ethalonFilesPath;
    @Column(name="external_environment_prefix")
    @DiffInclude
    private String externalEnvironmentPrefix;
    @Column(name="command_shell_separator")
    @DiffInclude
    private String commandShellSeparator;
    @OneToMany(mappedBy="commonConfiguration", targetEntity=CommandPrefix.class, cascade={CascadeType.MERGE}, orphanRemoval=true)
    @OnDelete(action=OnDeleteAction.CASCADE)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @DiffInclude
    private List<CommandPrefix> commandShellPrefixes;
    @Column(name="geneva_date_mask")
    @DiffInclude
    private String genevaDateMask;
    @Column(name="ssh_rsa_file_path")
    @DiffInclude
    private String sshRsaFilePath;
    @Column(name="lines_amount")
    @DiffInclude
    private int linesAmount;
    @OneToOne(targetEntity=ProjectConfiguration.class, cascade={CascadeType.MERGE})
    @JoinColumn(name="project_id", nullable=false)
    @DiffIgnore
    private ProjectConfiguration projectConfiguration;

    public void setEthalonFilesPath(String ethalonFilesPath) {
        this.ethalonFilesPath = ethalonFilesPath.trim().replaceAll("\\./", "").replaceAll("/", "");
    }

    public void updateShellPrefixes() {
        this.commandShellPrefixes.forEach(prefix -> {
            prefix.setProjectId(this.projectConfiguration != null ? this.projectConfiguration.getProjectId() : this.projectId);
            prefix.setCommonConfiguration(this);
        });
    }

    private static String $default$defaultSystem() {
        return "Billing System";
    }

    private static String $default$variableFormat() {
        return ":VARIABLE_NAME";
    }

    private static boolean $default$saveSqlTablesToFile() {
        return true;
    }

    private static HashMap<String, String> $default$commonVariables() {
        return new HashMap<String, String>();
    }

    private static String $default$nextBillDateSql() {
        return "SELECT NEXT_BILL_DTM FROM ACCOUNT WHERE ACCOUNT_NUM =':accountNumber'";
    }

    private static String $default$resetCacheSql() {
        return "{call gnvsessiongparams.clearcache()}";
    }

    private static String $default$ethalonFilesPath() {
        return "etalon_files";
    }

    private static String $default$externalEnvironmentPrefix() {
        return "";
    }

    private static String $default$commandShellSeparator() {
        return "\n";
    }

    private static List<CommandPrefix> $default$commandShellPrefixes() {
        return new ArrayList<CommandPrefix>();
    }

    private static String $default$genevaDateMask() {
        return "YYYYMMDD HHMMSSSS";
    }

    private static int $default$linesAmount() {
        return 3;
    }

    public static CommonConfigurationBuilder builder() {
        return new CommonConfigurationBuilder();
    }

    public CommonConfigurationBuilder toBuilder() {
        return new CommonConfigurationBuilder().projectId(this.projectId).defaultSystem(this.defaultSystem).useVariablesInsideVariable(this.useVariablesInsideVariable).variableFormat(this.variableFormat).saveFilesToWorkingDir(this.saveFilesToWorkingDir).saveSqlTablesToFile(this.saveSqlTablesToFile).commonVariables(this.commonVariables).nextBillDateSql(this.nextBillDateSql).resetCacheSql(this.resetCacheSql).ethalonFilesPath(this.ethalonFilesPath).externalEnvironmentPrefix(this.externalEnvironmentPrefix).commandShellSeparator(this.commandShellSeparator).commandShellPrefixes(this.commandShellPrefixes).genevaDateMask(this.genevaDateMask).sshRsaFilePath(this.sshRsaFilePath).linesAmount(this.linesAmount).projectConfiguration(this.projectConfiguration);
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public String getDefaultSystem() {
        return this.defaultSystem;
    }

    public boolean isUseVariablesInsideVariable() {
        return this.useVariablesInsideVariable;
    }

    public String getVariableFormat() {
        return this.variableFormat;
    }

    public boolean isSaveFilesToWorkingDir() {
        return this.saveFilesToWorkingDir;
    }

    public boolean isSaveSqlTablesToFile() {
        return this.saveSqlTablesToFile;
    }

    public HashMap<String, String> getCommonVariables() {
        return this.commonVariables;
    }

    public String getNextBillDateSql() {
        return this.nextBillDateSql;
    }

    public String getResetCacheSql() {
        return this.resetCacheSql;
    }

    public String getEthalonFilesPath() {
        return this.ethalonFilesPath;
    }

    public String getExternalEnvironmentPrefix() {
        return this.externalEnvironmentPrefix;
    }

    public String getCommandShellSeparator() {
        return this.commandShellSeparator;
    }

    public List<CommandPrefix> getCommandShellPrefixes() {
        return this.commandShellPrefixes;
    }

    public String getGenevaDateMask() {
        return this.genevaDateMask;
    }

    public String getSshRsaFilePath() {
        return this.sshRsaFilePath;
    }

    public int getLinesAmount() {
        return this.linesAmount;
    }

    public ProjectConfiguration getProjectConfiguration() {
        return this.projectConfiguration;
    }

    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    public void setDefaultSystem(String defaultSystem) {
        this.defaultSystem = defaultSystem;
    }

    public void setUseVariablesInsideVariable(boolean useVariablesInsideVariable) {
        this.useVariablesInsideVariable = useVariablesInsideVariable;
    }

    public void setVariableFormat(String variableFormat) {
        this.variableFormat = variableFormat;
    }

    public void setSaveFilesToWorkingDir(boolean saveFilesToWorkingDir) {
        this.saveFilesToWorkingDir = saveFilesToWorkingDir;
    }

    public void setSaveSqlTablesToFile(boolean saveSqlTablesToFile) {
        this.saveSqlTablesToFile = saveSqlTablesToFile;
    }

    public void setCommonVariables(HashMap<String, String> commonVariables) {
        this.commonVariables = commonVariables;
    }

    public void setNextBillDateSql(String nextBillDateSql) {
        this.nextBillDateSql = nextBillDateSql;
    }

    public void setResetCacheSql(String resetCacheSql) {
        this.resetCacheSql = resetCacheSql;
    }

    public void setExternalEnvironmentPrefix(String externalEnvironmentPrefix) {
        this.externalEnvironmentPrefix = externalEnvironmentPrefix;
    }

    public void setCommandShellSeparator(String commandShellSeparator) {
        this.commandShellSeparator = commandShellSeparator;
    }

    public void setCommandShellPrefixes(List<CommandPrefix> commandShellPrefixes) {
        this.commandShellPrefixes = commandShellPrefixes;
    }

    public void setGenevaDateMask(String genevaDateMask) {
        this.genevaDateMask = genevaDateMask;
    }

    public void setSshRsaFilePath(String sshRsaFilePath) {
        this.sshRsaFilePath = sshRsaFilePath;
    }

    public void setLinesAmount(int linesAmount) {
        this.linesAmount = linesAmount;
    }

    public void setProjectConfiguration(ProjectConfiguration projectConfiguration) {
        this.projectConfiguration = projectConfiguration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonConfiguration)) {
            return false;
        }
        CommonConfiguration other = (CommonConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseVariablesInsideVariable() != other.isUseVariablesInsideVariable()) {
            return false;
        }
        if (this.isSaveFilesToWorkingDir() != other.isSaveFilesToWorkingDir()) {
            return false;
        }
        if (this.isSaveSqlTablesToFile() != other.isSaveSqlTablesToFile()) {
            return false;
        }
        if (this.getLinesAmount() != other.getLinesAmount()) {
            return false;
        }
        UUID this$projectId = this.getProjectId();
        UUID other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        String this$defaultSystem = this.getDefaultSystem();
        String other$defaultSystem = other.getDefaultSystem();
        if (this$defaultSystem == null ? other$defaultSystem != null : !this$defaultSystem.equals(other$defaultSystem)) {
            return false;
        }
        String this$variableFormat = this.getVariableFormat();
        String other$variableFormat = other.getVariableFormat();
        if (this$variableFormat == null ? other$variableFormat != null : !this$variableFormat.equals(other$variableFormat)) {
            return false;
        }
        HashMap<String, String> this$commonVariables = this.getCommonVariables();
        HashMap<String, String> other$commonVariables = other.getCommonVariables();
        if (this$commonVariables == null ? other$commonVariables != null : !((Object)this$commonVariables).equals(other$commonVariables)) {
            return false;
        }
        String this$nextBillDateSql = this.getNextBillDateSql();
        String other$nextBillDateSql = other.getNextBillDateSql();
        if (this$nextBillDateSql == null ? other$nextBillDateSql != null : !this$nextBillDateSql.equals(other$nextBillDateSql)) {
            return false;
        }
        String this$resetCacheSql = this.getResetCacheSql();
        String other$resetCacheSql = other.getResetCacheSql();
        if (this$resetCacheSql == null ? other$resetCacheSql != null : !this$resetCacheSql.equals(other$resetCacheSql)) {
            return false;
        }
        String this$ethalonFilesPath = this.getEthalonFilesPath();
        String other$ethalonFilesPath = other.getEthalonFilesPath();
        if (this$ethalonFilesPath == null ? other$ethalonFilesPath != null : !this$ethalonFilesPath.equals(other$ethalonFilesPath)) {
            return false;
        }
        String this$externalEnvironmentPrefix = this.getExternalEnvironmentPrefix();
        String other$externalEnvironmentPrefix = other.getExternalEnvironmentPrefix();
        if (this$externalEnvironmentPrefix == null ? other$externalEnvironmentPrefix != null : !this$externalEnvironmentPrefix.equals(other$externalEnvironmentPrefix)) {
            return false;
        }
        String this$commandShellSeparator = this.getCommandShellSeparator();
        String other$commandShellSeparator = other.getCommandShellSeparator();
        if (this$commandShellSeparator == null ? other$commandShellSeparator != null : !this$commandShellSeparator.equals(other$commandShellSeparator)) {
            return false;
        }
        List<CommandPrefix> this$commandShellPrefixes = this.getCommandShellPrefixes();
        List<CommandPrefix> other$commandShellPrefixes = other.getCommandShellPrefixes();
        if (this$commandShellPrefixes == null ? other$commandShellPrefixes != null : !((Object)this$commandShellPrefixes).equals(other$commandShellPrefixes)) {
            return false;
        }
        String this$genevaDateMask = this.getGenevaDateMask();
        String other$genevaDateMask = other.getGenevaDateMask();
        if (this$genevaDateMask == null ? other$genevaDateMask != null : !this$genevaDateMask.equals(other$genevaDateMask)) {
            return false;
        }
        String this$sshRsaFilePath = this.getSshRsaFilePath();
        String other$sshRsaFilePath = other.getSshRsaFilePath();
        return !(this$sshRsaFilePath == null ? other$sshRsaFilePath != null : !this$sshRsaFilePath.equals(other$sshRsaFilePath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommonConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseVariablesInsideVariable() ? 79 : 97);
        result = result * 59 + (this.isSaveFilesToWorkingDir() ? 79 : 97);
        result = result * 59 + (this.isSaveSqlTablesToFile() ? 79 : 97);
        result = result * 59 + this.getLinesAmount();
        UUID $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        String $defaultSystem = this.getDefaultSystem();
        result = result * 59 + ($defaultSystem == null ? 43 : $defaultSystem.hashCode());
        String $variableFormat = this.getVariableFormat();
        result = result * 59 + ($variableFormat == null ? 43 : $variableFormat.hashCode());
        HashMap<String, String> $commonVariables = this.getCommonVariables();
        result = result * 59 + ($commonVariables == null ? 43 : ((Object)$commonVariables).hashCode());
        String $nextBillDateSql = this.getNextBillDateSql();
        result = result * 59 + ($nextBillDateSql == null ? 43 : $nextBillDateSql.hashCode());
        String $resetCacheSql = this.getResetCacheSql();
        result = result * 59 + ($resetCacheSql == null ? 43 : $resetCacheSql.hashCode());
        String $ethalonFilesPath = this.getEthalonFilesPath();
        result = result * 59 + ($ethalonFilesPath == null ? 43 : $ethalonFilesPath.hashCode());
        String $externalEnvironmentPrefix = this.getExternalEnvironmentPrefix();
        result = result * 59 + ($externalEnvironmentPrefix == null ? 43 : $externalEnvironmentPrefix.hashCode());
        String $commandShellSeparator = this.getCommandShellSeparator();
        result = result * 59 + ($commandShellSeparator == null ? 43 : $commandShellSeparator.hashCode());
        List<CommandPrefix> $commandShellPrefixes = this.getCommandShellPrefixes();
        result = result * 59 + ($commandShellPrefixes == null ? 43 : ((Object)$commandShellPrefixes).hashCode());
        String $genevaDateMask = this.getGenevaDateMask();
        result = result * 59 + ($genevaDateMask == null ? 43 : $genevaDateMask.hashCode());
        String $sshRsaFilePath = this.getSshRsaFilePath();
        result = result * 59 + ($sshRsaFilePath == null ? 43 : $sshRsaFilePath.hashCode());
        return result;
    }

    public String toString() {
        return "CommonConfiguration(projectId=" + this.getProjectId() + ", defaultSystem=" + this.getDefaultSystem() + ", useVariablesInsideVariable=" + this.isUseVariablesInsideVariable() + ", variableFormat=" + this.getVariableFormat() + ", saveFilesToWorkingDir=" + this.isSaveFilesToWorkingDir() + ", saveSqlTablesToFile=" + this.isSaveSqlTablesToFile() + ", commonVariables=" + this.getCommonVariables() + ", nextBillDateSql=" + this.getNextBillDateSql() + ", resetCacheSql=" + this.getResetCacheSql() + ", ethalonFilesPath=" + this.getEthalonFilesPath() + ", externalEnvironmentPrefix=" + this.getExternalEnvironmentPrefix() + ", commandShellSeparator=" + this.getCommandShellSeparator() + ", commandShellPrefixes=" + this.getCommandShellPrefixes() + ", genevaDateMask=" + this.getGenevaDateMask() + ", sshRsaFilePath=" + this.getSshRsaFilePath() + ", linesAmount=" + this.getLinesAmount() + ")";
    }

    public CommonConfiguration() {
        this.defaultSystem = CommonConfiguration.$default$defaultSystem();
        this.variableFormat = CommonConfiguration.$default$variableFormat();
        this.saveSqlTablesToFile = CommonConfiguration.$default$saveSqlTablesToFile();
        this.commonVariables = CommonConfiguration.$default$commonVariables();
        this.nextBillDateSql = CommonConfiguration.$default$nextBillDateSql();
        this.resetCacheSql = CommonConfiguration.$default$resetCacheSql();
        this.ethalonFilesPath = CommonConfiguration.$default$ethalonFilesPath();
        this.externalEnvironmentPrefix = CommonConfiguration.$default$externalEnvironmentPrefix();
        this.commandShellSeparator = CommonConfiguration.$default$commandShellSeparator();
        this.commandShellPrefixes = CommonConfiguration.$default$commandShellPrefixes();
        this.genevaDateMask = CommonConfiguration.$default$genevaDateMask();
        this.linesAmount = CommonConfiguration.$default$linesAmount();
    }

    public CommonConfiguration(UUID projectId, String defaultSystem, boolean useVariablesInsideVariable, String variableFormat, boolean saveFilesToWorkingDir, boolean saveSqlTablesToFile, HashMap<String, String> commonVariables, String nextBillDateSql, String resetCacheSql, String ethalonFilesPath, String externalEnvironmentPrefix, String commandShellSeparator, List<CommandPrefix> commandShellPrefixes, String genevaDateMask, String sshRsaFilePath, int linesAmount, ProjectConfiguration projectConfiguration) {
        this.projectId = projectId;
        this.defaultSystem = defaultSystem;
        this.useVariablesInsideVariable = useVariablesInsideVariable;
        this.variableFormat = variableFormat;
        this.saveFilesToWorkingDir = saveFilesToWorkingDir;
        this.saveSqlTablesToFile = saveSqlTablesToFile;
        this.commonVariables = commonVariables;
        this.nextBillDateSql = nextBillDateSql;
        this.resetCacheSql = resetCacheSql;
        this.ethalonFilesPath = ethalonFilesPath;
        this.externalEnvironmentPrefix = externalEnvironmentPrefix;
        this.commandShellSeparator = commandShellSeparator;
        this.commandShellPrefixes = commandShellPrefixes;
        this.genevaDateMask = genevaDateMask;
        this.sshRsaFilePath = sshRsaFilePath;
        this.linesAmount = linesAmount;
        this.projectConfiguration = projectConfiguration;
    }

    public static class CommonConfigurationBuilder {
        private UUID projectId;
        private boolean defaultSystem$set;
        private String defaultSystem$value;
        private boolean useVariablesInsideVariable;
        private boolean variableFormat$set;
        private String variableFormat$value;
        private boolean saveFilesToWorkingDir;
        private boolean saveSqlTablesToFile$set;
        private boolean saveSqlTablesToFile$value;
        private boolean commonVariables$set;
        private HashMap<String, String> commonVariables$value;
        private boolean nextBillDateSql$set;
        private String nextBillDateSql$value;
        private boolean resetCacheSql$set;
        private String resetCacheSql$value;
        private boolean ethalonFilesPath$set;
        private String ethalonFilesPath$value;
        private boolean externalEnvironmentPrefix$set;
        private String externalEnvironmentPrefix$value;
        private boolean commandShellSeparator$set;
        private String commandShellSeparator$value;
        private boolean commandShellPrefixes$set;
        private List<CommandPrefix> commandShellPrefixes$value;
        private boolean genevaDateMask$set;
        private String genevaDateMask$value;
        private String sshRsaFilePath;
        private boolean linesAmount$set;
        private int linesAmount$value;
        private ProjectConfiguration projectConfiguration;

        CommonConfigurationBuilder() {
        }

        public CommonConfigurationBuilder projectId(UUID projectId) {
            this.projectId = projectId;
            return this;
        }

        public CommonConfigurationBuilder defaultSystem(String defaultSystem) {
            this.defaultSystem$value = defaultSystem;
            this.defaultSystem$set = true;
            return this;
        }

        public CommonConfigurationBuilder useVariablesInsideVariable(boolean useVariablesInsideVariable) {
            this.useVariablesInsideVariable = useVariablesInsideVariable;
            return this;
        }

        public CommonConfigurationBuilder variableFormat(String variableFormat) {
            this.variableFormat$value = variableFormat;
            this.variableFormat$set = true;
            return this;
        }

        public CommonConfigurationBuilder saveFilesToWorkingDir(boolean saveFilesToWorkingDir) {
            this.saveFilesToWorkingDir = saveFilesToWorkingDir;
            return this;
        }

        public CommonConfigurationBuilder saveSqlTablesToFile(boolean saveSqlTablesToFile) {
            this.saveSqlTablesToFile$value = saveSqlTablesToFile;
            this.saveSqlTablesToFile$set = true;
            return this;
        }

        public CommonConfigurationBuilder commonVariables(HashMap<String, String> commonVariables) {
            this.commonVariables$value = commonVariables;
            this.commonVariables$set = true;
            return this;
        }

        public CommonConfigurationBuilder nextBillDateSql(String nextBillDateSql) {
            this.nextBillDateSql$value = nextBillDateSql;
            this.nextBillDateSql$set = true;
            return this;
        }

        public CommonConfigurationBuilder resetCacheSql(String resetCacheSql) {
            this.resetCacheSql$value = resetCacheSql;
            this.resetCacheSql$set = true;
            return this;
        }

        public CommonConfigurationBuilder ethalonFilesPath(String ethalonFilesPath) {
            this.ethalonFilesPath$value = ethalonFilesPath;
            this.ethalonFilesPath$set = true;
            return this;
        }

        public CommonConfigurationBuilder externalEnvironmentPrefix(String externalEnvironmentPrefix) {
            this.externalEnvironmentPrefix$value = externalEnvironmentPrefix;
            this.externalEnvironmentPrefix$set = true;
            return this;
        }

        public CommonConfigurationBuilder commandShellSeparator(String commandShellSeparator) {
            this.commandShellSeparator$value = commandShellSeparator;
            this.commandShellSeparator$set = true;
            return this;
        }

        public CommonConfigurationBuilder commandShellPrefixes(List<CommandPrefix> commandShellPrefixes) {
            this.commandShellPrefixes$value = commandShellPrefixes;
            this.commandShellPrefixes$set = true;
            return this;
        }

        public CommonConfigurationBuilder genevaDateMask(String genevaDateMask) {
            this.genevaDateMask$value = genevaDateMask;
            this.genevaDateMask$set = true;
            return this;
        }

        public CommonConfigurationBuilder sshRsaFilePath(String sshRsaFilePath) {
            this.sshRsaFilePath = sshRsaFilePath;
            return this;
        }

        public CommonConfigurationBuilder linesAmount(int linesAmount) {
            this.linesAmount$value = linesAmount;
            this.linesAmount$set = true;
            return this;
        }

        public CommonConfigurationBuilder projectConfiguration(ProjectConfiguration projectConfiguration) {
            this.projectConfiguration = projectConfiguration;
            return this;
        }

        public CommonConfiguration build() {
            String defaultSystem$value = this.defaultSystem$value;
            if (!this.defaultSystem$set) {
                defaultSystem$value = CommonConfiguration.$default$defaultSystem();
            }
            String variableFormat$value = this.variableFormat$value;
            if (!this.variableFormat$set) {
                variableFormat$value = CommonConfiguration.$default$variableFormat();
            }
            boolean saveSqlTablesToFile$value = this.saveSqlTablesToFile$value;
            if (!this.saveSqlTablesToFile$set) {
                saveSqlTablesToFile$value = CommonConfiguration.$default$saveSqlTablesToFile();
            }
            HashMap commonVariables$value = this.commonVariables$value;
            if (!this.commonVariables$set) {
                commonVariables$value = CommonConfiguration.$default$commonVariables();
            }
            String nextBillDateSql$value = this.nextBillDateSql$value;
            if (!this.nextBillDateSql$set) {
                nextBillDateSql$value = CommonConfiguration.$default$nextBillDateSql();
            }
            String resetCacheSql$value = this.resetCacheSql$value;
            if (!this.resetCacheSql$set) {
                resetCacheSql$value = CommonConfiguration.$default$resetCacheSql();
            }
            String ethalonFilesPath$value = this.ethalonFilesPath$value;
            if (!this.ethalonFilesPath$set) {
                ethalonFilesPath$value = CommonConfiguration.$default$ethalonFilesPath();
            }
            String externalEnvironmentPrefix$value = this.externalEnvironmentPrefix$value;
            if (!this.externalEnvironmentPrefix$set) {
                externalEnvironmentPrefix$value = CommonConfiguration.$default$externalEnvironmentPrefix();
            }
            String commandShellSeparator$value = this.commandShellSeparator$value;
            if (!this.commandShellSeparator$set) {
                commandShellSeparator$value = CommonConfiguration.$default$commandShellSeparator();
            }
            List commandShellPrefixes$value = this.commandShellPrefixes$value;
            if (!this.commandShellPrefixes$set) {
                commandShellPrefixes$value = CommonConfiguration.$default$commandShellPrefixes();
            }
            String genevaDateMask$value = this.genevaDateMask$value;
            if (!this.genevaDateMask$set) {
                genevaDateMask$value = CommonConfiguration.$default$genevaDateMask();
            }
            int linesAmount$value = this.linesAmount$value;
            if (!this.linesAmount$set) {
                linesAmount$value = CommonConfiguration.$default$linesAmount();
            }
            return new CommonConfiguration(this.projectId, defaultSystem$value, this.useVariablesInsideVariable, variableFormat$value, this.saveFilesToWorkingDir, saveSqlTablesToFile$value, commonVariables$value, nextBillDateSql$value, resetCacheSql$value, ethalonFilesPath$value, externalEnvironmentPrefix$value, commandShellSeparator$value, commandShellPrefixes$value, genevaDateMask$value, this.sshRsaFilePath, linesAmount$value, this.projectConfiguration);
        }

        public String toString() {
            return "CommonConfiguration.CommonConfigurationBuilder(projectId=" + this.projectId + ", defaultSystem$value=" + this.defaultSystem$value + ", useVariablesInsideVariable=" + this.useVariablesInsideVariable + ", variableFormat$value=" + this.variableFormat$value + ", saveFilesToWorkingDir=" + this.saveFilesToWorkingDir + ", saveSqlTablesToFile$value=" + this.saveSqlTablesToFile$value + ", commonVariables$value=" + this.commonVariables$value + ", nextBillDateSql$value=" + this.nextBillDateSql$value + ", resetCacheSql$value=" + this.resetCacheSql$value + ", ethalonFilesPath$value=" + this.ethalonFilesPath$value + ", externalEnvironmentPrefix$value=" + this.externalEnvironmentPrefix$value + ", commandShellSeparator$value=" + this.commandShellSeparator$value + ", commandShellPrefixes$value=" + this.commandShellPrefixes$value + ", genevaDateMask$value=" + this.genevaDateMask$value + ", sshRsaFilePath=" + this.sshRsaFilePath + ", linesAmount$value=" + this.linesAmount$value + ", projectConfiguration=" + this.projectConfiguration + ")";
        }
    }
}

