/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.configuration;

import com.vladmihalcea.hibernate.type.json.JsonBinaryType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.javers.core.metamodel.annotation.DiffIgnore;
import org.javers.core.metamodel.annotation.DiffInclude;
import org.javers.core.metamodel.annotation.Value;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.impl.executable.PotHeader;

@Entity
@Table(name="project_pot_header_configuration")
@TypeDef(name="jsonb", typeClass=JsonBinaryType.class)
@Value
public class PotHeaderConfiguration
implements Serializable {
    private static final long serialVersionUID = -4051242360768974857L;
    @Id
    @Column(name="project_id")
    private UUID projectId;
    @Column(name="headers", columnDefinition="jsonb")
    @Type(type="jsonb")
    @DiffInclude
    private List<PotHeader> headers = new ArrayList<PotHeader>();
    @OneToOne(targetEntity=ProjectConfiguration.class, cascade={CascadeType.MERGE})
    @JoinColumn(name="project_id", nullable=false)
    @DiffIgnore
    private ProjectConfiguration projectConfiguration;

    public static PotHeaderConfigurationBuilder builder() {
        return new PotHeaderConfigurationBuilder();
    }

    public PotHeaderConfigurationBuilder toBuilder() {
        return new PotHeaderConfigurationBuilder().projectId(this.projectId).headers(this.headers).projectConfiguration(this.projectConfiguration);
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public List<PotHeader> getHeaders() {
        return this.headers;
    }

    public ProjectConfiguration getProjectConfiguration() {
        return this.projectConfiguration;
    }

    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    public void setHeaders(List<PotHeader> headers) {
        this.headers = headers;
    }

    public void setProjectConfiguration(ProjectConfiguration projectConfiguration) {
        this.projectConfiguration = projectConfiguration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PotHeaderConfiguration)) {
            return false;
        }
        PotHeaderConfiguration other = (PotHeaderConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$projectId = this.getProjectId();
        UUID other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        List<PotHeader> this$headers = this.getHeaders();
        List<PotHeader> other$headers = other.getHeaders();
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PotHeaderConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        List<PotHeader> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    public String toString() {
        return "PotHeaderConfiguration(projectId=" + this.getProjectId() + ", headers=" + this.getHeaders() + ")";
    }

    public PotHeaderConfiguration(UUID projectId, List<PotHeader> headers, ProjectConfiguration projectConfiguration) {
        this.projectId = projectId;
        this.headers = headers;
        this.projectConfiguration = projectConfiguration;
    }

    public PotHeaderConfiguration() {
    }

    public static class PotHeaderConfigurationBuilder {
        private UUID projectId;
        private List<PotHeader> headers;
        private ProjectConfiguration projectConfiguration;

        PotHeaderConfigurationBuilder() {
        }

        public PotHeaderConfigurationBuilder projectId(UUID projectId) {
            this.projectId = projectId;
            return this;
        }

        public PotHeaderConfigurationBuilder headers(List<PotHeader> headers) {
            this.headers = headers;
            return this;
        }

        public PotHeaderConfigurationBuilder projectConfiguration(ProjectConfiguration projectConfiguration) {
            this.projectConfiguration = projectConfiguration;
            return this;
        }

        public PotHeaderConfiguration build() {
            return new PotHeaderConfiguration(this.projectId, this.headers, this.projectConfiguration);
        }

        public String toString() {
            return "PotHeaderConfiguration.PotHeaderConfigurationBuilder(projectId=" + this.projectId + ", headers=" + this.headers + ", projectConfiguration=" + this.projectConfiguration + ")";
        }
    }
}

