/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.environment;

import java.util.List;
import java.util.UUID;
import org.qubership.atp.mia.model.environment.AbstractConfiguratorModel;
import org.qubership.atp.mia.model.environment.Connection;
import org.qubership.atp.mia.model.environment.Server;

public class System
extends AbstractConfiguratorModel {
    private UUID environmentId;
    private List<Connection> connections;

    public Server getServer(Server.ConnectionType type) throws IllegalArgumentException {
        return this.getServer(type.getType());
    }

    public Server getServer(String name) throws IllegalArgumentException {
        return new Server(this.connections.stream().filter(system -> name.equalsIgnoreCase(system.getName())).findFirst().orElseThrow(() -> new IllegalArgumentException("Connection '" + name + "' not found")), name);
    }

    public Server getServer(Connection.SourceTemplateId templateId) throws IllegalArgumentException {
        String name = templateId.name().toLowerCase();
        return new Server(this.connections.stream().filter(connection -> templateId.id.equals(connection.getSourceTemplateId())).findFirst().orElseThrow(() -> new IllegalArgumentException("Connection '" + name + "' not found")), templateId.name().toUpperCase());
    }

    protected System(SystemBuilder<?, ?> b) {
        super(b);
        this.environmentId = ((SystemBuilder)b).environmentId;
        this.connections = ((SystemBuilder)b).connections;
    }

    public static SystemBuilder<?, ?> builder() {
        return new SystemBuilderImpl();
    }

    public UUID getEnvironmentId() {
        return this.environmentId;
    }

    public List<Connection> getConnections() {
        return this.connections;
    }

    public void setEnvironmentId(UUID environmentId) {
        this.environmentId = environmentId;
    }

    public void setConnections(List<Connection> connections) {
        this.connections = connections;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof System)) {
            return false;
        }
        System other = (System)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$environmentId = this.getEnvironmentId();
        UUID other$environmentId = other.getEnvironmentId();
        if (this$environmentId == null ? other$environmentId != null : !((Object)this$environmentId).equals(other$environmentId)) {
            return false;
        }
        List<Connection> this$connections = this.getConnections();
        List<Connection> other$connections = other.getConnections();
        return !(this$connections == null ? other$connections != null : !((Object)this$connections).equals(other$connections));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof System;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $environmentId = this.getEnvironmentId();
        result = result * 59 + ($environmentId == null ? 43 : ((Object)$environmentId).hashCode());
        List<Connection> $connections = this.getConnections();
        result = result * 59 + ($connections == null ? 43 : ((Object)$connections).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "System(environmentId=" + this.getEnvironmentId() + ", connections=" + this.getConnections() + ")";
    }

    public System() {
    }

    public static abstract class SystemBuilder<C extends System, B extends SystemBuilder<C, B>>
    extends AbstractConfiguratorModel.AbstractConfiguratorModelBuilder<C, B> {
        private UUID environmentId;
        private List<Connection> connections;

        public B environmentId(UUID environmentId) {
            this.environmentId = environmentId;
            return (B)this.self();
        }

        public B connections(List<Connection> connections) {
            this.connections = connections;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "System.SystemBuilder(super=" + super.toString() + ", environmentId=" + this.environmentId + ", connections=" + this.connections + ")";
        }
    }

    private static final class SystemBuilderImpl
    extends SystemBuilder<System, SystemBuilderImpl> {
        private SystemBuilderImpl() {
        }

        @Override
        protected SystemBuilderImpl self() {
            return this;
        }

        @Override
        public System build() {
            return new System(this);
        }
    }
}

