/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.file;

import com.google.common.base.Strings;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import org.qubership.atp.mia.exceptions.configuration.FileMetaDataNotFoundException;
import org.qubership.atp.mia.model.file.ProjectFileType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMetaData {
    private static final Logger log = LoggerFactory.getLogger(FileMetaData.class);
    public static final Path PROJECT_FOLDER = Paths.get("PROJECT_FOLDER", new String[0]);
    private final UUID projectId;
    private final String fileName;
    private final ProjectFileType projectFileType;
    private String contentType;

    public FileMetaData(UUID projectId, String fileName, ProjectFileType projectFileType) {
        this.projectId = projectId;
        this.projectFileType = projectFileType;
        this.fileName = fileName.replaceFirst(".*" + projectFileType.name(), projectFileType.name());
    }

    public static FileMetaData log(UUID projectId, String fileName) {
        return new FileMetaData(projectId, fileName, ProjectFileType.MIA_FILE_TYPE_LOG);
    }

    public static FileMetaData upload(UUID projectId, String fileName) {
        return new FileMetaData(projectId, fileName, ProjectFileType.MIA_FILE_TYPE_UPLOAD);
    }

    public static FileMetaData project(UUID projectId, String fileName) {
        return new FileMetaData(projectId, fileName, ProjectFileType.MIA_FILE_TYPE_PROJECT);
    }

    public static FileMetaData configuration(UUID projectId, String fileName) {
        return new FileMetaData(projectId, fileName, ProjectFileType.MIA_FILE_TYPE_CONFIGURATION);
    }

    public static FileMetaData define(UUID projectId, String fileName) throws IllegalArgumentException {
        Path projFolder = PROJECT_FOLDER.resolve(projectId.toString());
        Path pathCompare = projFolder.resolve(ProjectFileType.MIA_FILE_TYPE_LOG.name());
        if (fileName.startsWith(pathCompare.toString())) {
            return FileMetaData.log(projectId, fileName.replace(projFolder.toString(), ""));
        }
        pathCompare = projFolder.resolve(ProjectFileType.MIA_FILE_TYPE_UPLOAD.name());
        if (fileName.startsWith(pathCompare.toString())) {
            return FileMetaData.upload(projectId, fileName.replace(projFolder.toString(), ""));
        }
        pathCompare = projFolder.resolve(ProjectFileType.MIA_FILE_TYPE_PROJECT.name());
        if (fileName.startsWith(pathCompare.toString())) {
            return FileMetaData.project(projectId, fileName.replace(projFolder.toString(), ""));
        }
        pathCompare = projFolder.resolve(ProjectFileType.MIA_FILE_TYPE_CONFIGURATION.name());
        if (fileName.startsWith(pathCompare.toString())) {
            return FileMetaData.configuration(projectId, fileName.replace(projFolder.toString(), ""));
        }
        throw new FileMetaDataNotFoundException(fileName);
    }

    public String getContentType() {
        if (Strings.isNullOrEmpty((String)this.contentType)) {
            this.contentType = "plain/text";
        }
        return this.contentType;
    }

    public String getFileExtension() {
        int lastIndex = this.fileName.lastIndexOf(46);
        String contentType = "unknown";
        if (lastIndex > -1) {
            contentType = this.fileName.substring(lastIndex + 1);
        }
        return contentType;
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public ProjectFileType getProjectFileType() {
        return this.projectFileType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileMetaData)) {
            return false;
        }
        FileMetaData other = (FileMetaData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$projectId = this.getProjectId();
        UUID other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        ProjectFileType this$projectFileType = this.getProjectFileType();
        ProjectFileType other$projectFileType = other.getProjectFileType();
        if (this$projectFileType == null ? other$projectFileType != null : !((Object)((Object)this$projectFileType)).equals((Object)other$projectFileType)) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        return !(this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileMetaData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        ProjectFileType $projectFileType = this.getProjectFileType();
        result = result * 59 + ($projectFileType == null ? 43 : ((Object)((Object)$projectFileType)).hashCode());
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        return result;
    }

    public String toString() {
        return "FileMetaData(projectId=" + this.getProjectId() + ", fileName=" + this.getFileName() + ", projectFileType=" + (Object)((Object)this.getProjectFileType()) + ", contentType=" + this.getContentType() + ")";
    }

    public FileMetaData(UUID projectId, String fileName, ProjectFileType projectFileType, String contentType) {
        this.projectId = projectId;
        this.fileName = fileName;
        this.projectFileType = projectFileType;
        this.contentType = contentType;
    }
}

