/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.qubership.atp.mia.exceptions.MiaException;
import org.qubership.atp.mia.model.impl.CommandResponse;
import org.qubership.atp.mia.model.pot.ProcessStatus;
import org.qubership.atp.mia.model.pot.Statuses;
import org.qubership.atp.mia.model.pot.db.SqlResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class ExecutionResponse
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ExecutionResponse.class);
    private static final long serialVersionUID = 24941995508251952L;
    @Nullable
    private UUID sseId;
    private int order;
    private boolean finalMessage;
    private String processName;
    private String executedCommand;
    private CommandResponse commandResponse;
    private List<SqlResponse> validations;
    @Nullable
    private List<CommandResponse> prerequisites;
    @Nullable
    private ProcessStatus processStatus;
    @Nullable
    private MiaException error;
    @Nullable
    private HashMap<String, String> globalVariables;
    private String entityUrl;
    private UUID entityId;
    private long duration;

    public void setWarn(String warning) {
        if (this.processStatus == null) {
            log.debug("process status is null, initiating it with empty value");
            this.processStatus = new ProcessStatus();
        }
        if (!this.processStatus.getStatus().equals((Object)Statuses.FAIL)) {
            log.debug("process status not fail, but [{}], so setting it to WARNING", (Object)this.processStatus.getStatus());
            this.processStatus.setStatus(Statuses.WARNING);
        }
        if (this.commandResponse == null) {
            this.commandResponse = new CommandResponse();
        }
        this.commandResponse.addDescription(warning);
    }

    @Nullable
    public UUID getSseId() {
        return this.sseId;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isFinalMessage() {
        return this.finalMessage;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getExecutedCommand() {
        return this.executedCommand;
    }

    public CommandResponse getCommandResponse() {
        return this.commandResponse;
    }

    public List<SqlResponse> getValidations() {
        return this.validations;
    }

    @Nullable
    public List<CommandResponse> getPrerequisites() {
        return this.prerequisites;
    }

    @Nullable
    public ProcessStatus getProcessStatus() {
        return this.processStatus;
    }

    @Nullable
    public MiaException getError() {
        return this.error;
    }

    @Nullable
    public HashMap<String, String> getGlobalVariables() {
        return this.globalVariables;
    }

    public String getEntityUrl() {
        return this.entityUrl;
    }

    public UUID getEntityId() {
        return this.entityId;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setSseId(@Nullable UUID sseId) {
        this.sseId = sseId;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setFinalMessage(boolean finalMessage) {
        this.finalMessage = finalMessage;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public void setExecutedCommand(String executedCommand) {
        this.executedCommand = executedCommand;
    }

    public void setCommandResponse(CommandResponse commandResponse) {
        this.commandResponse = commandResponse;
    }

    public void setValidations(List<SqlResponse> validations) {
        this.validations = validations;
    }

    public void setPrerequisites(@Nullable List<CommandResponse> prerequisites) {
        this.prerequisites = prerequisites;
    }

    public void setProcessStatus(@Nullable ProcessStatus processStatus) {
        this.processStatus = processStatus;
    }

    public void setError(@Nullable MiaException error) {
        this.error = error;
    }

    public void setGlobalVariables(@Nullable HashMap<String, String> globalVariables) {
        this.globalVariables = globalVariables;
    }

    public void setEntityUrl(String entityUrl) {
        this.entityUrl = entityUrl;
    }

    public void setEntityId(UUID entityId) {
        this.entityId = entityId;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutionResponse)) {
            return false;
        }
        ExecutionResponse other = (ExecutionResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOrder() != other.getOrder()) {
            return false;
        }
        if (this.isFinalMessage() != other.isFinalMessage()) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        UUID this$sseId = this.getSseId();
        UUID other$sseId = other.getSseId();
        if (this$sseId == null ? other$sseId != null : !((Object)this$sseId).equals(other$sseId)) {
            return false;
        }
        String this$processName = this.getProcessName();
        String other$processName = other.getProcessName();
        if (this$processName == null ? other$processName != null : !this$processName.equals(other$processName)) {
            return false;
        }
        String this$executedCommand = this.getExecutedCommand();
        String other$executedCommand = other.getExecutedCommand();
        if (this$executedCommand == null ? other$executedCommand != null : !this$executedCommand.equals(other$executedCommand)) {
            return false;
        }
        CommandResponse this$commandResponse = this.getCommandResponse();
        CommandResponse other$commandResponse = other.getCommandResponse();
        if (this$commandResponse == null ? other$commandResponse != null : !((Object)this$commandResponse).equals(other$commandResponse)) {
            return false;
        }
        List<SqlResponse> this$validations = this.getValidations();
        List<SqlResponse> other$validations = other.getValidations();
        if (this$validations == null ? other$validations != null : !((Object)this$validations).equals(other$validations)) {
            return false;
        }
        List<CommandResponse> this$prerequisites = this.getPrerequisites();
        List<CommandResponse> other$prerequisites = other.getPrerequisites();
        if (this$prerequisites == null ? other$prerequisites != null : !((Object)this$prerequisites).equals(other$prerequisites)) {
            return false;
        }
        ProcessStatus this$processStatus = this.getProcessStatus();
        ProcessStatus other$processStatus = other.getProcessStatus();
        if (this$processStatus == null ? other$processStatus != null : !((Object)this$processStatus).equals(other$processStatus)) {
            return false;
        }
        MiaException this$error = this.getError();
        MiaException other$error = other.getError();
        if (this$error == null ? other$error != null : !((Object)((Object)this$error)).equals((Object)other$error)) {
            return false;
        }
        HashMap<String, String> this$globalVariables = this.getGlobalVariables();
        HashMap<String, String> other$globalVariables = other.getGlobalVariables();
        if (this$globalVariables == null ? other$globalVariables != null : !((Object)this$globalVariables).equals(other$globalVariables)) {
            return false;
        }
        String this$entityUrl = this.getEntityUrl();
        String other$entityUrl = other.getEntityUrl();
        if (this$entityUrl == null ? other$entityUrl != null : !this$entityUrl.equals(other$entityUrl)) {
            return false;
        }
        UUID this$entityId = this.getEntityId();
        UUID other$entityId = other.getEntityId();
        return !(this$entityId == null ? other$entityId != null : !((Object)this$entityId).equals(other$entityId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExecutionResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOrder();
        result = result * 59 + (this.isFinalMessage() ? 79 : 97);
        long $duration = this.getDuration();
        result = result * 59 + (int)($duration >>> 32 ^ $duration);
        UUID $sseId = this.getSseId();
        result = result * 59 + ($sseId == null ? 43 : ((Object)$sseId).hashCode());
        String $processName = this.getProcessName();
        result = result * 59 + ($processName == null ? 43 : $processName.hashCode());
        String $executedCommand = this.getExecutedCommand();
        result = result * 59 + ($executedCommand == null ? 43 : $executedCommand.hashCode());
        CommandResponse $commandResponse = this.getCommandResponse();
        result = result * 59 + ($commandResponse == null ? 43 : ((Object)$commandResponse).hashCode());
        List<SqlResponse> $validations = this.getValidations();
        result = result * 59 + ($validations == null ? 43 : ((Object)$validations).hashCode());
        List<CommandResponse> $prerequisites = this.getPrerequisites();
        result = result * 59 + ($prerequisites == null ? 43 : ((Object)$prerequisites).hashCode());
        ProcessStatus $processStatus = this.getProcessStatus();
        result = result * 59 + ($processStatus == null ? 43 : ((Object)$processStatus).hashCode());
        MiaException $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)((Object)$error)).hashCode());
        HashMap<String, String> $globalVariables = this.getGlobalVariables();
        result = result * 59 + ($globalVariables == null ? 43 : ((Object)$globalVariables).hashCode());
        String $entityUrl = this.getEntityUrl();
        result = result * 59 + ($entityUrl == null ? 43 : $entityUrl.hashCode());
        UUID $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : ((Object)$entityId).hashCode());
        return result;
    }

    public String toString() {
        return "ExecutionResponse(sseId=" + this.getSseId() + ", order=" + this.getOrder() + ", finalMessage=" + this.isFinalMessage() + ", processName=" + this.getProcessName() + ", executedCommand=" + this.getExecutedCommand() + ", commandResponse=" + this.getCommandResponse() + ", validations=" + this.getValidations() + ", prerequisites=" + this.getPrerequisites() + ", processStatus=" + this.getProcessStatus() + ", error=" + (Object)((Object)this.getError()) + ", globalVariables=" + this.getGlobalVariables() + ", entityUrl=" + this.getEntityUrl() + ", entityId=" + this.getEntityId() + ", duration=" + this.getDuration() + ")";
    }
}

