/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl.event;

import clover.com.google.common.base.Strings;
import clover.org.apache.commons.lang3.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.qubership.atp.mia.utils.ExcelParserHelper;

public abstract class EventExcelCustomer {
    protected static final String EVENT_INFO = "Event Info";
    protected static final String TC_ID = "TC ID";
    protected static final String SCENARIO = "Scenario";
    @Nonnull
    final XSSFSheet sheet;
    @Nullable
    final String scenario;
    @Nullable
    final String testCase;
    @Nonnull
    final List<XSSFCell> cellsWithData = new ArrayList<XSSFCell>();
    @Nonnull
    Map<String, List<String>> attrNameAndValue = new HashMap<String, List<String>>();
    @Nonnull
    HashMap<String, Boolean> identifications = new HashMap();
    @Nonnull
    Range<Integer> headerRowRange = Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0));
    @Nonnull
    Range<Integer> eventInfoRange = Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0));
    int attrNameRowNumber = 0;

    EventExcelCustomer(@Nonnull XSSFSheet sheet, @Nullable String scenario, @Nullable String testCase) {
        this.sheet = sheet;
        this.scenario = scenario;
        this.testCase = testCase;
    }

    Map<String, List<String>> getAttrNameAndValue() {
        return this.attrNameAndValue;
    }

    public boolean isCurrentFormat() {
        for (int rowId = ((Integer)this.headerRowRange.getMinimum()).intValue(); rowId <= (Integer)this.headerRowRange.getMaximum(); ++rowId) {
            XSSFRow row = this.sheet.getRow(rowId);
            if (row == null) continue;
            row.forEach(cell -> {
                String cellValue = ExcelParserHelper.getCellValue(cell);
                if (cell != null && this.identifications.containsKey(cellValue)) {
                    this.identifications.put(cellValue, true);
                }
            });
        }
        return this.identifications.values().stream().allMatch(Boolean::booleanValue);
    }

    public void parse() throws IllegalArgumentException {
        XSSFCell eventInfoCell = ExcelParserHelper.getHeaderByPattern(EVENT_INFO, this.headerRowRange, this.sheet);
        if (eventInfoCell != null) {
            this.eventInfoRange = ExcelParserHelper.getCellRowRange(eventInfoCell);
        }
        for (int columnId = ((Integer)this.eventInfoRange.getMinimum()).intValue(); columnId <= (Integer)this.eventInfoRange.getMaximum(); ++columnId) {
            String attrName = ExcelParserHelper.getCellValue(ExcelParserHelper.getCell(this.attrNameRowNumber, columnId, this.sheet)).replaceAll("\\W", "");
            if (Strings.isNullOrEmpty((String)attrName)) continue;
            this.attrNameAndValue.put(attrName, new ArrayList());
            List<String> attValues = this.attrNameAndValue.get(attrName);
            for (XSSFCell cell : this.cellsWithData) {
                Range<Integer> rowRange = ExcelParserHelper.getCellColumnRange(cell);
                for (int rowId = ((Integer)rowRange.getMinimum()).intValue(); rowId <= (Integer)rowRange.getMaximum(); ++rowId) {
                    attValues.add(ExcelParserHelper.getCellValue(ExcelParserHelper.getCell(rowId, columnId, this.sheet)));
                }
            }
        }
    }

    protected abstract void defineCellsWithData(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3, @Nullable String var4);
}

