/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl.executable;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class GeneralModel
implements Serializable {
    private static final long serialVersionUID = -3562160622292686270L;
    private String name;
    private String type;
    private String system;
    private LinkedHashSet<String> values;
    protected String value;

    public GeneralModel(String name, String type, String system, LinkedHashSet<String> values) {
        this.name = name;
        this.type = type;
        this.system = system;
        this.values = values;
    }

    public GeneralModel(String name, String type, String system, String value) {
        this.name = name;
        this.type = type;
        this.system = system;
        this.addValue(value);
    }

    @Nullable
    public LinkedHashSet<String> cloneValues() {
        if (this.values != null) {
            return new LinkedHashSet<String>(this.values);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSystem() {
        return this.system;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public void setSystemIfNull(@Nonnull String system) {
        if (this.system == null) {
            this.system = system;
        }
    }

    public LinkedHashSet<String> getValues() {
        return this.values;
    }

    public void setValues(LinkedHashSet<String> values) {
        this.values = values;
    }

    public String getValue() {
        if (this.values == null || this.values.isEmpty() || this.values.contains(null)) {
            return null;
        }
        return (String)this.values.stream().findFirst().get();
    }

    public void setValue(String value) {
        if (value != null) {
            this.values = new LinkedHashSet();
            this.values.add(value);
        }
    }

    public void addValue(String value) {
        if (value != null) {
            if (this.values == null) {
                this.values = new LinkedHashSet();
            }
            this.values.add(value);
        }
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]").add("name='" + this.name + "'").add("type='" + this.type + "'").add("system='" + this.system + "'").add("value='" + this.value + "'").add("values='" + this.values + "'").toString();
    }

    protected GeneralModel(GeneralModelBuilder<?, ?> b) {
        this.name = ((GeneralModelBuilder)b).name;
        this.type = ((GeneralModelBuilder)b).type;
        this.system = ((GeneralModelBuilder)b).system;
        this.values = ((GeneralModelBuilder)b).values;
        this.value = ((GeneralModelBuilder)b).value;
    }

    public GeneralModel() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeneralModel)) {
            return false;
        }
        GeneralModel other = (GeneralModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$system = this.getSystem();
        String other$system = other.getSystem();
        if (this$system == null ? other$system != null : !this$system.equals(other$system)) {
            return false;
        }
        LinkedHashSet<String> this$values = this.getValues();
        LinkedHashSet<String> other$values = other.getValues();
        if (this$values == null ? other$values != null : !((Object)this$values).equals(other$values)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeneralModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $system = this.getSystem();
        result = result * 59 + ($system == null ? 43 : $system.hashCode());
        LinkedHashSet<String> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public static abstract class GeneralModelBuilder<C extends GeneralModel, B extends GeneralModelBuilder<C, B>> {
        private String name;
        private String type;
        private String system;
        private LinkedHashSet<String> values;
        private String value;

        protected B $fillValuesFrom(C instance) {
            GeneralModelBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(GeneralModel instance, GeneralModelBuilder<?, ?> b) {
            b.name(instance.name);
            b.type(instance.type);
            b.system(instance.system);
            b.values(instance.values);
            b.value(instance.value);
        }

        public B name(String name) {
            this.name = name;
            return this.self();
        }

        public B type(String type) {
            this.type = type;
            return this.self();
        }

        public B system(String system) {
            this.system = system;
            return this.self();
        }

        public B values(LinkedHashSet<String> values) {
            this.values = values;
            return this.self();
        }

        public B value(String value) {
            this.value = value;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "GeneralModel.GeneralModelBuilder(name=" + this.name + ", type=" + this.type + ", system=" + this.system + ", values=" + this.values + ", value=" + this.value + ")";
        }
    }
}

