/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl.executable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.mia.model.impl.executable.GeneralModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Input
extends GeneralModel {
    private static final Logger log = LoggerFactory.getLogger(Input.class);
    private static final long serialVersionUID = -1703685321343901847L;
    @Nonnull
    private String label;
    private int maxLength;
    private String mask;
    private String maskPattern;
    private boolean required;
    @Nullable
    private List<HashMap<String, String>> referToInput;

    public Input clone() {
        if (this.label == null) {
            this.label = "Label should be defined!";
            log.error("Label is not defined! {}", (Object)this);
        }
        InputBuilder<?, ?> builder = this.toBuilder();
        if (this.referToInput != null) {
            builder.referToInput(new ArrayList<HashMap<String, String>>(this.referToInput));
        }
        builder.values(this.cloneValues());
        return builder.build();
    }

    public Input() {
    }

    public Input(@Nonnull String name, @Nonnull String type, @Nullable LinkedHashSet<String> values) {
        super(name, type, null, values);
    }

    public Input(@Nonnull String name, @Nonnull String type, @Nullable String value) {
        super(name, type, null, value);
    }

    @Nonnull
    public String getLabel() {
        return this.label;
    }

    public Input setLabel(@Nonnull String label) {
        this.label = label;
        return this;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public Input setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public String getMask() {
        return this.mask;
    }

    public Input setMask(String mask) {
        this.mask = mask;
        return this;
    }

    public String getMaskPattern() {
        return this.maskPattern;
    }

    public void setMaskPattern(String maskPattern) {
        this.maskPattern = maskPattern;
    }

    public boolean getRequired() {
        return this.required;
    }

    public Input setRequired(boolean required) {
        this.required = required;
        return this;
    }

    @Nullable
    public List<HashMap<String, String>> getReferToInput() {
        return this.referToInput;
    }

    public Input setReferToInput(@Nullable List<HashMap<String, String>> referToInput) {
        this.referToInput = referToInput;
        return this;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", Input.class.getSimpleName() + "[", "]").add("label='" + this.label + "'").add("maxLength=" + this.maxLength).add("mask='" + this.mask + "'").add("maskPattern='" + this.maskPattern + "'").add("required=" + this.required).add("referToInput=" + this.referToInput).add("name='" + this.getName() + "'").add("type='" + this.getType() + "'").add("system='" + this.getSystem() + "'").add("value='" + this.getValue() + "'").add("values='" + this.getValues() + "'").toString();
    }

    protected Input(InputBuilder<?, ?> b) {
        super(b);
        this.label = ((InputBuilder)b).label;
        if (this.label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        this.maxLength = ((InputBuilder)b).maxLength;
        this.mask = ((InputBuilder)b).mask;
        this.maskPattern = ((InputBuilder)b).maskPattern;
        this.required = ((InputBuilder)b).required;
        this.referToInput = ((InputBuilder)b).referToInput;
    }

    public static InputBuilder<?, ?> builder() {
        return new InputBuilderImpl();
    }

    public InputBuilder<?, ?> toBuilder() {
        return new InputBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Input)) {
            return false;
        }
        Input other = (Input)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxLength() != other.getMaxLength()) {
            return false;
        }
        if (this.getRequired() != other.getRequired()) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$mask = this.getMask();
        String other$mask = other.getMask();
        if (this$mask == null ? other$mask != null : !this$mask.equals(other$mask)) {
            return false;
        }
        String this$maskPattern = this.getMaskPattern();
        String other$maskPattern = other.getMaskPattern();
        if (this$maskPattern == null ? other$maskPattern != null : !this$maskPattern.equals(other$maskPattern)) {
            return false;
        }
        List<HashMap<String, String>> this$referToInput = this.getReferToInput();
        List<HashMap<String, String>> other$referToInput = other.getReferToInput();
        return !(this$referToInput == null ? other$referToInput != null : !((Object)this$referToInput).equals(other$referToInput));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Input;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxLength();
        result = result * 59 + (this.getRequired() ? 79 : 97);
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $mask = this.getMask();
        result = result * 59 + ($mask == null ? 43 : $mask.hashCode());
        String $maskPattern = this.getMaskPattern();
        result = result * 59 + ($maskPattern == null ? 43 : $maskPattern.hashCode());
        List<HashMap<String, String>> $referToInput = this.getReferToInput();
        result = result * 59 + ($referToInput == null ? 43 : ((Object)$referToInput).hashCode());
        return result;
    }

    public static abstract class InputBuilder<C extends Input, B extends InputBuilder<C, B>>
    extends GeneralModel.GeneralModelBuilder<C, B> {
        private String label;
        private int maxLength;
        private String mask;
        private String maskPattern;
        private boolean required;
        private List<HashMap<String, String>> referToInput;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            InputBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(Input instance, InputBuilder<?, ?> b) {
            b.label(instance.label);
            b.maxLength(instance.maxLength);
            b.mask(instance.mask);
            b.maskPattern(instance.maskPattern);
            b.required(instance.required);
            b.referToInput(instance.referToInput);
        }

        public B label(@Nonnull String label) {
            if (label == null) {
                throw new NullPointerException("label is marked non-null but is null");
            }
            this.label = label;
            return (B)this.self();
        }

        public B maxLength(int maxLength) {
            this.maxLength = maxLength;
            return (B)this.self();
        }

        public B mask(String mask) {
            this.mask = mask;
            return (B)this.self();
        }

        public B maskPattern(String maskPattern) {
            this.maskPattern = maskPattern;
            return (B)this.self();
        }

        public B required(boolean required) {
            this.required = required;
            return (B)this.self();
        }

        public B referToInput(@Nullable List<HashMap<String, String>> referToInput) {
            this.referToInput = referToInput;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "Input.InputBuilder(super=" + super.toString() + ", label=" + this.label + ", maxLength=" + this.maxLength + ", mask=" + this.mask + ", maskPattern=" + this.maskPattern + ", required=" + this.required + ", referToInput=" + this.referToInput + ")";
        }
    }

    private static final class InputBuilderImpl
    extends InputBuilder<Input, InputBuilderImpl> {
        private InputBuilderImpl() {
        }

        @Override
        protected InputBuilderImpl self() {
            return this;
        }

        @Override
        public Input build() {
            return new Input(this);
        }
    }
}

