/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl.executable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.mia.model.impl.executable.GeneralModel;
import org.qubership.atp.mia.model.impl.executable.TableMarker;

public class Validation
extends GeneralModel {
    private static final long serialVersionUID = -9044822576162327101L;
    private String tableName;
    @Nullable
    private List<String> referToCommandExecution;
    @Nullable
    private TableMarker tableMarker;
    @Nullable
    private HashMap<String, String> exportVariables;
    private boolean saveToWordFile = true;
    private boolean saveToZipFile = false;

    public Validation clone() {
        ValidationBuilder<?, ?> builder = this.toBuilder();
        builder.values(this.cloneValues());
        if (this.referToCommandExecution != null) {
            builder.referToCommandExecution(new ArrayList<String>(this.referToCommandExecution));
        }
        if (this.tableMarker != null) {
            builder.tableMarker(this.tableMarker.clone());
        }
        if (this.exportVariables != null) {
            builder.exportVariables(new HashMap<String, String>(this.exportVariables));
        }
        return builder.build();
    }

    public Validation() {
    }

    public Validation(@Nonnull String type, @Nonnull String system, @Nonnull String value) {
        super(null, type, system, value);
    }

    @Nonnull
    public String getTableName() {
        return this.tableName;
    }

    public Validation setTableName(@Nonnull String tableName) {
        this.tableName = tableName;
        return this;
    }

    @Nullable
    public List<String> getReferToCommandExecution() {
        return this.referToCommandExecution;
    }

    public Validation setReferToCommandExecution(@Nullable List<String> referToCommandExecution) {
        this.referToCommandExecution = referToCommandExecution;
        return this;
    }

    @Nullable
    public TableMarker getTableMarker() {
        return this.tableMarker;
    }

    public Validation setTableMarker(@Nullable TableMarker tableMarker) {
        this.tableMarker = tableMarker;
        return this;
    }

    @Nullable
    public HashMap<String, String> getExportVariables() {
        return this.exportVariables;
    }

    public Validation setExportVariables(@Nullable HashMap<String, String> exportVariables) {
        this.exportVariables = exportVariables;
        return this;
    }

    public boolean isSaveToWordFile() {
        return this.saveToWordFile;
    }

    public void setSaveToWordFile(@Nullable boolean saveToWordFile) {
        this.saveToWordFile = Boolean.parseBoolean(String.valueOf(saveToWordFile));
    }

    public boolean isSaveToZipFile() {
        return this.saveToZipFile;
    }

    public void setSaveToZipFile(@Nullable boolean saveToZipFile) {
        this.saveToZipFile = Boolean.parseBoolean(String.valueOf(saveToZipFile));
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", Validation.class.getSimpleName() + "[", "]").add("name='" + this.getName() + "'").add("type='" + this.getType() + "'").add("system='" + this.getSystem() + "'").add("value='" + this.getValue() + "'").add("values='" + this.getValues() + "'").add("tableName='" + this.tableName + "'").add("referToCommandExecution=" + this.referToCommandExecution + "'").add("tableMarker=" + this.tableMarker + "'").add("exportVariables=" + this.exportVariables + "'").add("saveToWordFile=" + this.saveToWordFile + "'").add("saveToZipFile=" + this.saveToZipFile + "'").toString();
    }

    protected Validation(ValidationBuilder<?, ?> b) {
        super(b);
        this.tableName = ((ValidationBuilder)b).tableName;
        this.referToCommandExecution = ((ValidationBuilder)b).referToCommandExecution;
        this.tableMarker = ((ValidationBuilder)b).tableMarker;
        this.exportVariables = ((ValidationBuilder)b).exportVariables;
        this.saveToWordFile = ((ValidationBuilder)b).saveToWordFile;
        this.saveToZipFile = ((ValidationBuilder)b).saveToZipFile;
    }

    public static ValidationBuilder<?, ?> builder() {
        return new ValidationBuilderImpl();
    }

    public ValidationBuilder<?, ?> toBuilder() {
        return new ValidationBuilderImpl().$fillValuesFrom(this);
    }

    public Validation(String tableName, @Nullable List<String> referToCommandExecution, @Nullable TableMarker tableMarker, @Nullable HashMap<String, String> exportVariables, boolean saveToWordFile, boolean saveToZipFile) {
        this.tableName = tableName;
        this.referToCommandExecution = referToCommandExecution;
        this.tableMarker = tableMarker;
        this.exportVariables = exportVariables;
        this.saveToWordFile = saveToWordFile;
        this.saveToZipFile = saveToZipFile;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Validation)) {
            return false;
        }
        Validation other = (Validation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isSaveToWordFile() != other.isSaveToWordFile()) {
            return false;
        }
        if (this.isSaveToZipFile() != other.isSaveToZipFile()) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        List<String> this$referToCommandExecution = this.getReferToCommandExecution();
        List<String> other$referToCommandExecution = other.getReferToCommandExecution();
        if (this$referToCommandExecution == null ? other$referToCommandExecution != null : !((Object)this$referToCommandExecution).equals(other$referToCommandExecution)) {
            return false;
        }
        TableMarker this$tableMarker = this.getTableMarker();
        TableMarker other$tableMarker = other.getTableMarker();
        if (this$tableMarker == null ? other$tableMarker != null : !((Object)this$tableMarker).equals(other$tableMarker)) {
            return false;
        }
        HashMap<String, String> this$exportVariables = this.getExportVariables();
        HashMap<String, String> other$exportVariables = other.getExportVariables();
        return !(this$exportVariables == null ? other$exportVariables != null : !((Object)this$exportVariables).equals(other$exportVariables));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Validation;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isSaveToWordFile() ? 79 : 97);
        result = result * 59 + (this.isSaveToZipFile() ? 79 : 97);
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        List<String> $referToCommandExecution = this.getReferToCommandExecution();
        result = result * 59 + ($referToCommandExecution == null ? 43 : ((Object)$referToCommandExecution).hashCode());
        TableMarker $tableMarker = this.getTableMarker();
        result = result * 59 + ($tableMarker == null ? 43 : ((Object)$tableMarker).hashCode());
        HashMap<String, String> $exportVariables = this.getExportVariables();
        result = result * 59 + ($exportVariables == null ? 43 : ((Object)$exportVariables).hashCode());
        return result;
    }

    public static abstract class ValidationBuilder<C extends Validation, B extends ValidationBuilder<C, B>>
    extends GeneralModel.GeneralModelBuilder<C, B> {
        private String tableName;
        private List<String> referToCommandExecution;
        private TableMarker tableMarker;
        private HashMap<String, String> exportVariables;
        private boolean saveToWordFile;
        private boolean saveToZipFile;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ValidationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(Validation instance, ValidationBuilder<?, ?> b) {
            b.tableName(instance.tableName);
            b.referToCommandExecution(instance.referToCommandExecution);
            b.tableMarker(instance.tableMarker);
            b.exportVariables(instance.exportVariables);
            b.saveToWordFile(instance.saveToWordFile);
            b.saveToZipFile(instance.saveToZipFile);
        }

        public B tableName(String tableName) {
            this.tableName = tableName;
            return (B)this.self();
        }

        public B referToCommandExecution(@Nullable List<String> referToCommandExecution) {
            this.referToCommandExecution = referToCommandExecution;
            return (B)this.self();
        }

        public B tableMarker(@Nullable TableMarker tableMarker) {
            this.tableMarker = tableMarker;
            return (B)this.self();
        }

        public B exportVariables(@Nullable HashMap<String, String> exportVariables) {
            this.exportVariables = exportVariables;
            return (B)this.self();
        }

        public B saveToWordFile(boolean saveToWordFile) {
            this.saveToWordFile = saveToWordFile;
            return (B)this.self();
        }

        public B saveToZipFile(boolean saveToZipFile) {
            this.saveToZipFile = saveToZipFile;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "Validation.ValidationBuilder(super=" + super.toString() + ", tableName=" + this.tableName + ", referToCommandExecution=" + this.referToCommandExecution + ", tableMarker=" + this.tableMarker + ", exportVariables=" + this.exportVariables + ", saveToWordFile=" + this.saveToWordFile + ", saveToZipFile=" + this.saveToZipFile + ")";
        }
    }

    private static final class ValidationBuilderImpl
    extends ValidationBuilder<Validation, ValidationBuilderImpl> {
        private ValidationBuilderImpl() {
        }

        @Override
        protected ValidationBuilderImpl self() {
            return this;
        }

        @Override
        public Validation build() {
            return new Validation(this);
        }
    }
}

