/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl.macros.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;
import javax.xml.ws.Holder;
import org.qubership.atp.mia.model.impl.macros.Macros;
import org.qubership.atp.mia.model.impl.macros.MacrosType;

public class CycleTextGenerationMacros
extends Macros<String> {
    private StringJoiner finalText;
    private String textFormat;
    private String argumentNameCreatesCycle;
    private LinkedHashMap<String, LinkedHashMap<Integer, String>> argNameValues;

    public CycleTextGenerationMacros() {
        super(MacrosType.CycleTextGeneration.name());
    }

    @Override
    public String evaluate(String[] inputs) {
        this.finalText = new StringJoiner("\n");
        this.argNameValues = new LinkedHashMap();
        if (inputs.length < 4) {
            this.finalText.add("ERROR IN GENERATION TEXT: NUMBER OF PARAMETERS MACROS SHOULD BE MORE THEN 3");
            this.addFormatMacros();
        } else {
            this.textFormat = inputs[0];
            this.finalText = new StringJoiner(inputs[1].equals("\\n") ? "\n" : inputs[1]);
            this.argumentNameCreatesCycle = inputs[2].trim();
            if (this.parseAttributes(inputs) && this.checkAttributesLength()) {
                for (int argIdx = 0; argIdx < this.argNameValues.get(this.argumentNameCreatesCycle).size(); ++argIdx) {
                    LinkedList<String> toAdd = new LinkedList<String>();
                    toAdd.add(this.textFormat);
                    for (Map.Entry<String, LinkedHashMap<Integer, String>> entry : this.argNameValues.entrySet()) {
                        String argumentN = entry.getKey();
                        String valueToChange = entry.getValue().get(argIdx);
                        if (valueToChange == null) {
                            valueToChange = entry.getValue().get(0);
                        }
                        toAdd.add(((String)toAdd.get(toAdd.size() - 1)).replace("[" + argumentN + "]", valueToChange.trim()));
                    }
                    toAdd.add(((String)toAdd.get(toAdd.size() - 1)).replaceAll("\\[\\w+\\]", ""));
                    this.finalText.add((CharSequence)toAdd.get(toAdd.size() - 1));
                }
            }
        }
        return this.finalText.toString();
    }

    private boolean parseAttributes(String[] inputs) {
        for (int inputIdx = 3; inputIdx < inputs.length; ++inputIdx) {
            if (inputs[inputIdx].split("->").length < 2) {
                this.finalText.add(String.format("Attribute (%d) of the macros has incorrect format!", String.valueOf(inputIdx + 1)));
                this.addFormatMacros();
                return false;
            }
            String argumentN = inputs[inputIdx].split("->")[0].trim();
            String argumentV = inputs[inputIdx].split("->")[1].trim();
            Holder needToString = new Holder((Object)false);
            Holder needToAddSingleQuotationMarks = new Holder((Object)false);
            try {
                String toType = inputs[inputIdx].split("->")[2].trim();
                needToString.value = toType.equalsIgnoreCase("string");
                needToAddSingleQuotationMarks.value = toType.equalsIgnoreCase("singleQuotationMarks");
            }
            catch (Exception toType) {
                // empty catch block
            }
            Function<String, String> toStringType = valueToString -> {
                if (((Boolean)needToString.value).booleanValue() && !valueToString.isEmpty()) {
                    return "\"" + valueToString.trim() + "\"";
                }
                if (((Boolean)needToAddSingleQuotationMarks.value).booleanValue() && !valueToString.isEmpty()) {
                    return "'" + valueToString.trim() + "'";
                }
                return valueToString;
            };
            LinkedHashMap<Integer, String> argumentValues = new LinkedHashMap<Integer, String>();
            if (argumentV.startsWith("[")) {
                for (String value : this.parseArgumentValue(argumentV, -1)) {
                    argumentValues.put(argumentValues.size(), toStringType.apply(value));
                }
            } else {
                argumentValues.put(argumentValues.size(), toStringType.apply(argumentV));
            }
            this.argNameValues.put(argumentN, argumentValues);
        }
        return true;
    }

    private boolean checkAttributesLength() {
        if (this.argNameValues.get(this.argumentNameCreatesCycle) == null) {
            this.finalText.add(String.format("No attribute values found (%s)!", this.argumentNameCreatesCycle));
            this.addFormatMacros();
            return false;
        }
        int argumentLengthCreatesCycle = this.argNameValues.get(this.argumentNameCreatesCycle).size();
        for (Map.Entry<String, LinkedHashMap<Integer, String>> entry : this.argNameValues.entrySet()) {
            int valueSize = entry.getValue().size();
            if (valueSize == argumentLengthCreatesCycle || valueSize == 1) continue;
            this.finalText.add(String.format("Values size (%d) of attribute (%s) is incorrect! Should be %d or 1", valueSize, entry.getKey(), argumentLengthCreatesCycle));
            this.addFormatMacros();
            return false;
        }
        return true;
    }

    private void addFormatMacros() {
        this.finalText.add("MACROS format: $ { CycleTextGeneration('Text for generation in cycle [OtherArgumentName1], [ArgumentNameCreatesCycle] [OtherArgumentNameN]', 'ArgumentNameCreatesCycle', 'OtherArgumentName1-> [1, 2, 3] -> string', 'ArgumentNameCreatesCycle -> [A,B,C] -> string', 'OtherArgumentNameN -> 0' ) }");
        this.finalText.add("As result will be generated following:");
        this.finalText.add("Text for generation in cycle 1 A 0");
        this.finalText.add("Text for generation in cycle 2 B 0");
        this.finalText.add("Text for generation in cycle 3 B 0");
    }

    private List<String> parseArgumentValue(String argumentV, int replaceIndex) {
        ArrayList<String> returnValue = new ArrayList<String>();
        int elementIndex = -1;
        int bracketNum = 0;
        int startElementId = -1;
        int endElementId = -1;
        int startBlockId = -1;
        int endBlockId = -1;
        argumentV = argumentV.replaceAll("\\[\\]", "");
        for (int symbolId = 0; symbolId < argumentV.length(); ++symbolId) {
            if (argumentV.charAt(symbolId) == '[') {
                if (bracketNum == 0) {
                    startElementId = symbolId;
                    startBlockId = symbolId;
                }
                ++bracketNum;
            }
            if (argumentV.charAt(symbolId) == ']' && bracketNum > 0) {
                --bracketNum;
            }
            if (argumentV.charAt(symbolId) == ']' && bracketNum == 0 || symbolId == argumentV.length() - 1) {
                endElementId = symbolId;
                endBlockId = symbolId;
            }
            if (argumentV.charAt(symbolId) == ',' && argumentV.charAt(symbolId + 1) == ' ' && bracketNum == 1) {
                endElementId = symbolId;
            }
            if (endElementId > 0) {
                ++elementIndex;
                String block = argumentV.substring(startElementId + 1, endElementId);
                while (block.contains("[") && block.contains("]")) {
                    block = this.parseArgumentValue(block, elementIndex).get(0);
                }
                startElementId = symbolId + 1;
                endElementId = -1;
                returnValue.add(block);
            }
            if (endBlockId <= 0 || replaceIndex < 0) continue;
            String replaceValue = returnValue.size() > replaceIndex ? returnValue.get(replaceIndex) : "";
            return Arrays.asList(new StringBuffer(argumentV).replace(startBlockId, endBlockId + 1, replaceValue).toString());
        }
        if (returnValue.isEmpty()) {
            returnValue.add(argumentV);
        }
        return returnValue;
    }
}

