/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl.macros.impl;

import java.util.concurrent.ThreadLocalRandom;
import org.qubership.atp.mia.exceptions.macrosandevaluations.MacrosRandomIncorrectFormatException;
import org.qubership.atp.mia.exceptions.macrosandevaluations.MacrosRandomIncorrectLengthException;
import org.qubership.atp.mia.model.impl.macros.Macros;
import org.qubership.atp.mia.model.impl.macros.MacrosType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomMacros
extends Macros<String> {
    private static final Logger log = LoggerFactory.getLogger(RandomMacros.class);

    public RandomMacros() {
        super(MacrosType.Random.name());
    }

    @Override
    public String evaluate(String[] inputs) {
        if (inputs.length != 1) {
            throw new MacrosRandomIncorrectLengthException();
        }
        String valueForRandom = inputs[0].trim();
        try {
            long numberForRandom = Long.parseLong(valueForRandom);
            return String.valueOf(ThreadLocalRandom.current().nextLong(numberForRandom));
        }
        catch (NumberFormatException e) {
            throw new MacrosRandomIncorrectFormatException(valueForRandom);
        }
    }
}

