/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.sse;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.qubership.atp.mia.model.sse.SseEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public class SsePingRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SsePingRunnable.class);
    private final SseEmitter emitter;
    private final UUID sseId;
    private final long timeout;
    private volatile boolean shutdown = false;
    private final AtomicLong timeoutSpend = new AtomicLong(0L);

    @Override
    public void run() {
        Thread.currentThread().setName("PING_FOR_SSE_" + this.sseId);
        this.sleep();
        while (!this.shutdown) {
            try {
                this.emitter.send(SseEmitter.event().name(SseEventType.PING.name()).data((Object)("Spend " + this.timeoutSpend.get() + " seconds"), MediaType.APPLICATION_JSON));
                this.sleep();
            }
            catch (Exception e) {
                log.error("Exception during send ping into emitter with ID [{}]: {}", (Object)this.sseId, (Object)e.getMessage());
                this.shutdown = true;
            }
        }
        log.debug("Thread '{}' is completed", (Object)Thread.currentThread().getName());
    }

    public void shutdown() {
        this.shutdown = true;
    }

    private void sleep() {
        try {
            TimeUnit.MILLISECONDS.sleep(this.timeout);
            this.timeoutSpend.getAndAdd(this.timeout / 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public SsePingRunnable(SseEmitter emitter, UUID sseId, long timeout) {
        this.emitter = emitter;
        this.sseId = sseId;
        this.timeout = timeout;
    }
}

