/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.repo.driver;

import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.mia.exceptions.MiaException;
import org.qubership.atp.mia.exceptions.businesslogic.sql.SqlConnectionFailException;
import org.qubership.atp.mia.exceptions.businesslogic.sql.SqlExecuteFailException;
import org.qubership.atp.mia.exceptions.businesslogic.sql.SqlTimeoutException;
import org.qubership.atp.mia.model.environment.Server;
import org.qubership.atp.mia.model.pot.db.DbAnswer;
import org.qubership.atp.mia.model.pot.db.SqlUtils;
import org.qubership.atp.mia.model.pot.db.table.DbTable;
import org.qubership.atp.mia.repo.driver.QueryDriver;
import org.qubership.atp.mia.service.monitoring.MetricsAggregateService;
import org.qubership.atp.mia.utils.CryptoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository
public abstract class SqlDriver
implements QueryDriver<Connection> {
    private static final Logger log = LoggerFactory.getLogger(SqlDriver.class);
    protected final LoadingCache<Server, Connection> pool;
    protected final ExecutorService executorService;
    @Autowired
    protected MetricsAggregateService metricsService;
    @Value(value="${db.close.delay:300}")
    protected int cleanUpTimeout;
    @Value(value="${db.alive.length:300}")
    protected int expiredAfter;
    @Value(value="${db.execution.timeout:30}")
    protected int executionTimeout;

    protected SqlDriver(ExecutorService executorService) {
        this.executorService = executorService;
        this.pool = this.initPool(log, this.expiredAfter * 1000);
        this.initPoolCleanUp(log, this.pool, (long)this.cleanUpTimeout * 1000L);
    }

    protected SqlDriver(ExecutorService executorService, int expireAfter, int cleanUpTimeout) {
        this.executorService = executorService;
        this.pool = this.initPool(log, expireAfter);
        this.initPoolCleanUp(log, this.pool, cleanUpTimeout);
    }

    @Override
    public Connection create(Server server) {
        try {
            return DriverManager.getConnection(server.getProperty("jdbc_url"), server.getUser(), CryptoUtils.decryptValue(server.getPass()));
        }
        catch (SQLException e) {
            throw new SqlConnectionFailException(server.getProperty("jdbc_url"), e);
        }
    }

    @Override
    public DbTable executeQuery(Server server, String query) {
        return this.executeQuery(server, query, 0);
    }

    @Override
    public DbTable executeQuery(Server server, String query, int limitRecords) {
        DbTable dbTable;
        block13: {
            int timeout = this.getExecutionTimeout(this.executionTimeout, server);
            Connection connection = (Connection)this.pool.get((Object)server);
            PreparedStatement statement = connection.prepareStatement(query, 1004, 1007);
            try {
                Map mdcMap = MDC.getCopyOfContextMap();
                ResultSet rs = this.executorService.submit(() -> {
                    this.setThreadName(server, "Query");
                    MdcUtils.setContextMap((Map)mdcMap);
                    return statement.executeQuery();
                }).get(timeout, TimeUnit.MILLISECONDS);
                int actualRecordsSize = 0;
                if (this.metricsService != null && rs != null && rs.last()) {
                    actualRecordsSize = rs.getRow();
                    log.info("[SIZE] SQL query retrieved {} records", (Object)actualRecordsSize);
                    this.metricsService.sqlQueryRecordsSize(actualRecordsSize);
                    rs.beforeFirst();
                }
                DbTable dbTable2 = SqlUtils.resultSetToDbTable(rs, limitRecords);
                dbTable2.setActualDataSizeBeforeLimit(actualRecordsSize);
                dbTable = dbTable2;
                if (statement == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (TimeoutException e) {
                        throw new SqlTimeoutException(timeout, "milliseconds", query);
                    }
                    catch (Exception e) {
                        throw new SqlExecuteFailException(query, e);
                    }
                }
                catch (UncheckedExecutionException | ExecutionException e) {
                    throw this.handleConnectionException(query, (Exception)e);
                }
            }
            statement.close();
        }
        return dbTable;
    }

    @Override
    public int executeUpdate(Server server, String query) {
        int n;
        block12: {
            int timeout = this.getExecutionTimeout(this.executionTimeout, server);
            Connection connection = (Connection)this.pool.get((Object)server);
            PreparedStatement statement = connection.prepareStatement(query);
            try {
                Map mdcMap = MDC.getCopyOfContextMap();
                n = this.executorService.submit(() -> {
                    this.setThreadName(server, "Update");
                    MdcUtils.setContextMap((Map)mdcMap);
                    return statement.executeUpdate();
                }).get(timeout, TimeUnit.MILLISECONDS);
                if (statement == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (TimeoutException e) {
                        throw new SqlTimeoutException(timeout, "milliseconds", query);
                    }
                    catch (Exception e) {
                        throw new SqlExecuteFailException(query, e);
                    }
                }
                catch (UncheckedExecutionException | ExecutionException e) {
                    throw this.handleConnectionException(query, (Exception)e);
                }
            }
            statement.close();
        }
        return n;
    }

    @Override
    public DbAnswer executeStoredProcedure(Server server, String query) {
        DbAnswer dbAnswer;
        block20: {
            int timeout = this.getExecutionTimeout(this.executionTimeout, server);
            Connection connection = (Connection)this.pool.get((Object)server);
            CallableStatement statement = connection.prepareCall(query);
            try {
                Map mdcMap = MDC.getCopyOfContextMap();
                boolean status = this.executorService.submit(() -> {
                    this.setThreadName(server, "StoredProcedure");
                    MdcUtils.setContextMap((Map)mdcMap);
                    return statement.execute();
                }).get(timeout, TimeUnit.MILLISECONDS);
                DbTable dbTable = null;
                int updateCount = -1;
                if (status) {
                    try (ResultSet rs = statement.getResultSet();){
                        dbTable = SqlUtils.resultSetToDbTable(rs);
                    }
                } else {
                    updateCount = statement.getUpdateCount();
                }
                dbAnswer = new DbAnswer(status, dbTable, updateCount);
                if (statement == null) break block20;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (TimeoutException e) {
                        throw new SqlTimeoutException(timeout, "milliseconds", query);
                    }
                    catch (Exception e) {
                        throw new SqlExecuteFailException(query, e);
                    }
                }
                catch (UncheckedExecutionException | ExecutionException e) {
                    throw this.handleConnectionException(query, (Exception)e);
                }
            }
            statement.close();
        }
        return dbAnswer;
    }

    @Override
    public long poolSize() {
        return this.pool.size();
    }

    private void setThreadName(Server server, String postfix) {
        Thread.currentThread().setName("mia_" + this.getDriverType() + "_execute" + postfix + "_" + server.getHostFull());
    }

    private MiaException handleConnectionException(String query, Exception e) {
        Throwable cause = e.getCause();
        if (cause instanceof SqlConnectionFailException) {
            return (SqlConnectionFailException)((Object)cause);
        }
        return new SqlExecuteFailException(query, e);
    }
}

