/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.repo.impl;

import com.poiji.bind.Poiji;
import com.poiji.option.PoijiOptions;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.xml.ws.Holder;
import org.qubership.atp.mia.exceptions.testdata.MatrixExcelParseFailException;
import org.qubership.atp.mia.exceptions.testdata.MatrixQuerySheetMissedDbTypeException;
import org.qubership.atp.mia.model.configuration.CommonConfiguration;
import org.qubership.atp.mia.model.impl.CommandResponse;
import org.qubership.atp.mia.model.impl.executable.Command;
import org.qubership.atp.mia.model.impl.executable.Rest;
import org.qubership.atp.mia.model.impl.executable.Soap;
import org.qubership.atp.mia.model.impl.generation.Template;
import org.qubership.atp.mia.model.impl.testdata.MainSheet;
import org.qubership.atp.mia.model.impl.testdata.MainSheetRecord;
import org.qubership.atp.mia.model.impl.testdata.QueriesSheet;
import org.qubership.atp.mia.model.impl.testdata.QueriesSheetRecord;
import org.qubership.atp.mia.model.impl.testdata.TestDataSheet;
import org.qubership.atp.mia.model.impl.testdata.TestDataWorkbook;
import org.qubership.atp.mia.model.impl.testdata.parsed.Description;
import org.qubership.atp.mia.model.impl.testdata.parsed.Query;
import org.qubership.atp.mia.model.impl.testdata.parsed.Scenario;
import org.qubership.atp.mia.model.impl.testdata.parsed.ValidateValue;
import org.qubership.atp.mia.model.impl.testdata.parsed.ValidatedParameters;
import org.qubership.atp.mia.repo.ContextRepository;
import org.qubership.atp.mia.repo.impl.ShellRepository;
import org.qubership.atp.mia.service.MiaContext;
import org.qubership.atp.mia.service.execution.RestExecutionHelperService;
import org.qubership.atp.mia.service.execution.SoapExecutionHelperService;
import org.qubership.atp.mia.service.execution.SqlExecutionHelperService;
import org.qubership.atp.mia.service.file.MiaFileService;
import org.qubership.atp.mia.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class TestDataRepository {
    private static final Logger log = LoggerFactory.getLogger(TestDataRepository.class);
    private final ContextRepository contextRepository;
    private final SqlExecutionHelperService sqlService;
    private final SoapExecutionHelperService soapService;
    private final RestExecutionHelperService restService;
    private final ShellRepository shellRepo;
    private final MiaContext miaContext;
    private final MiaFileService miaFileService;

    public TestDataWorkbook getTestDataWorkbook() {
        TestDataWorkbook testDataWorkbook = this.contextRepository.getContext().getTestDataWorkbook();
        if (testDataWorkbook != null && testDataWorkbook.getExcelFile() != null && !testDataWorkbook.isLoaded()) {
            this.parseWorkbook(testDataWorkbook, false);
        }
        return testDataWorkbook;
    }

    public void generateEventDescription(Command command, LinkedList<Template> templates, Scenario sceMain, Description descrM, Description descrS) {
        log.info("GENERATE EVENT: [scenario:{}],[description:{}]", (Object)sceMain.getName(), (Object)descrM.getName());
        String fileName = null;
        Map<String, String> params = this.getParametersFromDescriptions(descrM, descrS);
        params.putAll(this.contextRepository.getContext().getParameters());
        CommonConfiguration cConf = this.miaContext.getConfig().getCommonConfiguration();
        if (command.getTestDataParams().isEventFileForEachDescription() || templates.size() == 0) {
            String toGeneration;
            String ethalonFile = this.miaContext.evaluate(command.getTestDataParams().getEventFileTemplate(), params);
            fileName = toGeneration = this.miaContext.evaluate(command.getNamesOfFilesForGeneration().get(0), params);
            templates.add(new Template(this.miaContext, this.miaFileService, ethalonFile, toGeneration, command.getFileExtension(), command.definedCharsetForGeneratedFile()));
        }
        descrM.addOtherParam(command.getTestDataParams().getColumnNameForGeneratedFileName(), fileName, this.getTestDataWorkbook());
        descrM.addOtherParam(command.getTestDataParams().getColumnNameForGeneratedFileExtension(), command.getFileExtension(), this.getTestDataWorkbook());
        templates.getLast().evaluateTemplate(command, cConf, params);
    }

    public MainSheet parseMainSheet(File excelFile, boolean forValidate) {
        PoijiOptions options = PoijiOptions.PoijiOptionsBuilder.settings().sheetName("Main").preferNullOverDefault(true).headerStart(13).build();
        MainSheet mainSheet = new MainSheet();
        mainSheet.setRecords(Poiji.fromExcel((File)excelFile, MainSheetRecord.class, (PoijiOptions)options));
        Holder scenario = new Holder();
        if (mainSheet.getRecords() != null) {
            LinkedHashSet allKeysForOtherKeysMain = new LinkedHashSet();
            mainSheet.getRecords().forEach(r -> {
                if (r.getOtherCells() != null) {
                    allKeysForOtherKeysMain.addAll(r.getOtherCells().keySet());
                }
            });
            mainSheet.getRecords().forEach(r -> {
                if (r.getScenario() != null) {
                    if (scenario.value != null) {
                        if (!((Scenario)scenario.value).getName().equals(r.getScenario())) {
                            mainSheet.addScenario((Scenario)scenario.value);
                            scenario.value = new Scenario(r.getScenario());
                        }
                    } else {
                        scenario.value = new Scenario(r.getScenario());
                    }
                }
                if (scenario.value != null && !forValidate && r.getDescription() != null) {
                    ((Scenario)scenario.value).addDescription(new Description(r.getDescription(), r.getOtherCells(allKeysForOtherKeysMain), this.miaContext));
                }
            });
            if (scenario.value != null) {
                mainSheet.addScenario((Scenario)scenario.value);
                scenario.value = null;
            }
            mainSheet.setRecords(null);
        }
        return mainSheet;
    }

    public QueriesSheet parseQueriesSheet(File excelFile) {
        PoijiOptions options = PoijiOptions.PoijiOptionsBuilder.settings().sheetName("Validation Queries").preferNullOverDefault(true).build();
        QueriesSheet queriesSheet = new QueriesSheet();
        queriesSheet.setRecords(Poiji.fromExcel((File)excelFile, QueriesSheetRecord.class, (PoijiOptions)options));
        Holder query = new Holder();
        if (queriesSheet.getRecords() != null) {
            queriesSheet.getRecords().forEach(r -> {
                if (r.getQuery() != null) {
                    String queryName = this.miaContext.evaluate(r.getQuery());
                    if (r.getType() == null) {
                        throw new MatrixQuerySheetMissedDbTypeException(r.getQuery());
                    }
                    if (query.value != null) {
                        if (!((Query)query.value).getQuery().equals(r.getQuery())) {
                            queriesSheet.addQuery((Query)query.value);
                            query.value = new Query(queryName, r.getType());
                        }
                    } else {
                        query.value = new Query(queryName, r.getType());
                    }
                }
                if (query.value != null && r.getToValidate() != null && r.getValidated() != null) {
                    ((Query)query.value).addValidateValue(this.miaContext.evaluate(r.getToValidate().trim()), this.miaContext.evaluate(r.getValidated().trim()));
                }
            });
            if (query.value != null) {
                queriesSheet.addQuery((Query)query.value);
                query.value = null;
            }
            queriesSheet.setRecords(null);
        }
        return queriesSheet;
    }

    public TestDataSheet parseTestDataSheet(File excelFile) {
        PoijiOptions options = PoijiOptions.PoijiOptionsBuilder.settings().sheetName("Test Data").preferNullOverDefault(true).trimCellValue(true).build();
        TestDataSheet testDataSheet = new TestDataSheet();
        testDataSheet.setRecords(Poiji.fromExcel((File)excelFile, MainSheetRecord.class, (PoijiOptions)options));
        Holder scenario = new Holder();
        if (testDataSheet.getRecords() != null) {
            LinkedHashSet allKeysForOtherKeysSec = new LinkedHashSet();
            testDataSheet.getRecords().forEach(r -> {
                if (r.getOtherCells() != null) {
                    allKeysForOtherKeysSec.addAll(r.getOtherCells().keySet());
                }
            });
            testDataSheet.getRecords().forEach(r -> {
                if (r.getScenario() != null) {
                    if (scenario.value != null) {
                        if (!((Scenario)scenario.value).getName().equals(r.getScenario())) {
                            testDataSheet.addScenario((Scenario)scenario.value);
                            scenario.value = new Scenario(r.getScenario());
                        }
                    } else {
                        scenario.value = new Scenario(r.getScenario());
                    }
                }
                if (scenario.value != null && r.getDescription() != null) {
                    ((Scenario)scenario.value).addDescription(new Description(r.getDescription(), false, r.getOtherCells(allKeysForOtherKeysSec), this.miaContext));
                }
            });
            if (scenario.value != null) {
                testDataSheet.addScenario((Scenario)scenario.value);
                scenario.value = null;
            }
            testDataSheet.setRecords(null);
        }
        return testDataSheet;
    }

    public void generateEventScenario(Command command, LinkedList<Template> templates, Scenario sceMain, Scenario sceSec) {
        sceMain.getDescriptions().forEach(descriptionMain -> {
            Description descriptionSecond = sceSec == null ? null : (Description)sceSec.getDescriptions().stream().filter(descr -> descr.getName().equals(descriptionMain.getName())).findFirst().orElse(null);
            this.generateEventDescription(command, templates, sceMain, (Description)descriptionMain, descriptionSecond);
        });
    }

    public void parseWorkbook(TestDataWorkbook testDataWorkbook, boolean forValidate) {
        File excelFile = this.miaFileService.getFile(testDataWorkbook.getExcelFile());
        try {
            testDataWorkbook.setMainSheet(this.parseMainSheet(excelFile, forValidate));
            if (!forValidate) {
                testDataWorkbook.setTestDataSheet(this.parseTestDataSheet(excelFile));
                testDataWorkbook.setQueriesSheet(this.parseQueriesSheet(excelFile));
            }
        }
        catch (Exception e) {
            throw new MatrixExcelParseFailException(excelFile.getName(), "Main", e);
        }
        testDataWorkbook.setExcelFile(excelFile.toString());
        testDataWorkbook.setLoaded(true);
    }

    public void validateScenario(Scenario sceMain, Scenario sceSec, String system) {
        sceMain.getDescriptions().forEach(descriptionMain -> {
            Description descriptionSecond = sceSec == null ? null : (Description)sceSec.getDescriptions().stream().filter(descr -> descr.getName().equals(descriptionMain.getName())).findFirst().orElse(null);
            this.validateDescription(sceMain, (Description)descriptionMain, descriptionSecond, system);
        });
    }

    public void validateDescription(Scenario sceMain, Description descrM, Description descrS, String system) {
        log.info("VALIDATE MATRIX: [scenario:{}],[description:{}],[columns:{}]", new Object[]{sceMain.getName(), descrM.getName(), descrM.getValidationParams().keySet()});
        Map<String, String> params = this.getParametersFromDescriptions(descrM, descrS);
        descrM.getValidationParams().forEach((validK, validV) -> {
            Optional<Query> queryOptional = this.getTestDataWorkbook().getQueriesSheet().getQueries().stream().filter(q -> q.getValidateValue().stream().anyMatch(v -> v.getValidateName().equals(validK))).findAny();
            if (!queryOptional.isPresent()) {
                descrM.addValidatedParam((String)validK, "ERROR: QUERY TO EXECUTE NOT FOUND");
                return;
            }
            Query query = queryOptional.get();
            ValidateValue validateValue = query.getValidateValue().stream().filter(v -> v.getValidateName().equals(validK)).findFirst().get();
            if (validateValue.getValue() != null) {
                log.debug("VALIDATE MATRIX: [scenario:{}],[description:{}] value for '{}' present: {}", new Object[]{sceMain.getName(), descrM.getName(), validK, validateValue.getValue()});
                this.validate(descrM, params, (String)validV, validateValue);
                return;
            }
            String queryToExecute = this.miaContext.evaluate(query.getQuery(), params);
            log.info("VALIDATE MATRIX:[scenario:{}],[description:{},[query:{}]", new Object[]{sceMain.getName(), descrM.getName(), queryToExecute});
            try {
                query.updateResultsFromListCommandResponses(this.sqlService.executeCommand(queryToExecute, system, params, false));
            }
            catch (Exception e) {
                query.updateResultsWithString(Utils.maxExcelString(e.getMessage()));
            }
            validateValue = query.getValidateValue().stream().filter(v -> v.getValidateName().equals(validK)).findFirst().get();
            this.validate(descrM, params, (String)validV, validateValue);
        });
        this.getTestDataWorkbook().getQueriesSheet().getQueries().forEach(q -> q.getValidateValue().forEach(v -> v.setValue(null)));
    }

    private void validate(Description descrM, Map<String, String> params, String validV, ValidateValue validateValue) {
        if (validV.length() > 0) {
            validV = this.miaContext.evaluate(validV, params);
            descrM.updateValidatedParam(validateValue.getValidatedName(), validateValue.getValue(), validateValue.getValue().equals(validV) ? ValidatedParameters.State.PASSED : ValidatedParameters.State.FAILED, validV);
        } else {
            if (validateValue.getValue().equals("ERROR: NO COLUMN RESULT")) {
                validateValue.setValue("SKIPPED");
            }
            descrM.updateValidatedParam(validateValue.getValidatedName(), validateValue.getValue(), validateValue.getValue().length() > 0 ? ValidatedParameters.State.SKIPPED : ValidatedParameters.State.PASSED, validV);
        }
    }

    public void sqlScenario(Scenario sceMain, Scenario sceSec, Command command) {
        sceMain.getDescriptions().forEach(descriptionMain -> {
            Description descriptionSecond = sceSec == null ? null : (Description)sceSec.getDescriptions().stream().filter(descr -> descr.getName().equals(descriptionMain.getName())).findFirst().orElse(null);
            this.sqlDescriptionToExecute(sceMain.getName(), (Description)descriptionMain, descriptionSecond, command);
        });
        if (sceSec != null) {
            sceSec.getDescriptions().forEach(descriptionMain -> {
                Description descriptionSecond = sceMain.getDescriptions().stream().filter(descr -> descr.getName().equals(descriptionMain.getName())).findFirst().orElse(null);
                this.sqlDescriptionToExecute(sceSec.getName(), (Description)descriptionMain, descriptionSecond, command);
            });
        }
    }

    private void sqlDescriptionToExecute(String scenarioName, Description descrM, Description descrS, Command command) {
        this.parseListToExecuteWithConsumer(command, columnToExecute -> {
            log.info("SQL FROM MATRIX: [scenario:{}],[description:{}],[column:{}]", new Object[]{scenarioName, descrM.getName(), command.getToExecute()});
            if (descrM.getOtherParams() != null && descrM.getOtherParams().containsKey(columnToExecute)) {
                descrM.getOtherParams().put((String)columnToExecute, this.executeSqlFromCell(descrM.getOtherParams().get(columnToExecute), command.getSystem(), descrM, descrS));
            } else if (descrM.getEventParams() != null && descrM.getEventParams().containsKey(columnToExecute)) {
                descrM.getEventParams().put((String)columnToExecute, this.executeSqlFromCell(descrM.getEventParams().get(columnToExecute), command.getSystem(), descrM, descrS));
            } else if (descrM.getValidationParams() != null && descrM.getValidationParams().containsKey(columnToExecute)) {
                descrM.getValidationParams().put((String)columnToExecute, this.executeSqlFromCell(descrM.getValidationParams().get(columnToExecute), command.getSystem(), descrM, descrS));
            } else {
                log.debug("SQL FROM MATRIX: [scenario:{}],[description:{}] - column '{}' not found", new Object[]{scenarioName, descrM.getName(), command.getToExecute()});
            }
        });
    }

    public void sshScenario(Scenario sceMain, Scenario sceSec, Command command) {
        sceMain.getDescriptions().forEach(descriptionMain -> {
            Description descriptionSecond = sceSec == null ? null : (Description)sceSec.getDescriptions().stream().filter(descr -> descr.getName().equals(descriptionMain.getName())).findFirst().orElse(null);
            this.sshDescriptionToExecute(sceMain.getName(), (Description)descriptionMain, descriptionSecond, command);
        });
        if (sceSec != null) {
            sceSec.getDescriptions().forEach(descriptionMain -> {
                Description descriptionSecond = sceMain.getDescriptions().stream().filter(descr -> descr.getName().equals(descriptionMain.getName())).findFirst().orElse(null);
                this.sshDescriptionToExecute(sceSec.getName(), (Description)descriptionMain, descriptionSecond, command);
            });
        }
    }

    private void sshDescriptionToExecute(String scenarioName, Description descrM, Description descrS, Command command) {
        this.parseListToExecuteWithConsumer(command, columnToExecute -> {
            Command currCommand = new Command(command);
            log.info("SSH FROM MATRIX: [scenario:{}],[description:{}],[column:{}]", new Object[]{scenarioName, descrM.getName(), command.getToExecute()});
            if (descrM.getOtherParams() != null && descrM.getOtherParams().containsKey(columnToExecute)) {
                currCommand.setToExecute(descrM.getOtherParams().get(columnToExecute));
                descrM.getOtherParams().put((String)columnToExecute, this.executeSsh(currCommand, descrM, descrS));
            } else if (descrM.getEventParams() != null && descrM.getEventParams().containsKey(columnToExecute)) {
                currCommand.setToExecute(descrM.getEventParams().get(columnToExecute));
                descrM.getEventParams().put((String)columnToExecute, this.executeSsh(currCommand, descrM, descrS));
            } else if (descrM.getValidationParams() != null && descrM.getValidationParams().containsKey(columnToExecute)) {
                currCommand.setToExecute(descrM.getValidationParams().get(columnToExecute));
                descrM.getValidationParams().put((String)columnToExecute, this.executeSsh(currCommand, descrM, descrS));
            } else {
                log.debug("SSH FROM MATRIX: [scenario:{}],[description:{}] - column '{}' not found", new Object[]{scenarioName, descrM.getName(), command.getToExecute()});
            }
        });
    }

    private String executeSsh(Command command, Description descrM, Description descrS) {
        return this.executeWithFunction("SSH", command, descrM, descrS, () -> this.shellRepo.executeAndGetLog(command));
    }

    public void soapScenario(Scenario sceMain, Scenario sceSec, Command command) {
        sceMain.getDescriptions().forEach(descriptionMain -> {
            Description descriptionSecond = sceSec == null ? null : (Description)sceSec.getDescriptions().stream().filter(descr -> descr.getName().equals(descriptionMain.getName())).findFirst().orElse(null);
            this.soapDescriptionToExecute(sceMain.getName(), (Description)descriptionMain, descriptionSecond, command);
        });
        if (sceSec != null) {
            sceSec.getDescriptions().forEach(descriptionMain -> {
                Description descriptionSecond = sceMain.getDescriptions().stream().filter(descr -> descr.getName().equals(descriptionMain.getName())).findFirst().orElse(null);
                this.soapDescriptionToExecute(sceSec.getName(), (Description)descriptionMain, descriptionSecond, command);
            });
        }
    }

    private void soapDescriptionToExecute(String scenarioName, Description descrM, Description descrS, Command command) {
        this.parseListToExecuteWithConsumer(command, columnToExecute -> {
            log.info("SOAP FROM MATRIX: [scenario:{}],[description:{}],[column:{}]", new Object[]{scenarioName, descrM.getName(), command.getToExecute()});
            Command currCommand = new Command(command);
            currCommand.setSoap(new Soap(command.getSoap().getEndpoint()));
            if (descrM.getOtherParams() != null && descrM.getOtherParams().containsKey(columnToExecute)) {
                currCommand.getSoap().setRequestFile(descrM.getOtherParams().get(columnToExecute));
                descrM.getOtherParams().put((String)columnToExecute, this.executeSoap(currCommand, descrM, descrS));
            } else if (descrM.getEventParams() != null && descrM.getEventParams().containsKey(columnToExecute)) {
                currCommand.getSoap().setRequestFile(descrM.getEventParams().get(columnToExecute));
                descrM.getEventParams().put((String)columnToExecute, this.executeSoap(currCommand, descrM, descrS));
            } else if (descrM.getValidationParams() != null && descrM.getValidationParams().containsKey(columnToExecute)) {
                currCommand.getSoap().setRequestFile(descrM.getValidationParams().get(columnToExecute));
                descrM.getValidationParams().put((String)columnToExecute, this.executeSoap(currCommand, descrM, descrS));
            } else {
                log.debug("SOAP FROM MATRIX: [scenario:{}],[description:{}] - column '{}' not found", new Object[]{scenarioName, descrM.getName(), command.getToExecute()});
            }
        });
    }

    private String executeSoap(Command command, Description descrM, Description descrS) {
        return this.executeWithFunction("SOAP", command, descrM, descrS, () -> this.soapService.sendSoapRequest(command));
    }

    public void restScenario(Scenario sceMain, Scenario sceSec, Command command) {
        sceMain.getDescriptions().forEach(descriptionMain -> {
            Description descriptionSecond = sceSec == null ? null : (Description)sceSec.getDescriptions().stream().filter(descr -> descr.getName().equals(descriptionMain.getName())).findFirst().orElse(null);
            this.restDescriptionToExecute(sceMain.getName(), (Description)descriptionMain, descriptionSecond, command);
        });
        if (sceSec != null) {
            sceSec.getDescriptions().forEach(descriptionMain -> {
                Description descriptionSecond = sceMain.getDescriptions().stream().filter(descr -> descr.getName().equals(descriptionMain.getName())).findFirst().orElse(null);
                this.restDescriptionToExecute(sceSec.getName(), (Description)descriptionMain, descriptionSecond, command);
            });
        }
    }

    private void restDescriptionToExecute(String scenarioName, Description descrM, Description descrS, Command command) {
        this.parseListToExecuteWithConsumer(command, columnToExecute -> {
            log.info("REST FROM MATRIX: [scenario:{}],[description:{}],[column:{}]", new Object[]{scenarioName, descrM.getName(), columnToExecute});
            Command currCommand = new Command(command);
            currCommand.setRest(Rest.builder().build());
            if (descrM.getOtherParams() != null && descrM.getOtherParams().containsKey(columnToExecute)) {
                currCommand.getRest().setRestFile(descrM.getOtherParams().get(columnToExecute));
                descrM.getOtherParams().put((String)columnToExecute, this.executeRest(currCommand, descrM, descrS));
            } else if (descrM.getEventParams() != null && descrM.getEventParams().containsKey(columnToExecute)) {
                currCommand.getRest().setRestFile(descrM.getEventParams().get(columnToExecute));
                descrM.getEventParams().put((String)columnToExecute, this.executeRest(currCommand, descrM, descrS));
            } else if (descrM.getValidationParams() != null && descrM.getValidationParams().containsKey(columnToExecute)) {
                currCommand.getRest().setRestFile(descrM.getValidationParams().get(columnToExecute));
                descrM.getValidationParams().put((String)columnToExecute, this.executeRest(currCommand, descrM, descrS));
            } else {
                log.debug("REST FROM MATRIX: [scenario:{}],[description:{}] - column '{}' not found", new Object[]{scenarioName, descrM.getName(), columnToExecute});
            }
        });
    }

    private String executeRest(Command command, Description descrM, Description descrS) {
        return this.executeWithFunction("REST", command, descrM, descrS, () -> this.restService.sendRestRequest(command));
    }

    public Map<String, String> getParametersFromDescriptions(Description descrM, Description descrS) {
        LinkedHashMap<String, String> allParams = descrM.getAllParams();
        if (descrS != null) {
            allParams.putAll(descrS.getAllParams());
        }
        return allParams;
    }

    private String executeSqlFromCell(String value, String system, Description descrM, Description descrS) {
        return this.executeSqlFromCell(value, system, this.getParametersFromDescriptions(descrM, descrS));
    }

    private String executeSqlFromCell(String value, String system, Map<String, String> params) {
        if (value != null && value.toLowerCase().endsWith(".sql")) {
            try {
                List<CommandResponse> result = this.sqlService.executeCommand(value, system, params, false);
                value = result.size() > 0 && result.get(0).getSqlResponse() != null && result.get(0).getSqlResponse().getData() != null && result.get(0).getSqlResponse().getData().getData() != null && result.get(0).getSqlResponse().getData().getData().size() > 0 && result.get(0).getSqlResponse().getData().getData().get(0) != null && result.get(0).getSqlResponse().getData().getData().get(0).size() > 0 ? result.get(0).getSqlResponse().getData().getData().get(0).get(0) : "SQL ERROR: can't parse result of execution";
            }
            catch (Exception e) {
                value = Utils.maxExcelString("SQL ERROR: " + e.getMessage());
            }
        }
        return value;
    }

    private String addColumnWithParsingFromLog(Command command, CommandResponse response, Description description) {
        String stringResponse = String.join((CharSequence)"\n", response.getCommandOutputs().get(0).contentFromFile());
        if (stringResponse != null && command.getVariablesToExtractFromLog() != null) {
            command.getVariablesToExtractFromLog().forEach((columnName, regex) -> {
                String value = Utils.getFirstGroupFromStringByRegexp(stringResponse, regex);
                if (value != null) {
                    description.addOtherParam((String)columnName, value, this.getTestDataWorkbook());
                }
            });
        }
        return stringResponse;
    }

    private String executeWithFunction(String type, Command command, Description descrM, Description descrS, Supplier<CommandResponse> execution) {
        this.contextRepository.getContext().addParameters(this.getParametersFromDescriptions(descrM, descrS));
        try {
            return this.addColumnWithParsingFromLog(command, execution.get(), descrM);
        }
        catch (Exception e) {
            return type + " ERROR: " + e.getMessage();
        }
    }

    private void parseListToExecuteWithConsumer(Command command, Consumer<String> executionConsumer) {
        String[] columns = command.getToExecute().toUpperCase().split(",");
        if (command.getToExecute().matches("\\[[\\w, ]+\\]")) {
            columns = command.getToExecute().toUpperCase().substring(1, command.getToExecute().length() - 1).split(", ");
        } else {
            columns[0] = command.getToExecute().toUpperCase();
        }
        for (String columnToExecute : columns) {
            executionConsumer.accept(columnToExecute.trim());
        }
    }

    public TestDataRepository(ContextRepository contextRepository, SqlExecutionHelperService sqlService, SoapExecutionHelperService soapService, RestExecutionHelperService restService, ShellRepository shellRepo, MiaContext miaContext, MiaFileService miaFileService) {
        this.contextRepository = contextRepository;
        this.sqlService = sqlService;
        this.soapService = soapService;
        this.restService = restService;
        this.shellRepo = shellRepo;
        this.miaContext = miaContext;
        this.miaFileService = miaFileService;
    }
}

