/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.repo.impl.pool.ssh;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.qubership.atp.mia.model.configuration.CommonConfiguration;
import org.qubership.atp.mia.model.environment.Server;
import org.qubership.atp.mia.repo.impl.SshConnectionManager;
import org.qubership.atp.mia.repo.impl.SshSession;
import org.qubership.atp.mia.repo.impl.pool.ssh.ConnectionPool;
import org.qubership.atp.mia.service.MiaContext;
import org.qubership.atp.mia.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SshSessionPool
implements ConnectionPool {
    private static final Logger log = LoggerFactory.getLogger(SshSessionPool.class);
    public static final Map<UUID, Boolean> systemsForTimeShifting = new ConcurrentHashMap<UUID, Boolean>();
    private static final Map<Server, SshSession> connectionCache = new ConcurrentHashMap<Server, SshSession>();
    private static final Map<Server, SshSession> timeShiftStorage = new ConcurrentHashMap<Server, SshSession>();
    public static int KEEP_ALIVE_MSG_INTERVAL;
    private final MiaContext miaContext;

    public SshSessionPool(@Value(value="${ssh.close.delay:300}") String cleanTimeout, @Value(value="${db.server.keep.alive:30000}") String keepAlive, MiaContext miaContext) {
        KEEP_ALIVE_MSG_INTERVAL = (int)Utils.parseLongValueOrDefault(keepAlive, 30000L, "db.server.keep.alive");
        long cleanCacheTimeout = Utils.parseLongValueOrDefault(cleanTimeout, 180L, "ssh.close.delay");
        ScheduledExecutorService cleanConnectionPool = Executors.newSingleThreadScheduledExecutor();
        cleanConnectionPool.scheduleAtFixedRate(this::cleanConnectionCache, 0L, cleanCacheTimeout, TimeUnit.SECONDS);
        ScheduledExecutorService cleanTimeShiftPool = Executors.newSingleThreadScheduledExecutor();
        cleanTimeShiftPool.scheduleAtFixedRate(this::cleanTimeShiftMap, 0L, cleanCacheTimeout, TimeUnit.SECONDS);
        this.miaContext = miaContext;
    }

    private SshSession createSession(Server server, CommonConfiguration config) {
        log.debug("Connection is not present in cache. Initiating a new manager for server: {}", (Object)server.toString());
        return new SshSession(server, config);
    }

    public void addTimeShiftSession(Server server, CommonConfiguration configuration) {
        if (!timeShiftStorage.containsKey(server)) {
            timeShiftStorage.put(server, this.createSession(server, configuration));
            log.debug("Added timeshift session for server: {}", (Object)server);
        }
    }

    public void removeTimeShiftSession(Server server) {
        log.debug("Removing timeshift session for server: {}", (Object)server);
        Optional<SshSession> removed = Optional.ofNullable(timeShiftStorage.remove(server));
        if (removed.isPresent()) {
            removed.get().disconnect();
            log.debug("Removing timeshift session for server: {}", (Object)server);
        }
    }

    private boolean isTimeShiftOn(UUID systemId) {
        return systemId != null && systemsForTimeShifting.containsKey(systemId) && systemsForTimeShifting.get(systemId) != false;
    }

    @Override
    public SshConnectionManager getConnection(Server server, String extPrefix) {
        log.debug("Searching for open ssh connection by server: [{}]", (Object)server.toString());
        SshSession session = this.getTimeShiftSession(server).orElse(this.getCommonSession(server));
        return new SshConnectionManager(session, extPrefix, this.miaContext);
    }

    private SshSession getCommonSession(Server server) {
        log.trace("Trying to get session. Count of connections in storage: [{}]", (Object)connectionCache.size());
        CommonConfiguration commonConfiguration = this.miaContext.getConfig().getCommonConfiguration();
        SshSession session = connectionCache.get(server);
        if (session == null || !session.isSame(server, commonConfiguration)) {
            session = this.createSession(server, commonConfiguration);
            Optional.ofNullable(connectionCache.put(server, session)).ifPresent(SshSession::disconnect);
        }
        return session;
    }

    private Optional<SshSession> getTimeShiftSession(Server server) {
        if (this.isTimeShiftOn(server.getConnection().getSystemId())) {
            log.debug("Timeshift for server is on: [{}]", (Object)server);
            SshSession conn = timeShiftStorage.get(server);
            if (conn == null) {
                log.error("Connection to timeShift is null, but should be open! Reopening...");
                conn = this.createSession(server, this.miaContext.getConfig().getCommonConfiguration());
            } else {
                log.debug("Found cached and open timeShift session for server: [{}]", (Object)server);
            }
            timeShiftStorage.put(server, conn);
            return Optional.of(conn);
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanConnectionCache() {
        Thread.currentThread().setName("mia_cleanConnectionCache");
        log.info("Try to clean SSH connection cache");
        Map<Server, SshSession> map = connectionCache;
        synchronized (map) {
            int size = connectionCache.size();
            boolean isDelete = connectionCache.entrySet().removeIf(e -> !((SshSession)e.getValue()).isExecuting() && ((SshSession)e.getValue()).disconnect());
            log.info("{} connectionCache size before: {}, after: {}", new Object[]{isDelete ? "Removed some entities in ts map" : "Nothing removed", size, connectionCache.size()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanTimeShiftMap() {
        boolean isDelete;
        int size;
        Thread.currentThread().setName("mia_cleanTimeShiftMap");
        log.trace("Try to clean time shift map");
        Map<Object, Object> map = systemsForTimeShifting;
        synchronized (map) {
            log.trace("Clean time shift map");
            size = systemsForTimeShifting.size();
            isDelete = systemsForTimeShifting.entrySet().removeIf(e -> (Boolean)e.getValue() == false);
            log.trace("{} systemsForTimeShifting size before: {}, after: {}", new Object[]{isDelete ? "Removed some entities in ts map" : "Nothing removed", size, timeShiftStorage.size()});
        }
        map = timeShiftStorage;
        synchronized (map) {
            size = timeShiftStorage.size();
            isDelete = timeShiftStorage.entrySet().removeIf(e -> !((SshSession)e.getValue()).isExecuting() && this.isTimeShiftOn(((Server)e.getKey()).getConnection().getSystemId()));
            log.trace("{} timeShiftStorage size before: {}, after: {}", new Object[]{isDelete ? "Removed some entities in ts map" : "Nothing removed", size, timeShiftStorage.size()});
        }
        log.trace("Cleaning over for time shift map");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetCache() {
        log.info("Cleaning ssh cache. Current size.\n connection: {}; systemsForTimeshifting: {}; timeshiftStorage: {}", new Object[]{connectionCache.size(), systemsForTimeShifting.size(), timeShiftStorage.size()});
        Map<Object, Object> map = connectionCache;
        synchronized (map) {
            connectionCache.clear();
        }
        map = systemsForTimeShifting;
        synchronized (map) {
            systemsForTimeShifting.clear();
        }
        map = timeShiftStorage;
        synchronized (map) {
            timeShiftStorage.clear();
        }
        log.info("Complete clean manually ssh cache.");
    }
}

