/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.repo.migration.v2;

import java.util.Arrays;
import java.util.UUID;
import java.util.stream.Collectors;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.qubership.atp.auth.springbootstarter.entities.ServiceEntities;
import org.qubership.atp.auth.springbootstarter.services.UsersService;
import org.qubership.atp.mia.config.BeanAwareSpringLiquibase;
import org.qubership.atp.mia.model.UserManagementEntities;

public class ServiceEntitiesMigrationCustomChange
implements CustomTaskChange {
    private String serviceName;
    private static final UUID SERVICE_ENTITIES_ID = UUID.fromString("d1dd25c3-5d8e-4398-b258-9f6471ee85d2");

    public void execute(Database database) {
        ServiceEntities entities = new ServiceEntities();
        entities.setUuid(SERVICE_ENTITIES_ID);
        entities.setService(this.serviceName);
        entities.setEntities(Arrays.stream(UserManagementEntities.values()).map(UserManagementEntities::getName).collect(Collectors.toList()));
        UsersService usersService = BeanAwareSpringLiquibase.getBean(UsersService.class);
        usersService.sendEntities(entities);
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
}

