/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service;

import org.qubership.atp.common.lock.LockManager;
import org.qubership.atp.mia.repo.configuration.ProjectFileRepository;
import org.qubership.atp.mia.service.configuration.EnvironmentsService;
import org.qubership.atp.mia.service.execution.RecordingSessionsService;
import org.qubership.atp.mia.service.file.GridFsService;
import org.qubership.atp.mia.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleService.class);
    private final GridFsService gridFsService;
    private final LockManager lockManager;
    private final RecordingSessionsService recordingSessionsService;
    private final EnvironmentsService environmentsService;
    private final ProjectFileRepository projectFileRepository;
    @Value(value="${gridfs.enable}")
    private Boolean gridFsEnable;
    @Value(value="${atp.clean.logs.interval.hours}")
    private String cleanInterval;

    @Scheduled(cron="${atp.mia.cron.clean.gridfs}")
    public void cleanDb() {
        this.lockManager.executeWithLock("mia_cleanMongoDb", () -> {
            log.info("Scheduled clean GridFs job started");
            this.gridFsService.cleanDb();
            log.info("Scheduled clean GridFs job finished");
        });
    }

    @Scheduled(cron="${atp.mia.cron.clean.logs}")
    public void cleanLogs() {
        if (this.gridFsEnable.booleanValue()) {
            this.lockManager.executeWithLock("mia_cleanDb", () -> {
                log.info("Scheduled clean logs job started");
                this.gridFsService.cleanLogs((int)Utils.parseLongValueOrDefault(this.cleanInterval, 1L, "CleanLogInterval"));
                log.info("Scheduled clean logs job finished");
            });
        }
    }

    @Scheduled(cron="${atp.mia.cron.clean.postgresql}")
    public void cleanPostgresqlPot() {
        this.lockManager.executeWithLock("mia_cleanPostgresql", () -> {
            log.info("Scheduled clean postgresql POT tables job started");
            this.recordingSessionsService.deleteOldSession();
            log.info("Scheduled clean postgresql POT tables finished");
        });
    }

    public ScheduleService(GridFsService gridFsService, LockManager lockManager, RecordingSessionsService recordingSessionsService, EnvironmentsService environmentsService, ProjectFileRepository projectFileRepository) {
        this.gridFsService = gridFsService;
        this.lockManager = lockManager;
        this.recordingSessionsService = recordingSessionsService;
        this.environmentsService = environmentsService;
        this.projectFileRepository = projectFileRepository;
    }
}

