/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.configuration;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.util.Strings;
import org.modelmapper.ModelMapper;
import org.qubership.atp.mia.controllers.api.dto.ExecutableDto;
import org.qubership.atp.mia.controllers.api.dto.FlowConfigDto;
import org.qubership.atp.mia.controllers.api.dto.FlowConfigSectionDto;
import org.qubership.atp.mia.exceptions.configuration.SerializeFlowJsonFailedException;
import org.qubership.atp.mia.exceptions.configuration.SerializeProcessFileException;
import org.qubership.atp.mia.model.configuration.CompoundConfiguration;
import org.qubership.atp.mia.model.configuration.ProcessConfiguration;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.configuration.SectionConfiguration;
import org.qubership.atp.mia.model.exception.MiaException;
import org.qubership.atp.mia.model.file.FileMetaData;
import org.qubership.atp.mia.model.file.ProjectFile;
import org.qubership.atp.mia.model.file.ProjectFileType;
import org.qubership.atp.mia.service.AtpUserService;
import org.qubership.atp.mia.service.file.MiaFileService;
import org.qubership.atp.mia.service.git.GitService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ConfigurationFileSerializer {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationFileSerializer.class);
    public static final String FILE_FLOW_JSON = "Flow.json";
    private static final ObjectMapper objMapper = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().serializationInclusion(JsonInclude.Include.NON_NULL)).configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true)).build();
    private final GitService gitService;
    private final MiaFileService miaFileService;
    private final ModelMapper modelMapper;
    private final AtpUserService atpUserService;

    public FlowConfigDto getOldConfig(ProjectConfiguration projectConfiguration, boolean isForFile) {
        LinkedList<SectionConfiguration> sections = projectConfiguration.getRootSections();
        List<FlowConfigSectionDto> flowConfigSections = sections.stream().filter(Objects::nonNull).map(s -> this.makeOldSection((SectionConfiguration)s, isForFile)).collect(Collectors.toList());
        FlowConfigDto flowConfigDto = (FlowConfigDto)this.modelMapper.map((Object)projectConfiguration, FlowConfigDto.class);
        flowConfigDto.setDefaultSystem(projectConfiguration.getCommonConfiguration().getDefaultSystem());
        flowConfigDto.setSections(flowConfigSections);
        return flowConfigDto;
    }

    public void serialize(ProjectConfiguration config, Path projectConfigurationPath, boolean isEtalonFiles) throws MiaException {
        try {
            log.info("Serialize configuration for project with ID #{} into folder {}", (Object)config.getProjectId(), (Object)projectConfigurationPath);
            this.gitService.downloadGitRepo(config.getGitUrl(), projectConfigurationPath);
            if (isEtalonFiles) {
                this.serializeEtalonFiles(config, projectConfigurationPath);
            } else {
                this.serializeGeneralConfiguration(config, projectConfigurationPath);
            }
            this.gitService.gitCommitAndPush(projectConfigurationPath, "Automatic update FROM MIA tool triggered by " + this.atpUserService.getAtpUser());
        }
        catch (Exception e) {
            log.error("Error during serialization: {}", (Object)e.getMessage(), (Object)e);
            throw new SerializeFlowJsonFailedException(e.getMessage());
        }
        finally {
            try {
                org.qubership.atp.mia.utils.FileUtils.deleteFolder(projectConfigurationPath.toFile(), true);
            }
            catch (Exception e) {
                log.info("Problem Deleting local directory, {}", (Object)e.getMessage());
            }
        }
    }

    public void serializeToPath(ProjectConfiguration config, Path projectConfigurationPath) throws MiaException {
        try {
            this.serializeGeneralConfiguration(config, projectConfigurationPath);
            this.serializeEtalonFiles(config, projectConfigurationPath);
        }
        catch (Exception e) {
            log.error("Error during serialization to path: {}", (Object)e.getMessage(), (Object)e);
            throw new SerializeFlowJsonFailedException(e.getMessage());
        }
    }

    private ExecutableDto makeOldProcess(@NonNull ProcessConfiguration process, boolean isForFile) {
        if (process == null) {
            throw new NullPointerException("process is marked non-null but is null");
        }
        ExecutableDto executableDto = isForFile ? ((ExecutableDto)this.modelMapper.map((Object)process, ExecutableDto.class)).id(process.getId()) : (ExecutableDto)this.modelMapper.map((Object)process.getProcessSettings(), ExecutableDto.class);
        return executableDto.execType("Process").name(process.getName());
    }

    private FlowConfigSectionDto makeOldSection(SectionConfiguration section, boolean isForFile) {
        FlowConfigSectionDto flowConfigSection = new FlowConfigSectionDto().name(section.getName()).id(section.getId());
        if (!CollectionUtils.isEmpty(section.getSections())) {
            List<FlowConfigSectionDto> flowConfigSections = section.getSections().stream().filter(Objects::nonNull).map(s -> this.makeOldSection((SectionConfiguration)s, isForFile)).collect(Collectors.toList());
            flowConfigSection.sections(flowConfigSections);
        }
        ArrayList<ExecutableDto> executableDtoList = new ArrayList<ExecutableDto>();
        if (!CollectionUtils.isEmpty(section.getCompounds())) {
            for (CompoundConfiguration c : section.getCompounds()) {
                ExecutableDto executableDto = new ExecutableDto().id(c.getId()).name(c.getName()).execType("Compound").referToInput(c.getReferToInput()).processList(new ArrayList<ExecutableDto>());
                if (c.getProcesses() != null && !c.getProcesses().isEmpty()) {
                    c.getProcesses().stream().filter(Objects::nonNull).forEach(p -> executableDto.getProcessList().add(this.makeOldProcess((ProcessConfiguration)p, isForFile)));
                }
                executableDtoList.add(executableDto);
            }
        }
        if (!CollectionUtils.isEmpty(section.getProcesses())) {
            section.getProcesses().stream().filter(Objects::nonNull).forEach(p -> executableDtoList.add(this.makeOldProcess((ProcessConfiguration)p, isForFile)));
        }
        if (!CollectionUtils.isEmpty(executableDtoList)) {
            flowConfigSection.processes(executableDtoList);
        }
        return flowConfigSection;
    }

    private void serializeEtalonFiles(ProjectConfiguration config, Path projectConfigurationPath) {
        log.info("Serializing of etalon files is started for project: {}, configuration path: {}", (Object)config.getProjectId(), (Object)projectConfigurationPath);
        Path etalonFilesPath = projectConfigurationPath.resolve(config.getCommonConfiguration().getEthalonFilesPath());
        try {
            FileUtils.deleteDirectory((File)etalonFilesPath.toFile());
        }
        catch (IOException e) {
            log.warn("Could not delete existing etalon directory: {}. Reason: {}", (Object)etalonFilesPath, (Object)e.getMessage());
        }
        etalonFilesPath.toFile().mkdirs();
        config.getAllDirectories().forEach(d -> {
            File dirFile = etalonFilesPath.resolve(d.getPathDirectory()).toFile();
            if (dirFile.exists() && dirFile.isFile()) {
                dirFile.delete();
            }
            dirFile.mkdirs();
        });
        for (ProjectFile f : config.getFiles()) {
            Path filePath = f.getPathFile();
            File sourceFile = FileMetaData.PROJECT_FOLDER.resolve(config.getProjectId().toString()).resolve(ProjectFileType.MIA_FILE_TYPE_PROJECT.toString()).resolve(filePath).toFile();
            try {
                InputStream is = Files.newInputStream(this.miaFileService.getFile(sourceFile).toPath(), new OpenOption[0]);
                try {
                    File targetFile = etalonFilesPath.resolve(filePath).toFile();
                    if (targetFile.exists()) {
                        targetFile.delete();
                    }
                    Files.copy(is, targetFile.toPath(), new CopyOption[0]);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException e) {
                log.error("Failed to copy file: {} to etalon path", (Object)sourceFile.getAbsolutePath(), (Object)e);
            }
        }
        log.info("Serializing of etalon files is completed for project: {}, configuration path: {}", (Object)config.getProjectId(), (Object)projectConfigurationPath);
    }

    private void serializeGeneralConfiguration(ProjectConfiguration config, Path projectConfigurationPath) throws IOException {
        Path flowPath = projectConfigurationPath.resolve("flow");
        File flowJsonFile = flowPath.resolve(FILE_FLOW_JSON).toFile();
        flowJsonFile.getParentFile().mkdirs();
        if (flowJsonFile.exists()) {
            flowJsonFile.delete();
        }
        objMapper.writerWithDefaultPrettyPrinter().writeValue(flowJsonFile, (Object)this.getOldConfig(config, true));
        this.updateProcessFiles(config.getProcesses(), flowPath);
    }

    private void updateProcessFiles(List<ProcessConfiguration> processes, Path flowPath) throws IOException {
        for (ProcessConfiguration proc : processes) {
            proc.getProcessSettings().setName(proc.getName());
            File processFilePath = Strings.isNotBlank((String)proc.getPathToFile()) ? flowPath.resolve(proc.getPathToFile()).toFile() : flowPath.resolve(proc.getName() + ".json").toFile();
            try {
                processFilePath.getParentFile().mkdirs();
                if (processFilePath.exists()) {
                    processFilePath.delete();
                }
            }
            catch (Exception e) {
                throw new SerializeProcessFileException(e);
            }
            objMapper.writerWithDefaultPrettyPrinter().writeValue(processFilePath, (Object)proc.getProcessSettings());
        }
    }

    public ConfigurationFileSerializer(GitService gitService, MiaFileService miaFileService, ModelMapper modelMapper, AtpUserService atpUserService) {
        this.gitService = gitService;
        this.miaFileService = miaFileService;
        this.modelMapper = modelMapper;
        this.atpUserService = atpUserService;
    }
}

