/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.configuration;

import java.time.LocalDateTime;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import org.modelmapper.ModelMapper;
import org.qubership.atp.mia.controllers.api.dto.MoveProjectFileRequestDto;
import org.qubership.atp.mia.controllers.api.dto.ProjectFileDto;
import org.qubership.atp.mia.exceptions.configuration.DeleteFileException;
import org.qubership.atp.mia.exceptions.configuration.DeleteFileGitSynchronizeException;
import org.qubership.atp.mia.exceptions.configuration.DuplicateFileException;
import org.qubership.atp.mia.exceptions.configuration.FIleNotFoundException;
import org.qubership.atp.mia.exceptions.configuration.SerializeFlowJsonFailedException;
import org.qubership.atp.mia.exceptions.configuration.UpdateFileException;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.file.ProjectDirectory;
import org.qubership.atp.mia.model.file.ProjectFile;
import org.qubership.atp.mia.model.file.ProjectFileType;
import org.qubership.atp.mia.repo.configuration.FileConfigurationRepository;
import org.qubership.atp.mia.service.AtpUserService;
import org.qubership.atp.mia.service.configuration.DirectoryConfigurationService;
import org.qubership.atp.mia.service.configuration.ProjectConfigurationService;
import org.qubership.atp.mia.service.file.GridFsService;
import org.qubership.atp.mia.service.file.MiaFileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(FileConfigurationService.class);
    private final AtpUserService atpUserService;
    private final FileConfigurationRepository fileConfigurationRepository;
    private final GridFsService gridFsService;
    private final MiaFileService miaFileService;
    private final ModelMapper modelMapper;
    private final ProjectConfigurationService projectConfigurationService;

    public void addProjectFile(ProjectConfiguration projectConfiguration, MultipartFile file, ProjectFileDto projectFileDto) {
        log.info("Create file: '{}'", (Object)projectFileDto);
        if (projectConfiguration.getFiles().stream().anyMatch(f -> {
            if (f.getName().equals(projectFileDto.getName())) {
                if (f.getDirectory() != null) {
                    return f.getDirectory().getId().equals(projectFileDto.getDirectory());
                }
                return projectFileDto.getDirectory() == null;
            }
            return false;
        })) {
            throw new DuplicateFileException(projectFileDto.getName());
        }
        ProjectFile projectFile = this.createProjectFile(projectConfiguration, file, projectFileDto);
        try {
            this.projectConfigurationService.synchronizeConfiguration(projectConfiguration.getProjectId(), () -> {
                this.fileConfigurationRepository.save(projectFile);
                return projectConfiguration;
            }, true);
        }
        catch (Exception e) {
            this.miaFileService.removeProjectFile(projectFile);
        }
    }

    public void deleteFile(ProjectConfiguration projectConfiguration, ProjectFile projectFile, boolean removeFromParentFolder) {
        log.warn("Delete file '{}' with ID '{}' from directory '{}'", new Object[]{projectFile.getName(), projectFile.getId(), projectFile.getDirectory() == null ? "ROOT" : projectFile.getDirectory().getName()});
        this.miaFileService.removeProjectFile(projectFile);
        if (projectFile.getDirectory() != null && removeFromParentFolder) {
            projectFile.getDirectory().getFiles().remove(projectFile);
        }
        projectConfiguration.getFiles().remove(projectFile);
        this.projectConfigurationService.synchronizeConfiguration(projectConfiguration.getProjectId(), () -> {
            this.fileConfigurationRepository.delete(projectFile);
            return projectConfiguration;
        }, true);
    }

    public void deleteProjectFile(ProjectConfiguration projectConfiguration, UUID projectFileId) {
        log.info("Delete file with ID '{}'", (Object)projectFileId);
        ProjectFile projectFile = (ProjectFile)this.fileConfigurationRepository.findById(projectFileId).orElseThrow(() -> new FIleNotFoundException(projectFileId));
        try {
            this.deleteFile(projectConfiguration, projectFile, true);
        }
        catch (SerializeFlowJsonFailedException e) {
            log.error("{}", (Object)e.getMessage());
            throw new DeleteFileGitSynchronizeException((Exception)((Object)e));
        }
        catch (Exception e) {
            throw new DeleteFileException(e);
        }
    }

    public ResponseEntity<Resource> getProjectFile(UUID projectId, UUID projectFileId, ServletContext servletContext) {
        log.info("Get file with ID '{}'", (Object)projectFileId);
        ProjectFile projectFile = this.projectConfigurationService.getConfigByProjectId(projectId).getFiles().stream().filter(file -> file.getId().equals(projectFileId)).findFirst().orElseThrow(() -> new FIleNotFoundException(projectFileId));
        return this.miaFileService.downloadFile(projectId, ProjectFileType.MIA_FILE_TYPE_PROJECT, null, projectFile.getPathFile().toString(), servletContext);
    }

    public void moveProjectFile(ProjectConfiguration projectConfiguration, UUID fileId, MoveProjectFileRequestDto moveProjectFileRequestDto) {
        log.info("Move project file '{}' to {}", (Object)fileId, (Object)moveProjectFileRequestDto);
        ProjectFile projectFile = this.checkAndGetFile(projectConfiguration, fileId);
        try {
            UUID parentDirectoryId = moveProjectFileRequestDto == null || moveProjectFileRequestDto.getDirectory() == null ? null : moveProjectFileRequestDto.getDirectory();
            ProjectDirectory newDirectory = parentDirectoryId != null ? DirectoryConfigurationService.getDirectoryById(projectConfiguration, parentDirectoryId) : null;
            this.findFileWithTheSameNameAndDeleteIt(projectConfiguration, newDirectory, projectFile.getName());
            ProjectDirectory currentDirectory = projectFile.getDirectory();
            if (currentDirectory != null) {
                currentDirectory.getFiles().remove(projectFile);
            }
            if (newDirectory != null) {
                newDirectory.getFiles().add(projectFile);
            }
            projectFile.setDirectory(newDirectory);
            this.gridFsService.rename(projectFile);
            this.projectConfigurationService.synchronizeConfiguration(projectConfiguration.getProjectId(), () -> {
                this.fileConfigurationRepository.save(projectFile);
                return projectConfiguration;
            }, true);
        }
        catch (Exception e) {
            throw new UpdateFileException(e);
        }
    }

    public void updateProjectFile(ProjectConfiguration projectConfiguration, MultipartFile file, ProjectFileDto projectFileDto) {
        log.info("Update file '{}'", (Object)projectFileDto);
        ProjectFile projectFile = this.checkAndGetFile(projectConfiguration, projectFileDto.getId());
        try {
            if (projectFileDto.getName() != null && !projectFile.getName().equals(projectFileDto.getName())) {
                this.miaFileService.renameProjectFile(projectFile, projectFileDto.getName());
            }
            if (file != null && !file.isEmpty()) {
                projectFile.setLastUpdateBy(this.atpUserService.getAtpUser());
                LocalDateTime updatedTime = LocalDateTime.now();
                projectFile.setLastUpdateWhen(updatedTime);
                projectFile.setSize(file.getSize());
                projectFile.getProjectConfiguration().setLastLoadedWhen(updatedTime);
                projectFile.setGridFsObjectId(this.miaFileService.saveProjectFile(file, projectFile.getPathFile()).toString());
            }
            this.projectConfigurationService.synchronizeConfiguration(projectConfiguration.getProjectId(), () -> {
                this.fileConfigurationRepository.save(projectFile);
                return projectConfiguration;
            }, true);
        }
        catch (Exception e) {
            throw new UpdateFileException(e);
        }
    }

    private ProjectFile checkAndGetFile(ProjectConfiguration projectConfiguration, UUID fileId) {
        Optional<ProjectFile> optionalProjectFile = projectConfiguration.getFiles().stream().filter(f -> f.getId().equals(fileId)).findFirst();
        if (!optionalProjectFile.isPresent()) {
            throw new FIleNotFoundException(fileId);
        }
        return optionalProjectFile.get();
    }

    private ProjectFile createProjectFile(ProjectConfiguration projectConfiguration, MultipartFile file, ProjectFileDto projectFileDto) {
        ProjectFile projectFile = (ProjectFile)this.modelMapper.map((Object)projectFileDto, ProjectFile.class);
        projectFile.setProjectConfiguration(projectConfiguration);
        if (projectFileDto.getDirectory() != null) {
            ProjectDirectory directory = DirectoryConfigurationService.getDirectoryById(projectConfiguration, projectFileDto.getDirectory());
            projectFile.setDirectory(directory);
            directory.getFiles().add(projectFile);
        }
        projectFile.setLastUpdateBy(this.atpUserService.getAtpUser());
        LocalDateTime updatedTime = LocalDateTime.now();
        projectFile.setLastUpdateWhen(updatedTime);
        projectFile.setSize(file.getSize());
        projectFile.getProjectConfiguration().setLastLoadedWhen(updatedTime);
        projectFile.setGridFsObjectId(this.miaFileService.saveProjectFile(file, projectFile.getPathFile()).toString());
        projectConfiguration.getFiles().add(projectFile);
        return projectFile;
    }

    private void findFileWithTheSameNameAndDeleteIt(ProjectConfiguration projectConfiguration, ProjectDirectory projectDirectory, String fileName) {
        Stream files = projectDirectory == null ? projectConfiguration.getRootFiles().stream() : projectDirectory.getFiles().stream();
        files.filter(f -> f.getName().equals(fileName)).collect(Collectors.toSet()).forEach(f -> this.deleteFile(projectConfiguration, (ProjectFile)f, true));
    }

    public FileConfigurationService(AtpUserService atpUserService, FileConfigurationRepository fileConfigurationRepository, GridFsService gridFsService, MiaFileService miaFileService, ModelMapper modelMapper, ProjectConfigurationService projectConfigurationService) {
        this.atpUserService = atpUserService;
        this.fileConfigurationRepository = fileConfigurationRepository;
        this.gridFsService = gridFsService;
        this.miaFileService = miaFileService;
        this.modelMapper = modelMapper;
        this.projectConfigurationService = projectConfigurationService;
    }
}

