/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.configuration;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.ws.Holder;
import org.modelmapper.ModelMapper;
import org.modelmapper.TypeToken;
import org.qubership.atp.mia.controllers.api.dto.CompoundDto;
import org.qubership.atp.mia.controllers.api.dto.SectionDto;
import org.qubership.atp.mia.controllers.api.dto.SectionsDto;
import org.qubership.atp.mia.exceptions.configuration.CreateSectionException;
import org.qubership.atp.mia.exceptions.configuration.DeleteSectionException;
import org.qubership.atp.mia.exceptions.configuration.DuplicateSectionException;
import org.qubership.atp.mia.exceptions.configuration.SectionCyclicDependencyException;
import org.qubership.atp.mia.exceptions.configuration.SectionNotFoundException;
import org.qubership.atp.mia.exceptions.configuration.UpdateSectionException;
import org.qubership.atp.mia.exceptions.history.MiaHistoryRevisionRestoreException;
import org.qubership.atp.mia.model.DateAuditorEntity;
import org.qubership.atp.mia.model.configuration.CompoundConfiguration;
import org.qubership.atp.mia.model.configuration.ProcessConfiguration;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.configuration.SectionConfiguration;
import org.qubership.atp.mia.repo.configuration.SectionConfigurationRepository;
import org.qubership.atp.mia.service.configuration.CompoundConfigurationService;
import org.qubership.atp.mia.service.configuration.ProcessConfigurationService;
import org.qubership.atp.mia.service.configuration.ProjectConfigurationService;
import org.qubership.atp.mia.service.history.impl.AbstractEntityHistoryService;
import org.qubership.atp.mia.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SectionConfigurationService
extends AbstractEntityHistoryService<SectionConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(SectionConfigurationService.class);
    private final ModelMapper modelMapper;
    private final ProjectConfigurationService projectConfigurationService;
    private final SectionConfigurationRepository sectionConfigurationRepository;

    public List<SectionsDto> addSection(ProjectConfiguration projectConfiguration, SectionDto sectionDto) {
        log.info("Attempting to create section: '{}'", (Object)sectionDto);
        if (projectConfiguration.getAllSections().stream().anyMatch(s -> {
            if (s.getName().equals(sectionDto.getName())) {
                if (s.getParentSection() != null) {
                    return s.getParentSection().getId().equals(sectionDto.getParentSection());
                }
                return sectionDto.getParentSection() == null;
            }
            return false;
        })) {
            log.error("Duplicate section detected: '{}'", (Object)sectionDto.getName());
            throw new DuplicateSectionException(sectionDto.getName());
        }
        try {
            SectionConfiguration parentSection = sectionDto.getParentSection() == null ? null : this.getSectionById(projectConfiguration, sectionDto.getParentSection());
            DateAuditorEntity sectionConfiguration = ((SectionConfiguration.SectionConfigurationBuilder)((SectionConfiguration.SectionConfigurationBuilder)((SectionConfiguration.SectionConfigurationBuilder)((SectionConfiguration.SectionConfigurationBuilder)((SectionConfiguration.SectionConfigurationBuilder)((SectionConfiguration.SectionConfigurationBuilder)SectionConfiguration.builder().projectConfiguration(projectConfiguration)).name(sectionDto.getName())).parentSection(parentSection)).sections(sectionDto.getSections() == null ? new ArrayList<SectionConfiguration>() : SectionConfigurationService.filterSections(projectConfiguration.getAllSections(), sectionDto.getSections().stream().map(s -> s.getId()).collect(Collectors.toList())))).compounds(sectionDto.getCompounds() == null ? new ArrayList<CompoundConfiguration>() : CompoundConfigurationService.filterCompounds(projectConfiguration.getCompounds(), sectionDto.getCompounds().stream().map(c -> c.getId()).collect(Collectors.toList())))).processes(sectionDto.getProcesses() == null ? new ArrayList<ProcessConfiguration>() : ProcessConfigurationService.filterProcesses(projectConfiguration.getProcesses(), sectionDto.getProcesses()))).build();
            if (parentSection != null) {
                this.addSectionAtCorrectPlace(parentSection.getSections(), (SectionConfiguration)sectionConfiguration, sectionDto.getPlace());
            } else {
                this.addSectionAtCorrectPlace(projectConfiguration.getSections(), (SectionConfiguration)sectionConfiguration, sectionDto.getPlace());
            }
            log.debug("Reordering sections after adding section '{}'", (Object)((SectionConfiguration)sectionConfiguration).getId());
            List<SectionConfiguration> sectionsToSync = this.reorderSections((SectionConfiguration)sectionConfiguration, sectionDto.getPlace());
            this.projectConfigurationService.synchronizeConfiguration(projectConfiguration.getProjectId(), () -> this.lambda$addSection$3((SectionConfiguration)sectionConfiguration, sectionsToSync, projectConfiguration), false);
            log.info("Successfully created section '{}'", (Object)sectionConfiguration);
        }
        catch (Exception e) {
            log.error("Error while creating section '{}': {}", new Object[]{sectionDto.getName(), e.getMessage(), e});
            throw new CreateSectionException(e);
        }
        return this.sectionsDto(projectConfiguration.getRootSections());
    }

    public List<SectionsDto> deleteSection(ProjectConfiguration projectConfiguration, UUID sectionId) {
        log.info("Attempting to delete section with ID '{}'", (Object)sectionId);
        Optional<SectionConfiguration> optionalSectionConfiguration = projectConfiguration.getAllSections().stream().filter(s -> s.getId().equals(sectionId)).findAny();
        if (!optionalSectionConfiguration.isPresent()) {
            throw new SectionNotFoundException(sectionId);
        }
        try {
            SectionConfiguration sectionConfiguration = optionalSectionConfiguration.get();
            ArrayList<SectionConfiguration> siblingsToBeSaved = new ArrayList<SectionConfiguration>();
            projectConfiguration.removeSection(sectionConfiguration);
            if (sectionConfiguration.getParentSection() != null) {
                SectionConfiguration parentSectionConfiguration = this.getSectionById(projectConfiguration, sectionConfiguration.getParentSection().getId());
                parentSectionConfiguration.getSections().remove(sectionConfiguration);
                parentSectionConfiguration.reorderChildSequentially();
                siblingsToBeSaved.addAll(parentSectionConfiguration.getSections());
            } else {
                siblingsToBeSaved.addAll(this.reorderSiblings(projectConfiguration.getRootSections()));
            }
            log.debug("Executing database delete for section '{}'", (Object)sectionConfiguration.getName());
            this.projectConfigurationService.synchronizeConfiguration(projectConfiguration.getProjectId(), () -> {
                this.sectionConfigurationRepository.saveAll(siblingsToBeSaved);
                this.sectionConfigurationRepository.delete(sectionConfiguration);
                return projectConfiguration;
            }, false);
            log.info("Successfully deleted section '{}'", (Object)sectionConfiguration);
        }
        catch (Exception e) {
            log.error("Error while deleting section with ID '{}': {}", new Object[]{sectionId, e.getMessage(), e});
            throw new DeleteSectionException(e);
        }
        return this.sectionsDto(projectConfiguration.getRootSections());
    }

    public static List<SectionConfiguration> filterSections(List<SectionConfiguration> sections, List<UUID> sectionsUuid) {
        log.trace("Filtering {} sections with {} section UUIDs", (Object)sections.size(), (Object)sectionsUuid.size());
        LinkedList<SectionConfiguration> filteredSections = new LinkedList<SectionConfiguration>();
        sectionsUuid.forEach(sectionUUID -> sections.stream().filter(s -> s.getId().equals(sectionUUID)).findAny().ifPresent(filteredSections::add));
        return filteredSections;
    }

    public static List<SectionConfiguration> filterSectionsByIdOrSourceId(List<SectionConfiguration> sections, List<UUID> sectionsUuid) {
        log.trace("Filtering sections by ID or source ID, input size: {}", (Object)sectionsUuid.size());
        LinkedList<SectionConfiguration> filteredSections = new LinkedList<SectionConfiguration>();
        sectionsUuid.forEach(sUuid -> sections.stream().filter(s -> sUuid != null && (sUuid.equals(s.getId()) || sUuid.equals(s.getSourceId()))).findAny().ifPresent(filteredSections::add));
        return filteredSections;
    }

    public SectionConfiguration findSectionByPath(UUID projectId, String miaPath) {
        log.debug("Finding section by path '{}' in project '{}'", (Object)miaPath, (Object)projectId);
        ProjectConfiguration projectConfiguration = this.projectConfigurationService.getConfigByProjectId(projectId);
        String[] sectionNames = miaPath.split("/");
        SectionConfiguration section = null;
        List<SectionConfiguration> sectionByLevel = projectConfiguration.getRootSections();
        Holder parentSectionId = new Holder(null);
        for (String sectionName : sectionNames) {
            Optional<SectionConfiguration> sectionConfig = sectionByLevel.stream().filter(s -> {
                if (s.getParentSection() == null) {
                    return parentSectionId.value == null && s.getName().equalsIgnoreCase(sectionName);
                }
                return s.getParentSection().getId().equals(parentSectionId.value) && s.getName().equalsIgnoreCase(sectionName);
            }).findAny();
            if (!sectionConfig.isPresent()) {
                throw new SectionNotFoundException(sectionName);
            }
            section = sectionConfig.get();
            parentSectionId.value = section.getId();
            sectionByLevel = section.getSections();
        }
        if (section == null) {
            throw new SectionNotFoundException(miaPath);
        }
        log.debug("Found section '{}' for path '{}'", (Object)section.getName(), (Object)miaPath);
        return section;
    }

    public List<SectionsDto> sectionsDto(List<SectionConfiguration> sectionConfigurationList) {
        log.trace("Converting {} section configurations to DTOs", (Object)(sectionConfigurationList != null ? sectionConfigurationList.size() : 0));
        if (sectionConfigurationList != null) {
            Type listType = new TypeToken<List<SectionsDto>>(){}.getType();
            return (List)this.modelMapper.map(sectionConfigurationList, listType);
        }
        return new ArrayList<SectionsDto>();
    }

    public List<SectionsDto> updateSection(ProjectConfiguration projectConfiguration, SectionDto sectionDto) {
        log.info("Attempting to update section: '{}'", (Object)sectionDto);
        SectionConfiguration sectionConfiguration = this.getSectionById(projectConfiguration, sectionDto.getId());
        if (sectionDto.getParentSection() != null && sectionConfiguration.getChildrenUuid().contains(sectionDto.getParentSection())) {
            throw new SectionCyclicDependencyException(sectionDto.getId(), sectionDto.getParentSection());
        }
        try {
            sectionConfiguration.setName(sectionDto.getName());
            SectionConfiguration oldParent = sectionConfiguration.getParentSection();
            SectionConfiguration newParent = sectionDto.getParentSection() != null ? this.getSectionById(projectConfiguration, sectionDto.getParentSection()) : null;
            ArrayList<SectionConfiguration> sectionsToSync = new ArrayList<SectionConfiguration>();
            log.debug("Checking if the old parent '{}' and new parent '{}' are correctly assigned", (Object)(oldParent != null ? oldParent.getName() : "N/A"), (Object)(newParent != null ? newParent.getName() : "N/A"));
            if (!Objects.equals(oldParent, newParent)) {
                if (oldParent != null) {
                    oldParent.getSections().remove(sectionConfiguration);
                    oldParent.reorderChildSequentially();
                    sectionsToSync.addAll(oldParent.getSections());
                } else {
                    projectConfiguration.removeSection(sectionConfiguration);
                    sectionsToSync.addAll(this.reorderSiblings(projectConfiguration.getRootSections()));
                }
                if (newParent != null) {
                    this.addSectionAtCorrectPlace(newParent.getSections(), sectionConfiguration, sectionDto.getPlace());
                } else {
                    this.addSectionAtCorrectPlace(projectConfiguration.getRootSections(), sectionConfiguration, sectionDto.getPlace());
                }
                sectionConfiguration.setParentSection(newParent);
                sectionsToSync.addAll(this.reorderSections(sectionConfiguration, sectionDto.getPlace()));
            } else if (sectionConfiguration.getPlace() != sectionDto.getPlace().intValue()) {
                sectionsToSync.addAll(this.reorderSections(sectionConfiguration, sectionDto.getPlace()));
            } else {
                sectionsToSync.add(sectionConfiguration);
            }
            if (sectionDto.getSections() != null) {
                sectionConfiguration.setSections(SectionConfigurationService.filterSections(projectConfiguration.getAllSections(), sectionDto.getSections().stream().map(SectionDto::getId).collect(Collectors.toList())));
            }
            if (sectionDto.getCompounds() != null) {
                sectionConfiguration.setCompounds(CompoundConfigurationService.filterCompounds(projectConfiguration.getCompounds(), sectionDto.getCompounds().stream().map(CompoundDto::getId).collect(Collectors.toList())));
            }
            if (sectionDto.getProcesses() != null) {
                sectionConfiguration.setProcesses(ProcessConfigurationService.filterProcesses(projectConfiguration.getProcesses(), sectionDto.getProcesses()));
            }
            this.projectConfigurationService.synchronizeConfiguration(projectConfiguration.getProjectId(), () -> {
                this.sectionConfigurationRepository.saveAll(sectionsToSync);
                return projectConfiguration;
            }, false);
            log.info("Successfully updated section '{}'", (Object)sectionConfiguration);
        }
        catch (Exception e) {
            log.error("Error while updating section '{}': {}", (Object)sectionDto.getName(), (Object)e.getMessage());
            throw new UpdateSectionException(e);
        }
        return this.sectionsDto(projectConfiguration.getRootSections());
    }

    private SectionConfiguration getSectionById(ProjectConfiguration projectConfiguration, UUID sectionId) {
        return projectConfiguration.getAllSections().stream().filter(s -> s.getId().equals(sectionId)).findFirst().orElseThrow(() -> {
            log.error("Section not found with ID '{}'", (Object)sectionId);
            return new SectionNotFoundException(sectionId);
        });
    }

    private List<SectionConfiguration> reorderSections(SectionConfiguration currentSection, int targetPlace) {
        log.trace("Reordering section '{}' to position {}", (Object)currentSection.getName(), (Object)targetPlace);
        List<SectionConfiguration> siblingOrChildList = currentSection.getParentSection() == null ? currentSection.getProjectConfiguration().getRootSections() : currentSection.getParentSection().getSections();
        ArrayList<SectionConfiguration> orderedSections = new ArrayList<SectionConfiguration>();
        siblingOrChildList.stream().filter(Objects::nonNull).filter(s -> s.getId() != currentSection.getId()).forEach(s -> orderedSections.add(Utils.correctPlaceInList(orderedSections, s.getPlace()), (SectionConfiguration)s));
        orderedSections.add(Utils.correctPlaceInList(orderedSections, targetPlace), currentSection);
        IntStream.range(0, orderedSections.size()).forEach(place -> ((SectionConfiguration)orderedSections.get(place)).setPlace(place));
        return orderedSections;
    }

    private List<SectionConfiguration> reorderSiblings(List<SectionConfiguration> sections) {
        log.trace("Reordering {} sibling sections", (Object)(sections != null ? sections.size() : 0));
        if (sections == null || sections.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SectionConfiguration> orderedSections = new ArrayList<SectionConfiguration>();
        sections.stream().filter(Objects::nonNull).forEach(orderedSections::add);
        IntStream.range(0, orderedSections.size()).forEach(place -> ((SectionConfiguration)orderedSections.get(place)).setPlace(place));
        return orderedSections;
    }

    @Override
    public SectionConfiguration get(UUID id) {
        return (SectionConfiguration)this.sectionConfigurationRepository.findById(id).orElseThrow(MiaHistoryRevisionRestoreException::new);
    }

    @Override
    public SectionConfiguration restore(DateAuditorEntity entity) {
        boolean parentChanged;
        log.info("Restoring section configuration '{}'", (Object)entity);
        SectionConfiguration sectionConfiguration = (SectionConfiguration)entity;
        Optional currentSectionOptional = this.sectionConfigurationRepository.findById(sectionConfiguration.getId());
        ProjectConfiguration projectConfiguration = sectionConfiguration.getProjectConfiguration();
        SectionConfiguration newParent = sectionConfiguration.getParentSection();
        SectionConfiguration oldParent = currentSectionOptional.map(SectionConfiguration::getParentSection).orElse(null);
        boolean bl = parentChanged = !Objects.equals(oldParent, newParent);
        if (parentChanged) {
            if (newParent != null) {
                newParent.getSections().add(sectionConfiguration);
            }
            if (oldParent != null) {
                oldParent.getSections().remove(sectionConfiguration);
            }
        }
        this.projectConfigurationService.synchronizeConfiguration(projectConfiguration.getProjectId(), () -> {
            this.sectionConfigurationRepository.save(sectionConfiguration);
            return projectConfiguration;
        }, false);
        log.info("Successfully restored section configuration '{}'", (Object)sectionConfiguration.getName());
        return sectionConfiguration;
    }

    private void addSectionAtCorrectPlace(List<SectionConfiguration> sections, SectionConfiguration section, int requestedPlace) {
        int correctPlace = Utils.correctPlaceInList(sections, requestedPlace);
        section.setPlace(correctPlace);
        sections.add(correctPlace, section);
    }

    public SectionConfigurationService(ModelMapper modelMapper, ProjectConfigurationService projectConfigurationService, SectionConfigurationRepository sectionConfigurationRepository) {
        this.modelMapper = modelMapper;
        this.projectConfigurationService = projectConfigurationService;
        this.sectionConfigurationRepository = sectionConfigurationRepository;
    }

    private /* synthetic */ ProjectConfiguration lambda$addSection$3(SectionConfiguration sectionConfiguration, List sectionsToSync, ProjectConfiguration projectConfiguration) {
        this.sectionConfigurationRepository.save(sectionConfiguration);
        this.sectionConfigurationRepository.saveAll(sectionsToSync);
        return projectConfiguration;
    }
}

