/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.execution;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import org.qubership.atp.integration.configuration.annotation.AtpJaegerLog;
import org.qubership.atp.mia.exceptions.rest.RestFormatNotCorrectException;
import org.qubership.atp.mia.exceptions.rest.RestHeadersIncorrectFormatException;
import org.qubership.atp.mia.exceptions.rest.RestIncorrectEndpointException;
import org.qubership.atp.mia.exceptions.rest.RestNotFoundException;
import org.qubership.atp.mia.exceptions.rest.UnsupportedRestMethodException;
import org.qubership.atp.mia.model.impl.CommandResponse;
import org.qubership.atp.mia.model.impl.executable.Command;
import org.qubership.atp.mia.repo.impl.RestRepository;
import org.qubership.atp.mia.service.MiaContext;
import org.qubership.atp.mia.service.file.MiaFileService;
import org.qubership.atp.mia.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RestExecutionHelperService {
    private static final Logger log = LoggerFactory.getLogger(RestExecutionHelperService.class);
    private final RestRepository restRepository;
    private final MiaContext miaContext;
    private final MiaFileService miaFileService;

    @AtpJaegerLog
    public CommandResponse sendRestRequest(Command command) {
        if (command.getRest() == null) {
            throw new RestNotFoundException();
        }
        if (!Strings.isNullOrEmpty((String)command.getRest().getRestFile())) {
            String restFileName = this.miaContext.evaluate(command.getRest().getRestFile());
            String[] restQuery = this.readRestFile(restFileName).split("\\r?\\n\\r?\\n");
            log.trace("Read restQuery size [{}]\n req: [{}]", (Object)restQuery.length, (Object)restQuery);
            if (restQuery.length < 3) {
                throw new RestFormatNotCorrectException();
            }
            if (Strings.isNullOrEmpty((String)restQuery[0])) {
                throw new UnsupportedRestMethodException("Null or Empty REST method in Rest File");
            }
            command.getRest().setMethod(this.miaContext.evaluate(restQuery[0]));
            if (Strings.isNullOrEmpty((String)restQuery[1])) {
                throw new RestIncorrectEndpointException("Null or Empty Endpoint in RestFile");
            }
            command.getRest().setEndpoint(this.miaContext.evaluate(restQuery[1]));
            if (Strings.isNullOrEmpty((String)restQuery[2])) {
                throw new RestHeadersIncorrectFormatException("Empty Header");
            }
            command.getRest().setHeaders(this.miaContext.evaluate(restQuery[2]));
            if (restQuery.length > 3) {
                ArrayList<String> body = new ArrayList<String>(Arrays.asList(restQuery).subList(3, restQuery.length));
                command.getRest().setBody(this.miaContext.evaluate(body.toString().substring(1, body.toString().length() - 1)));
            }
        } else if (!Strings.isNullOrEmpty((String)command.getRest().getBodyFile())) {
            String bodyFileName = this.miaContext.evaluate(command.getRest().getBodyFile());
            command.getRest().setBody(this.miaContext.evaluate(this.readRestFile(bodyFileName)));
        }
        return this.restRepository.sendRestRequest(command);
    }

    private String readRestFile(String fileName) {
        return FileUtils.readFile(this.miaFileService.getFile(fileName).toPath());
    }

    public RestExecutionHelperService(RestRepository restRepository, MiaContext miaContext, MiaFileService miaFileService) {
        this.restRepository = restRepository;
        this.miaContext = miaContext;
        this.miaFileService = miaFileService;
    }
}

