/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.execution;

import java.util.Optional;
import java.util.UUID;
import org.qubership.atp.mia.model.environment.Server;
import org.qubership.atp.mia.model.environment.System;
import org.qubership.atp.mia.repo.impl.pool.ssh.SshSessionPool;
import org.qubership.atp.mia.service.MiaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TimeShiftService {
    private static final Logger log = LoggerFactory.getLogger(TimeShiftService.class);
    private final MiaContext miaContext;
    private final SshSessionPool sshSessionPool;

    public boolean checkTimeShifting(String systemId) {
        if (SshSessionPool.systemsForTimeShifting.containsKey(systemId)) {
            log.debug("System [{}] is present in systemsForTimeShifting list.", (Object)systemId);
            if (SshSessionPool.systemsForTimeShifting.get(systemId).booleanValue()) {
                log.debug("Time shifting is ON for system [{}].", (Object)systemId);
                return true;
            }
            log.debug("Time shifting is OFF for system [{}].", (Object)systemId);
        } else {
            log.debug("No system [{}] in systemsForTimeShifting list.", (Object)systemId);
        }
        return false;
    }

    public void updateTimeShifting(UUID systemId, boolean value) {
        String logMsg = SshSessionPool.systemsForTimeShifting.containsKey(systemId) ? "is updated with value" : "is added to systemsForTimeShifting list with value";
        log.debug("System [{}] {} {}.", new Object[]{systemId, logMsg, value});
        SshSessionPool.systemsForTimeShifting.put(systemId, value);
        Optional<System> system = this.miaContext.getFlowData().getEnvironment().getSystems().stream().filter(sys -> sys.getId().equals(systemId)).findFirst();
        if (system.isPresent()) {
            Server server = this.miaContext.getFlowData().getSystem(system.get().getName()).getServer(Server.ConnectionType.SSH);
            if (value) {
                this.sshSessionPool.addTimeShiftSession(server, this.miaContext.getConfig().getCommonConfiguration());
            } else {
                this.sshSessionPool.removeTimeShiftSession(server);
            }
        }
    }

    public TimeShiftService(MiaContext miaContext, SshSessionPool sshSessionPool) {
        this.miaContext = miaContext;
        this.sshSessionPool = sshSessionPool;
    }
}

