/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.file;

import com.mongodb.MongoGridFSException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.UUID;
import javax.servlet.ServletContext;
import org.bson.types.ObjectId;
import org.qubership.atp.mia.exceptions.fileservice.FileEmptyException;
import org.qubership.atp.mia.exceptions.fileservice.FileTransferFailException;
import org.qubership.atp.mia.exceptions.fileservice.ReadFailFileNotFoundException;
import org.qubership.atp.mia.exceptions.fileservice.WrongFilePathException;
import org.qubership.atp.mia.model.file.FileMetaData;
import org.qubership.atp.mia.model.file.ProjectFile;
import org.qubership.atp.mia.model.file.ProjectFileType;
import org.qubership.atp.mia.service.MiaContext;
import org.qubership.atp.mia.service.configuration.ProjectConfigurationService;
import org.qubership.atp.mia.service.file.GridFsService;
import org.qubership.atp.mia.utils.dos2unix.Dos2UnixFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class MiaFileService {
    private static final Logger log = LoggerFactory.getLogger(MiaFileService.class);
    private final GridFsService gridFsService;
    private final MiaContext miaContext;
    private final ProjectConfigurationService projectConfigurationService;
    @Value(value="${dos2unix.path:/usr/bin/dos2unix}")
    String dos2UnixCustomPath;

    public ResponseEntity<Resource> downloadFile(UUID projectId, ProjectFileType projectFileType, UUID sessionId, String fileName, ServletContext servletContext) {
        File fullFile = this.getFile(this.projectConfigurationService.getProjectPathWithType(projectId, projectFileType, sessionId).resolve(fileName).toFile());
        try {
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment;filename=" + fileName})).header("Access-Control-Expose-Headers", new String[]{"Content-Disposition"})).contentType(this.getMediaTypeForFileName(servletContext, fileName)).body((Object)new InputStreamResource((InputStream)new FileInputStream(fullFile)));
        }
        catch (IOException e) {
            throw new ReadFailFileNotFoundException(fullFile.toString());
        }
    }

    public File getFile(File file) {
        boolean needRestoreFile;
        try {
            needRestoreFile = !file.exists() || LocalDateTime.ofInstant(Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]).creationTime().toInstant(), ZoneId.systemDefault()).isBefore(this.miaContext.getConfig().getLastLoadedWhen());
        }
        catch (IOException e) {
            needRestoreFile = true;
        }
        if (needRestoreFile) {
            this.gridFsService.restoreFile(file);
        }
        if (!file.exists()) {
            throw new ReadFailFileNotFoundException(file.toString());
        }
        return file;
    }

    public File getFile(String file) {
        if (file.contains("\\.\\.")) {
            throw new WrongFilePathException(file);
        }
        String ethalonFilesPath = this.miaContext.getConfig().getCommonConfiguration().getEthalonFilesPath();
        Path filePathToGet = file.contains(ethalonFilesPath) ? this.miaContext.getProjectPathWithType(ProjectFileType.MIA_FILE_TYPE_PROJECT, null).resolve("." + file.split(ethalonFilesPath)[1]) : (file.contains(ProjectFileType.MIA_FILE_TYPE_PROJECT.toString()) ? this.miaContext.getProjectPathWithType(ProjectFileType.MIA_FILE_TYPE_PROJECT, null).resolve("." + file.split(ProjectFileType.MIA_FILE_TYPE_PROJECT.toString())[1]) : (file.contains(ProjectFileType.MIA_FILE_TYPE_UPLOAD.toString()) ? this.miaContext.getProjectPathWithType(ProjectFileType.MIA_FILE_TYPE_UPLOAD, null).resolve("." + file.split(ProjectFileType.MIA_FILE_TYPE_UPLOAD.toString())[1]) : (file.contains(ProjectFileType.MIA_FILE_TYPE_LOG.toString()) ? this.miaContext.getProjectPathWithType(ProjectFileType.MIA_FILE_TYPE_LOG, null).resolve("." + file.split(ProjectFileType.MIA_FILE_TYPE_LOG.toString())[1]) : (file.contains(ProjectFileType.MIA_FILE_TYPE_CONFIGURATION.toString()) ? this.miaContext.getProjectPathWithType(ProjectFileType.MIA_FILE_TYPE_CONFIGURATION, null).resolve("." + file.split(ProjectFileType.MIA_FILE_TYPE_CONFIGURATION.toString())[1]) : this.miaContext.getProjectPathWithType(ProjectFileType.MIA_FILE_TYPE_PROJECT, null).resolve(file.startsWith("/") || file.startsWith("\\") ? "." + file : file)))));
        return this.getFile(filePathToGet.normalize().toFile());
    }

    public void removeProjectFile(ProjectFile projectFile) {
        try {
            this.gridFsService.deleteProjectFile(projectFile);
        }
        catch (MongoGridFSException e) {
            log.warn("File not found in gridFs {}", (Object)projectFile.getName(), (Object)e);
        }
        try {
            Files.deleteIfExists(this.miaContext.getProjectFilePath().resolve(projectFile.getPathFile()));
        }
        catch (IOException e) {
            log.warn("Can't remove file ", (Throwable)e);
        }
    }

    public void renameProjectFile(ProjectFile projectFile, String newFileName) {
        File filePath = this.miaContext.getProjectFilePath().resolve(projectFile.getPathFile()).toFile();
        if (filePath.exists()) {
            filePath.delete();
        }
        if (this.gridFsService.existFile(projectFile)) {
            projectFile.setName(newFileName);
            this.gridFsService.rename(projectFile);
        }
    }

    public ObjectId saveProjectFile(MultipartFile file, Path filePath) {
        if (file != null && !file.isEmpty()) {
            Path baseDir = this.miaContext.getProjectFilePath().toAbsolutePath().normalize();
            Path dest = baseDir.resolve(filePath).normalize();
            if (!dest.startsWith(baseDir)) {
                throw new SecurityException("Invalid path: Path traversal attempt detected: " + filePath);
            }
            try {
                if (!dest.toFile().getParentFile().exists() && !dest.toFile().getParentFile().mkdirs()) {
                    throw new IllegalStateException("Can't create path " + dest.toFile().getParentFile());
                }
                if (dest.toFile().exists() && !dest.toFile().delete()) {
                    throw new IllegalStateException("Can't delete old file " + dest);
                }
                file.transferTo(dest);
                return this.gridFsService.uploadFile(new FileMetaData(this.miaContext.getProjectId(), dest.toString(), ProjectFileType.MIA_FILE_TYPE_PROJECT), dest.toFile());
            }
            catch (IOException | IllegalStateException e) {
                throw new FileTransferFailException(dest.toString(), e);
            }
        }
        throw new FileEmptyException(file);
    }

    public ObjectId saveLogFile(FileMetaData fileMetaData, File logFile) {
        try {
            return this.gridFsService.uploadFile(fileMetaData, logFile);
        }
        catch (IllegalStateException e) {
            throw new FileTransferFailException(logFile, (Exception)e);
        }
    }

    public String uploadConfigurationFileOnBe(MultipartFile file) {
        return this.uploadFile(file, false, ProjectFileType.MIA_FILE_TYPE_CONFIGURATION);
    }

    public String uploadFileOnBe(MultipartFile file, boolean needDos2Unix) {
        return this.uploadFile(file, needDos2Unix, ProjectFileType.MIA_FILE_TYPE_UPLOAD);
    }

    private MediaType getMediaTypeForFileName(ServletContext servletContext, String fileName) {
        MediaType mediaType;
        String mineType = servletContext.getMimeType(fileName);
        try {
            mediaType = MediaType.parseMediaType((String)mineType);
            log.debug("Got mediaType for fileName: {}, mediaType: {}.", (Object)fileName, (Object)mediaType);
        }
        catch (Exception e) {
            mediaType = MediaType.APPLICATION_OCTET_STREAM;
        }
        return mediaType;
    }

    private void runDos2Unix(Path dest) {
        String osName = System.getProperty("os.name");
        log.info("Run Dos2Unix on '{}' for file '{}'", (Object)osName, (Object)dest.toString());
        Dos2UnixFactory.getDos2Unix(osName, this.dos2UnixCustomPath).ifPresent(o -> o.runDos2Unix(dest));
    }

    private String uploadFile(MultipartFile file, boolean needDos2Unix, ProjectFileType fileType) {
        if (file != null && !file.isEmpty()) {
            String string;
            block11: {
                Path fileName = Paths.get(file.getOriginalFilename(), new String[0]);
                File dest = this.miaContext.getProjectPathWithType(fileType).resolve(fileName.getFileName()).toFile();
                InputStream is = file.getInputStream();
                try {
                    dest.getParentFile().mkdirs();
                    if (dest.exists()) {
                        dest.delete();
                    }
                    Files.copy(is, dest.toPath(), new CopyOption[0]);
                    if (needDos2Unix) {
                        this.runDos2Unix(dest.toPath());
                    }
                    FileMetaData fileMetaData = new FileMetaData(this.miaContext.getProjectId(), dest.getPath(), fileType);
                    this.gridFsService.uploadFile(fileMetaData, dest);
                    string = fileMetaData.getFileName();
                    if (is == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new FileTransferFailException(dest.getPath(), (Exception)e);
                    }
                }
                is.close();
            }
            return string;
        }
        throw new FileEmptyException(file);
    }

    public MiaFileService(GridFsService gridFsService, MiaContext miaContext, ProjectConfigurationService projectConfigurationService) {
        this.gridFsService = gridFsService;
        this.miaContext = miaContext;
        this.projectConfigurationService = projectConfigurationService;
    }
}

