/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.git;

import clover.com.google.common.base.Strings;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.qubership.atp.mia.exceptions.fileservice.IoException;
import org.qubership.atp.mia.exceptions.git.GitException;
import org.qubership.atp.mia.exceptions.git.GitRepoBuildException;
import org.qubership.atp.mia.exceptions.git.GitResetException;
import org.qubership.atp.mia.exceptions.git.GitValidationProjectNotFoundException;
import org.qubership.atp.mia.exceptions.git.GitValidationUserNotFoundException;
import org.qubership.atp.mia.exceptions.git.RepoMailNotSetException;
import org.qubership.atp.mia.exceptions.git.RepoPassNotSetException;
import org.qubership.atp.mia.exceptions.git.RepoUserNotSetException;
import org.qubership.atp.mia.model.exception.ErrorCodes;
import org.qubership.atp.mia.model.exception.MiaException;
import org.qubership.atp.mia.model.impl.GitInfoError;
import org.qubership.atp.mia.model.impl.GitInfoResponse;
import org.qubership.atp.mia.service.execution.RestClientService;
import org.qubership.atp.mia.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class GitService {
    private static final Logger log = LoggerFactory.getLogger(GitService.class);
    private static final String GITFILE = ".git";
    @Value(value="${git.reposUserId:2202}")
    private String gitUserId;
    @Value(value="${git.reposUrl:https://git.somedomain.com/}")
    private String gitUrlPrefix;
    @Value(value="${git.reposApiPath:api/v4/projects/%s/members/%s}")
    private String gitUrlPath;
    @Value(value="${git.reposUser}")
    private String reposUser;
    @Value(value="${git.reposPass}")
    private String reposPass;
    @Value(value="${git.reposEmail}")
    private String reposEmail;
    @Value(value="${git.reposToken}")
    private String gitToken;
    @Value(value="${git.defaultAccessLevel:40}")
    private String defaultAccessLevel;
    private Pattern repositoryNamePattern;
    private Git git;

    public String checkXKubeUserRights(String pathToGit) {
        block5: {
            if (!Strings.isNullOrEmpty((String)pathToGit) && pathToGit.contains("http") && !Strings.isNullOrEmpty((String)this.gitToken)) {
                try {
                    Optional<GitInfoResponse> response = this.executeGetAndParseGitInfoResponse(pathToGit, this.gitToken);
                    if (response.isPresent()) {
                        int level;
                        int accessLevel = response.get().getAccessLevel();
                        if (accessLevel < (level = (int)Utils.parseLongValueOrDefault(this.defaultAccessLevel, 40L, "accessLevel"))) {
                            return ErrorCodes.MIA_0115_GIT_VALIDATION_USER_NO_RIGHTS.getMessage(pathToGit);
                        }
                        break block5;
                    }
                    return ErrorCodes.MIA_0116_GIT_VALIDATION_UNEXPECTED_ERROR.getMessage(pathToGit);
                }
                catch (MiaException e) {
                    return e.getMessage();
                }
            }
            log.debug("Can't check x_kube2vcs user rights, because url or private token is empty");
        }
        return "";
    }

    public void downloadGitRepo(String repoUrl, Path toPath) {
        File fileToPath = toPath.toFile();
        try (Repository repository = this.getGitRepo(toPath).getRepository();){
            String gitRepoUrl = repository.getConfig().getString("remote", "origin", "url");
            if (toPath.resolve(GITFILE).toFile().exists() && gitRepoUrl != null && gitRepoUrl.equals(repoUrl)) {
                this.gitPull(toPath);
            } else {
                if (fileToPath.exists()) {
                    FileUtils.deleteDirectory((File)fileToPath);
                }
                FileUtils.forceMkdir((File)fileToPath);
                this.gitClone(repoUrl, fileToPath);
            }
        }
        catch (IOException e) {
            throw new IoException(fileToPath, e);
        }
    }

    public Optional<GitInfoResponse> executeGetAndParseGitInfoResponse(String urlSrc, String privateToken) {
        HttpClientBuilder httpClient = HttpClientBuilder.create().setSSLContext(RestClientService.getSslContext()).disableRedirectHandling().setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        String url = this.getGitEncodedUrl(urlSrc.endsWith("/") ? urlSrc.substring(0, urlSrc.length() - 1) : urlSrc);
        HttpGet request = new HttpGet(url);
        request.setHeader("PRIVATE-TOKEN", privateToken);
        try {
            HttpEntity entity = httpClient.build().execute((HttpUriRequest)request).getEntity();
            String entityString = EntityUtils.toString((HttpEntity)entity);
            ObjectMapper mapper = new ObjectMapper().configure(JsonParser.Feature.IGNORE_UNDEFINED, true);
            try {
                GitInfoResponse result = (GitInfoResponse)mapper.readValue(entityString, GitInfoResponse.class);
                return Optional.of(result);
            }
            catch (IOException e) {
                try {
                    log.error("Can't parse response in executeGetAndParseGitInfoResponse. Url: {}, Entity: {}", new Object[]{url, entityString, e});
                    String gitMsg = ((GitInfoError)mapper.readValue(entityString, GitInfoError.class)).getMessage();
                    if ("404 Project Not Found".equals(gitMsg)) {
                        throw new GitValidationProjectNotFoundException();
                    }
                    if ("404 Not found".equals(gitMsg)) {
                        throw new GitValidationUserNotFoundException();
                    }
                }
                catch (IOException ioe) {
                    log.error("Can't transform entity to GitInfoError");
                }
            }
        }
        catch (IOException e) {
            log.error("Can't execute http request in executeGetAndParseGitInfoResponse. Url: {}", (Object)url, (Object)e);
        }
        return Optional.empty();
    }

    public String getGitEmail() {
        return Optional.ofNullable(this.reposEmail).orElseThrow(() -> new RepoMailNotSetException());
    }

    public String getGitEncodedUrl(String pathToGit) {
        Matcher m;
        String url = "";
        String urlTemplate = this.gitUrlPrefix + this.gitUrlPath;
        if (this.repositoryNamePattern == null) {
            this.repositoryNamePattern = Pattern.compile(this.gitUrlPrefix + "(.+/.+)$");
        }
        if ((m = this.repositoryNamePattern.matcher(pathToGit)).matches()) {
            String repoName = m.group(1);
            try {
                String repository = URLEncoder.encode(repoName, StandardCharsets.UTF_8.toString());
                url = String.format(urlTemplate, repository, this.gitUserId);
            }
            catch (UnsupportedEncodingException e) {
                log.error(ErrorCodes.MIA_0108_REPO_ENCODE_FAIL.getMessage(repoName, pathToGit));
            }
        }
        return url;
    }

    public String getGitPass() {
        return Optional.ofNullable(this.reposPass).orElseThrow(() -> new RepoPassNotSetException());
    }

    public String getGitUser() {
        return Optional.ofNullable(this.reposUser).orElseThrow(() -> new RepoUserNotSetException());
    }

    public void gitClone(String repoUrl, File toPath) {
        try {
            Git git = ((CloneCommand)Git.cloneRepository().setURI(repoUrl).setDirectory(toPath).setCredentialsProvider((CredentialsProvider)this.getGitCred())).call();
            git.getRepository().close();
            git.close();
            log.info("Repository {} has been cloned into {}", (Object)repoUrl, (Object)toPath);
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    public void gitCommitAndPush(Path pathToGit, String commitMessagePrefix) {
        try {
            this.git = this.getGitRepo(pathToGit);
            try {
                Ref head = (Ref)this.git.getRepository().getAllRefs().get("HEAD");
                log.info("HEAD after clone: {}: {} - {}", new Object[]{head, head.getName(), head.getObjectId().getName()});
            }
            catch (Exception head) {
                // empty catch block
            }
            this.git.add().addFilepattern(".").call();
            this.git.add().setUpdate(true).addFilepattern(".").call();
            CommitCommand commit = this.git.commit().setAuthor(this.getAuthor()).setMessage(commitMessagePrefix + "(from MIA toolbox)");
            commit.setCredentialsProvider((CredentialsProvider)this.getGitCred());
            commit.call();
            Iterable pushResults = ((PushCommand)this.git.push().setRemote("origin").setPushAll().setCredentialsProvider((CredentialsProvider)this.getGitCred())).call();
            pushResults.forEach(r -> {
                String message = "Repository " + pathToGit + " has been pushed [Message: " + r.getMessages() + "; URI: " + r.getURI() + "; Updates: " + r.getRemoteUpdates() + "]";
                if (!r.getRemoteUpdates().stream().allMatch(rU -> rU.getStatus() == RemoteRefUpdate.Status.OK)) {
                    throw new GitException(message);
                }
                log.info(message);
            });
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
        finally {
            this.git.close();
            this.git.getRepository().close();
            this.git = null;
        }
    }

    public void gitPull(Path pathToGit) {
        try {
            Git git = this.getGitRepo(pathToGit);
            git.reset().setMode(ResetCommand.ResetType.HARD).call();
            ((PullCommand)git.pull().setCredentialsProvider((CredentialsProvider)this.getGitCred())).call();
            git.getRepository().close();
            git.close();
            log.info("Repository {} has been pulled", (Object)pathToGit);
        }
        catch (CheckoutConflictException e) {
            throw new GitResetException(e);
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @PostConstruct
    public void init() {
    }

    private PersonIdent getAuthor() {
        String user = this.getGitUser();
        String mail = this.getGitEmail();
        return new PersonIdent(user, mail);
    }

    private UsernamePasswordCredentialsProvider getGitCred() {
        String user = this.getGitUser();
        String pass = this.getGitPass();
        return new UsernamePasswordCredentialsProvider(user, pass);
    }

    private Git getGitRepo(Path pathToGit) {
        try {
            return Git.wrap((Repository)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(pathToGit.resolve(GITFILE).toFile())).build());
        }
        catch (IOException e) {
            throw new GitRepoBuildException(e);
        }
    }
}

