/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.history.impl;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.EntityNotFoundException;
import org.apache.commons.lang3.StringUtils;
import org.javers.core.Changes;
import org.javers.core.ChangesByCommit;
import org.javers.core.Javers;
import org.javers.core.commit.CommitId;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.Change;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.diff.changetype.ValueChange;
import org.javers.core.diff.changetype.container.ContainerChange;
import org.javers.core.diff.changetype.container.ValueAdded;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.SnapshotType;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.jql.QueryBuilder;
import org.javers.shadow.Shadow;
import org.qubership.atp.mia.controllers.api.dto.AbstractCompareEntityDto;
import org.qubership.atp.mia.controllers.api.dto.CompareEntityResponseDto;
import org.qubership.atp.mia.controllers.api.dto.HistoryItemDto;
import org.qubership.atp.mia.controllers.api.dto.HistoryItemResponseDto;
import org.qubership.atp.mia.controllers.api.dto.PageInfoDto;
import org.qubership.atp.mia.model.DateAuditorEntity;
import org.qubership.atp.mia.model.history.ObjectOperation;
import org.qubership.atp.mia.model.history.Operation;
import org.qubership.atp.mia.service.history.RetrieveHistoryService;
import org.qubership.atp.mia.service.history.impl.AbstractVersioningMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

public abstract class AbstractRetrieveHistoryService<S extends DateAuditorEntity, D extends AbstractCompareEntityDto>
implements RetrieveHistoryService<S> {
    private static final Logger log = LoggerFactory.getLogger(AbstractRetrieveHistoryService.class);
    private final Javers javers;
    @Value(value="${history.records.limit:100}")
    private int maxHistoryRecords;
    protected final AbstractVersioningMapper<S, D> abstractVersioningMapper;

    public AbstractRetrieveHistoryService(Javers javers, AbstractVersioningMapper<S, D> abstractVersioningMapper) {
        this.abstractVersioningMapper = abstractVersioningMapper;
        this.javers = javers;
    }

    @Override
    public HistoryItemResponseDto getAllHistory(UUID id, Integer offset, Integer limit) {
        log.debug(String.format("Get All History for entity = %s, offset = %s, limit = %s", id, offset, limit));
        List snapshots = this.javers.findSnapshots(this.getSnapshotsByLimit(id, offset, limit));
        log.debug(String.format("Snapshots found for entity = %s, snapshots = %s", id, snapshots));
        JqlQuery query = this.getChangesByIdPaginationQuery(id, snapshots.stream().map(snapshot -> snapshot.getCommitId().valueAsNumber()).collect(Collectors.toList()));
        Changes changes = this.javers.findChanges(query);
        log.debug(String.format("Changes found for entity = %s,  changes = %s", id, changes.prettyPrint()));
        List changesByCommits = changes.groupByCommit();
        List<HistoryItemDto> historyItemDtoList = changesByCommits.stream().map(changesByCommit -> this.createHistoryItem((ChangesByCommit)changesByCommit, snapshots)).collect(Collectors.toList());
        HistoryItemResponseDto response = new HistoryItemResponseDto();
        response.setHistoryItems(historyItemDtoList);
        response.setPageInfo(this.getPageInfo(id, offset, limit));
        if (response.getPageInfo().getItemsTotalCount() > this.maxHistoryRecords) {
            response.getPageInfo().setItemsTotalCount(this.maxHistoryRecords);
        }
        return response;
    }

    @Override
    public List<CompareEntityResponseDto> getEntitiesByVersions(UUID id, List<String> versions) {
        return versions.stream().map(version -> this.getEntityByVersion((String)version, id)).collect(Collectors.toList());
    }

    protected JqlQuery getChangesByIdPaginationQuery(UUID id, Collection<BigDecimal> commitIds) {
        return QueryBuilder.byInstanceId((Object)id, this.getEntityClass()).withNewObjectChanges().withChildValueObjects().withCommitIds(commitIds).build();
    }

    protected JqlQuery getSnapshotsByLimit(UUID id, Integer offset, Integer limit) {
        return QueryBuilder.byInstanceId((Object)id, this.getEntityClass()).skip(offset.intValue()).limit(limit.intValue()).build();
    }

    protected JqlQuery getChangesByIdQuery(UUID id) {
        return QueryBuilder.byInstanceId((Object)id, this.getEntityClass()).limit(Integer.MAX_VALUE).withNewObjectChanges().build();
    }

    protected Integer getVersionByCommitId(List<CdoSnapshot> snapshots, CommitId id) {
        Integer version = null;
        Optional<CdoSnapshot> snapshot = snapshots.stream().filter(cdoSnapshot -> cdoSnapshot.getCommitId().equals((Object)id)).findFirst();
        if (snapshot.isPresent()) {
            version = Long.valueOf(snapshot.get().getVersion()).intValue();
        }
        return version;
    }

    protected void processChildChanges(Change propertyChange, HistoryItemDto historyItemDto) {
        ContainerChange containerChange = (ContainerChange)propertyChange;
        List valueAddedChanges = containerChange.getValueAddedChanges();
        List<ObjectOperation> objectOperations = valueAddedChanges.stream().map(ValueAdded::getAddedValue).filter(o -> o instanceof ObjectOperation).map(o -> (ObjectOperation)o).collect(Collectors.toList());
        historyItemDto.setAdded(this.getOperationNames(objectOperations, Operation.ADD));
        historyItemDto.setDeleted(this.getOperationNames(objectOperations, Operation.REMOVE));
    }

    protected void setCommonFields(S source, D destination, CommitMetadata commitMetadata, UUID uuid) {
        ((AbstractCompareEntityDto)destination).setModifiedWhen(Timestamp.valueOf(commitMetadata.getCommitDate()).getTime());
        ((AbstractCompareEntityDto)destination).setModifiedBy(commitMetadata.getAuthor());
        List snapshots = this.javers.findSnapshots(QueryBuilder.byInstanceId((Object)uuid, source.getClass()).withSnapshotType(SnapshotType.INITIAL).build());
        if (!CollectionUtils.isEmpty((Collection)snapshots)) {
            CommitMetadata initialCommitMetadata = ((CdoSnapshot)snapshots.get(0)).getCommitMetadata();
            ((AbstractCompareEntityDto)destination).setCreatedBy(initialCommitMetadata.getAuthor());
            ((AbstractCompareEntityDto)destination).setCreatedWhen(Timestamp.valueOf(initialCommitMetadata.getCommitDate()).getTime());
        }
    }

    private CompareEntityResponseDto buildCompareEntity(String revision, Shadow<S> entity, UUID uuid) {
        log.debug("version={}, entity={}", (Object)revision, entity);
        DateAuditorEntity source = (DateAuditorEntity)entity.get();
        AbstractCompareEntityDto resolvedEntity = (AbstractCompareEntityDto)this.abstractVersioningMapper.map(source);
        this.setCommonFields(source, resolvedEntity, entity.getCommitMetadata(), uuid);
        CompareEntityResponseDto compareEntityResponseDto = new CompareEntityResponseDto();
        compareEntityResponseDto.setRevision(revision);
        compareEntityResponseDto.setCompareEntity(resolvedEntity);
        return compareEntityResponseDto;
    }

    private List<String> calculateCommonChanges(List<Change> changes) {
        return changes.stream().map(change -> {
            if (!this.getEntityClass().getTypeName().equals(change.getAffectedGlobalId().getTypeName()) && change instanceof ValueChange) {
                String propertyNameWithPath = ((ValueChange)change).getPropertyNameWithPath();
                return propertyNameWithPath.split("/")[0].split("\\.")[0];
            }
            return ((PropertyChange)change).getPropertyName();
        }).distinct().collect(Collectors.toList());
    }

    private HistoryItemDto createHistoryItem(ChangesByCommit changesByCommit, List<CdoSnapshot> snapshots) {
        HistoryItemDto historyItemDto = new HistoryItemDto();
        CommitMetadata commit = changesByCommit.getCommit();
        historyItemDto.setVersion(this.getVersionByCommitId(snapshots, commit.getId()));
        historyItemDto.setType(this.getItemType());
        historyItemDto.setModifiedWhen(commit.getCommitDate().atOffset(ZoneOffset.UTC).toString());
        historyItemDto.setModifiedBy((String)StringUtils.defaultIfEmpty((CharSequence)commit.getAuthor(), (CharSequence)""));
        Map<Boolean, List<Change>> partitions = changesByCommit.get().stream().filter(change -> change instanceof PropertyChange).collect(Collectors.partitioningBy(change -> "childrenOperations".equals(((PropertyChange)change).getPropertyName())));
        historyItemDto.setChanged(this.calculateCommonChanges(partitions.get(false)));
        Optional childChanges = partitions.get(true).stream().findFirst();
        childChanges.ifPresent(change -> this.processChildChanges((Change)change, historyItemDto));
        return historyItemDto;
    }

    public Integer getCountOfCommits(UUID id) {
        Changes changes = this.javers.findChanges(this.getChangesByIdQuery(id));
        return changes.groupByCommit().size();
    }

    private CompareEntityResponseDto getEntityByVersion(String version, UUID uuid) {
        Optional<Shadow<S>> entity = this.getShadow(version, uuid);
        if (entity.isPresent()) {
            return this.buildCompareEntity(version, entity.get(), uuid);
        }
        log.error("Failed to found entity with id: {}", (Object)uuid);
        throw new EntityNotFoundException("Failed to found shadow with id: " + uuid);
    }

    private List<String> getOperationNames(List<ObjectOperation> objectOperations, Operation operation) {
        return objectOperations.stream().filter(obj -> operation.equals((Object)obj.getOperationType())).map(ObjectOperation::getName).collect(Collectors.toList());
    }

    private PageInfoDto getPageInfo(UUID id, Integer offset, Integer limit) {
        PageInfoDto pageInfo = new PageInfoDto();
        pageInfo.setOffset(offset);
        pageInfo.setLimit(limit);
        pageInfo.setItemsTotalCount(this.getCountOfCommits(id));
        return pageInfo;
    }

    private Optional<Shadow<S>> getShadow(String version, UUID uuid) {
        JqlQuery query = QueryBuilder.byInstanceId((Object)uuid, this.getEntityClass()).withVersion(Long.parseLong(version)).withScopeDeepPlus().build();
        List snapshots = this.javers.findSnapshots(query);
        QueryBuilder queryBuilder = QueryBuilder.byInstanceId((Object)uuid, this.getEntityClass()).withVersion(Long.parseLong(version)).withScopeDeepPlus(Integer.MAX_VALUE);
        if (Objects.nonNull(snapshots) && snapshots.size() > 0) {
            queryBuilder.withCommitId(((CdoSnapshot)snapshots.get(0)).getCommitId());
        }
        List shadows = this.javers.findShadows(queryBuilder.build());
        log.debug("Shadows found : {}", (Object)shadows);
        return shadows.stream().findFirst();
    }
}

