/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.history.impl;

import java.util.LinkedList;
import java.util.Optional;
import org.modelmapper.ModelMapper;
import org.qubership.atp.mia.model.configuration.CompoundConfiguration;
import org.qubership.atp.mia.model.configuration.ProcessConfiguration;
import org.qubership.atp.mia.service.history.impl.AbstractRestoreMapper;
import org.springframework.stereotype.Component;

@Component
public class CompoundRestoreMapper
extends AbstractRestoreMapper<CompoundConfiguration> {
    CompoundRestoreMapper(ModelMapper mapper) {
        super(CompoundConfiguration.class, CompoundConfiguration.class, mapper);
    }

    @Override
    public void mapSpecificFields(CompoundConfiguration source, CompoundConfiguration destination) {
        destination.setName(source.getName());
        destination.setReferToInput(source.getReferToInput());
        LinkedList<ProcessConfiguration> restoredProcesses = new LinkedList<ProcessConfiguration>(source.getProcesses());
        LinkedList<ProcessConfiguration> converted = new LinkedList<ProcessConfiguration>();
        restoredProcesses.forEach(pr -> {
            Optional<ProcessConfiguration> any = destination.getProjectConfiguration().getProcesses().stream().filter(process -> process.getId().equals(pr.getId())).findAny();
            if (any.isPresent()) {
                ProcessConfiguration processConfiguration = any.get();
                this.mapper.map(pr, (Object)processConfiguration);
                converted.add(processConfiguration);
            } else {
                converted.add((ProcessConfiguration)pr);
            }
        });
        destination.setProcesses(converted);
    }
}

