/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.history.impl;

import java.util.List;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.qubership.atp.mia.controllers.api.dto.CompoundHistoryChangeDto;
import org.qubership.atp.mia.controllers.api.dto.HistoryItemTypeDto;
import org.qubership.atp.mia.model.configuration.CompoundConfiguration;
import org.qubership.atp.mia.model.configuration.ProcessConfiguration;
import org.qubership.atp.mia.model.configuration.SectionConfiguration;
import org.qubership.atp.mia.service.history.impl.AbstractVersioningMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompoundVersioningMapper
extends AbstractVersioningMapper<CompoundConfiguration, CompoundHistoryChangeDto> {
    @Autowired
    public CompoundVersioningMapper(ModelMapper mapper) {
        super(CompoundConfiguration.class, CompoundHistoryChangeDto.class, mapper);
    }

    @Override
    protected HistoryItemTypeDto getEntityTypeEnum() {
        return HistoryItemTypeDto.COMPOUND;
    }

    @Override
    public void mapSpecificFields(CompoundConfiguration source, CompoundHistoryChangeDto destination) {
        super.mapSpecificFields(source, destination);
        destination.id(source.getId());
        destination.setName(source.getName());
        destination.setReferToInput(source.getReferToInput());
        if (source.getInSections() != null) {
            List<String> inSectionsNames = source.getInSections().stream().map(SectionConfiguration::getName).collect(Collectors.toList());
            destination.setInSections(inSectionsNames);
        }
        if (source.getProcesses() != null) {
            List<String> processesNames = source.getProcesses().stream().map(ProcessConfiguration::getName).collect(Collectors.toList());
            destination.setProcesses(processesNames);
        }
    }
}

