/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.history.impl;

import org.modelmapper.ModelMapper;
import org.qubership.atp.mia.controllers.api.dto.DirectoryHistoryChangeDto;
import org.qubership.atp.mia.controllers.api.dto.HistoryItemTypeDto;
import org.qubership.atp.mia.model.file.ProjectDirectory;
import org.qubership.atp.mia.service.history.impl.AbstractVersioningMapper;
import org.springframework.stereotype.Component;

@Component
public class DirectoryVersioningMapper
extends AbstractVersioningMapper<ProjectDirectory, DirectoryHistoryChangeDto> {
    public DirectoryVersioningMapper(ModelMapper mapper) {
        super(ProjectDirectory.class, DirectoryHistoryChangeDto.class, mapper);
    }

    @Override
    HistoryItemTypeDto getEntityTypeEnum() {
        return HistoryItemTypeDto.DIRECTORY;
    }

    @Override
    public void mapSpecificFields(ProjectDirectory source, DirectoryHistoryChangeDto destination) {
        if (source.getParentDirectory() != null) {
            destination.setParentDirectory(source.getParentDirectory().getName());
        }
        destination.setChildDirectories(source.getChildrenNames());
        destination.setFiles(source.getFilesNames());
    }
}

