/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.history.impl;

import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.qubership.atp.mia.controllers.api.dto.HistoryItemTypeDto;
import org.qubership.atp.mia.controllers.api.dto.SectionHistoryChangeDto;
import org.qubership.atp.mia.model.configuration.CompoundConfiguration;
import org.qubership.atp.mia.model.configuration.ProcessConfiguration;
import org.qubership.atp.mia.model.configuration.SectionConfiguration;
import org.qubership.atp.mia.service.history.impl.AbstractVersioningMapper;
import org.springframework.stereotype.Component;

@Component
public class SectionVersioningMapper
extends AbstractVersioningMapper<SectionConfiguration, SectionHistoryChangeDto> {
    public SectionVersioningMapper(ModelMapper mapper) {
        super(SectionConfiguration.class, SectionHistoryChangeDto.class, mapper);
    }

    @Override
    HistoryItemTypeDto getEntityTypeEnum() {
        return HistoryItemTypeDto.SECTION;
    }

    @Override
    public void mapSpecificFields(SectionConfiguration source, SectionHistoryChangeDto destination) {
        destination.childSections(source.getSections().stream().map(SectionConfiguration::getName).collect(Collectors.toList()));
        destination.processes(source.getProcesses().stream().map(ProcessConfiguration::getName).collect(Collectors.toList()));
        destination.compounds(source.getCompounds().stream().map(CompoundConfiguration::getName).collect(Collectors.toList()));
        if (source.getParentSection() != null) {
            destination.parentSection(source.getParentSection().getName());
        }
    }
}

