/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.utils;

import java.util.Optional;
import javax.annotation.PostConstruct;
import org.qubership.atp.mia.exceptions.macrosandevaluations.IncorrectEnvironmentVariableFormatException;
import org.qubership.atp.mia.model.environment.Connection;
import org.qubership.atp.mia.model.environment.System;
import org.qubership.atp.mia.repo.ContextRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class EnvironmentVariableUtils {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentVariableUtils.class);
    private static ContextRepository contextRepositoryStatic;
    private final ContextRepository contextRepository;

    public static String evaluateEnvironmentVariable(String text) {
        Optional<Connection> connection;
        String[] textArray = (text = text.substring(2, text.length() - 1)).split("\\.");
        if (textArray.length != 4) {
            throw new IncorrectEnvironmentVariableFormatException("${" + text + "}");
        }
        Optional<System> system = contextRepositoryStatic.getContext().getEnvironment().getSystems().stream().filter(sys -> sys.getName().equalsIgnoreCase(textArray[1])).findFirst();
        if (system.isPresent() && (connection = system.get().getConnections().stream().filter(c -> c.getName().equalsIgnoreCase(textArray[2])).findFirst()).isPresent()) {
            return connection.get().getParameters().get(textArray[3]);
        }
        return null;
    }

    @PostConstruct
    public void init() {
        contextRepositoryStatic = this.contextRepository;
    }

    public EnvironmentVariableUtils(ContextRepository contextRepository) {
        this.contextRepository = contextRepository;
    }
}

