/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.multitenancy.interceptor.http;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.qubership.atp.auth.springbootstarter.entities.Operation;
import org.qubership.atp.auth.springbootstarter.security.permissions.PolicyEnforcement;
import org.qubership.atp.multitenancy.core.context.TenantContext;
import org.springframework.lang.Nullable;
import org.springframework.security.web.util.TextEscapeUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class MultiTenantHttpRequestInterceptor
implements HandlerInterceptor {
    private final PolicyEnforcement policyEnforcement;

    public MultiTenantHttpRequestInterceptor(PolicyEnforcement policyEnforcement) {
        this.policyEnforcement = policyEnforcement;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        String tenantId = request.getHeader("X-Project-Id");
        if (tenantId == null) {
            TenantContext.setDefaultTenantInfo();
            return true;
        }
        boolean permitted = this.policyEnforcement.checkAccess(tenantId, Operation.READ.toString());
        if (!permitted) {
            response.getWriter().write(String.format("Access denied to %s", TextEscapeUtils.escapeEntities((String)tenantId)));
            response.setStatus(403);
            return false;
        }
        TenantContext.setTenantInfo((String)tenantId);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable ModelAndView modelAndView) {
        TenantContext.clear();
    }
}

