/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.multitenancy.interceptor.jms;

import java.util.Objects;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import org.qubership.atp.multitenancy.core.context.TenantContext;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.lang.NonNull;

public class MultiTenantJmsRequestInterceptor {
    public DefaultJmsListenerContainerFactory initDefaultJmsListenerContainerFactory() {
        return new DefaultJmsListenerContainerFactory(){

            @NonNull
            protected DefaultMessageListenerContainer createContainerInstance() {
                return new DefaultMessageListenerContainer(){

                    protected Message receiveMessage(@NonNull MessageConsumer consumer) throws JMSException {
                        Message message = super.receiveMessage(Objects.requireNonNull(consumer, "Can't receive message - consumer is null"));
                        if (message != null) {
                            String tenantId = message.getStringProperty("X-Project-Id");
                            if (tenantId != null && !tenantId.isEmpty()) {
                                TenantContext.setTenantInfo((String)tenantId);
                            } else {
                                TenantContext.setDefaultTenantInfo();
                            }
                        }
                        return message;
                    }
                };
            }
        };
    }
}

