/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.multitenancy.interceptor.jms;

import java.util.Map;
import java.util.Objects;
import javax.jms.JMSException;
import javax.jms.Message;
import org.qubership.atp.multitenancy.interceptor.jms.AtpJmsTemplate;
import org.springframework.jms.JmsException;
import org.springframework.jms.core.JmsTemplate;

public class MultiTenantJmsTemplate
extends JmsTemplate
implements AtpJmsTemplate {
    @Override
    public void convertAndSend(String destination, Object message, Map<String, Object> properties) throws JmsException {
        super.send(destination, session -> {
            Message toMessage = Objects.requireNonNull(super.getMessageConverter(), "MessageConverter wasn't configured for " + destination + "destination").toMessage(message, session);
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                this.setProperties(properties, toMessage, entry);
            }
            return toMessage;
        });
    }

    private void setProperties(Map<String, Object> properties, Message toMessage, Map.Entry<String, Object> property) throws JMSException {
        if (!"X-Project-Id".equals(property.getKey())) {
            toMessage.setStringProperty(property.getKey(), String.valueOf(property.getValue()));
            return;
        }
        toMessage.setStringProperty("X-Project-Id", String.valueOf(properties.getOrDefault(property.getKey(), "default")));
    }
}

