/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.2.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.dataset.clients.api;

import org.qubership.atp.dataset.clients.dto.AffectedDataSetListDto;
import java.math.BigDecimal;
import org.qubership.atp.dataset.clients.dto.CopyDataSetListsRequestDto;
import org.qubership.atp.dataset.clients.dto.CopyDataSetListsResponseDto;
import org.qubership.atp.dataset.clients.dto.CyclesCheckResultDto;
import org.qubership.atp.dataset.clients.dto.DataSetDto;
import org.qubership.atp.dataset.clients.dto.DataSetListCreatedModifiedViewDto;
import org.qubership.atp.dataset.clients.dto.DataSetListDependencyNodeDto;
import org.qubership.atp.dataset.clients.dto.DataSetsAndAttributesFilterPairDto;
import org.qubership.atp.dataset.clients.dto.DatasetListImportResponseDto;
import org.qubership.atp.dataset.clients.dto.DatasetResponseDto;
import org.qubership.atp.dataset.clients.dto.LabelDto;
import java.util.List;
import java.util.Map;
import java.time.OffsetDateTime;
import org.qubership.atp.dataset.clients.dto.PairDto;
import java.util.Set;
import org.qubership.atp.dataset.clients.dto.TableResponseDto;
import java.util.UUID;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-11T14:57:02.564217382Z[Etc/UTC]")
@Validated
@Tag(name = "DataSetListController", description = "Data Set List Controller")
public interface DataSetListControllerApi {

    /**
     * PUT /dsl/{dataSetListId}/label : addLabel
     *
     * @param dataSetListId dataSetListId (required)
     * @param name name (required)
     * @param modifiedWhen modifiedWhen (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "addLabel",
        summary = "addLabel",
        tags = { "data-set-list-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = LabelDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/dsl/{dataSetListId}/label",
        produces = { "application/json" }
    )
    ResponseEntity<LabelDto> addLabel(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId,
        @NotNull @Parameter(name = "name", description = "name", required = true) @Valid @RequestParam(value = "name", required = true) String name,
        @Parameter(name = "modifiedWhen", description = "modifiedWhen") @Valid @RequestParam(value = "modifiedWhen", required = false) Long modifiedWhen
    );


    /**
     * POST /dsl/copy : Copy DSL with name provided.
     *
     * @param copyDataSetListsRequestDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "copy",
        summary = "Copy DSL with name provided.",
        tags = { "data-set-list-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = CopyDataSetListsResponseDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/dsl/copy",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<CopyDataSetListsResponseDto>> copy(
        @Parameter(name = "CopyDataSetListsRequestDto", description = "") @Valid @RequestBody(required = false) CopyDataSetListsRequestDto copyDataSetListsRequestDto
    );


    /**
     * POST /dsl/ds/clone/bulk : Copy DSLs and DSs. Uses for cloning of test plan on Catalog
     *
     * @param name name (required)
     * @param requestBody  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "copyBulk",
        summary = "Copy DSLs and DSs. Uses for cloning of test plan on Catalog",
        tags = { "data-set-list-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = PairDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/dsl/ds/clone/bulk",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<Map<String, PairDto>> copyBulk(
        @NotNull @Parameter(name = "name", description = "name", required = true) @Valid @RequestParam(value = "name", required = true) String name,
        @Parameter(name = "request_body", description = "") @Valid @RequestBody(required = false) Map<String, Set<UUID>> requestBody
    );


    /**
     * PUT /dsl/va/{vaId}/dsl/{dataSetListId}/copy : Copy DSL with name provided.
     *
     * @param dataSetListId dataSetListId (required)
     * @param vaId vaId (required)
     * @param name name (required)
     * @param type type (optional)
     * @param testPlan testPlan (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "copyByVaIdDataSetListId",
        summary = "Copy DSL with name provided.",
        tags = { "data-set-list-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UUID.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/dsl/va/{vaId}/dsl/{dataSetListId}/copy",
        produces = { "application/json" }
    )
    ResponseEntity<UUID> copyByVaIdDataSetListId(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId,
        @Parameter(name = "vaId", description = "vaId", required = true) @PathVariable("vaId") UUID vaId,
        @NotNull @Parameter(name = "name", description = "name", required = true) @Valid @RequestParam(value = "name", required = true) String name,
        @Parameter(name = "type", description = "type") @Valid @RequestParam(value = "type", required = false) Boolean type,
        @Parameter(name = "testPlan", description = "testPlan") @Valid @RequestParam(value = "testPlan", required = false) UUID testPlan
    );


    /**
     * PUT /dsl/va/{vaId} : Creates new DSL with name provided.
     *
     * @param vaId vaId (required)
     * @param name name (required)
     * @param testPlan testPlan (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "create",
        summary = "Creates new DSL with name provided.",
        tags = { "data-set-list-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UUID.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/dsl/va/{vaId}",
        produces = { "application/json" }
    )
    ResponseEntity<UUID> create(
        @Parameter(name = "vaId", description = "vaId", required = true) @PathVariable("vaId") UUID vaId,
        @NotNull @Parameter(name = "name", description = "name", required = true) @Valid @RequestParam(value = "name", required = true) String name,
        @Parameter(name = "testPlan", description = "testPlan") @Valid @RequestParam(value = "testPlan", required = false) UUID testPlan
    );


    /**
     * DELETE /dsl/{dataSetListId} : Deletes selected DSL.
     *
     * @param dataSetListId dataSetListId (required)
     * @return No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     */
    @Operation(
        operationId = "delete",
        summary = "Deletes selected DSL.",
        tags = { "data-set-list-controller" },
        responses = {
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/dsl/{dataSetListId}"
    )
    ResponseEntity<Void> delete(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId
    );


    /**
     * DELETE /dsl/{dataSetListId}/label/{labelId} : deleteLabel
     *
     * @param dataSetListId dataSetListId (required)
     * @param labelId labelId (required)
     * @param modifiedWhen modifiedWhen (optional)
     * @return OK (status code 200)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     */
    @Operation(
        operationId = "deleteLabel",
        summary = "deleteLabel",
        tags = { "data-set-list-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Boolean.class))
            }),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/dsl/{dataSetListId}/label/{labelId}",
        produces = { "application/json" }
    )
    ResponseEntity<Boolean> deleteLabel(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId,
        @Parameter(name = "labelId", description = "labelId", required = true) @PathVariable("labelId") UUID labelId,
        @Parameter(name = "modifiedWhen", description = "modifiedWhen") @Valid @RequestParam(value = "modifiedWhen", required = false) Long modifiedWhen
    );


    /**
     * GET /dsl/{dataSetListId}/exists : Check if dsl exists.
     *
     * @param dataSetListId dataSetListId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "existsById",
        summary = "Check if dsl exists.",
        tags = { "data-set-list-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/dsl/{dataSetListId}/exists"
    )
    ResponseEntity<Void> existsById(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId
    );


    /**
     * POST /dsl/{dataSetListId}/export/excel : Export dsl to file.
     *
     * @param dataSetListId dataSetListId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "exportDataSetList",
        summary = "Export dsl to file.",
        tags = { "data-set-list-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", schema = @Schema(implementation = org.springframework.core.io.Resource.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/dsl/{dataSetListId}/export/excel",
        produces = { "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet" }
    )
    ResponseEntity<org.springframework.core.io.Resource> exportDataSetList(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId
    );


    /**
     * GET /dsl/{dataSetListId}/getAffected : Get affected attribute by deleting dsl( data set storage).
     *
     * @param dataSetListId dataSetListId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAffectedAttributes",
        summary = "Get affected attribute by deleting dsl( data set storage).",
        tags = { "data-set-list-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TableResponseDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/dsl/{dataSetListId}/getAffected",
        produces = { "application/json" }
    )
    ResponseEntity<List<TableResponseDto>> getAffectedAttributes(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId
    );


    /**
     * GET /dsl/{dataSetListId}/getAffectedCount : Get affected attribute count by dsl.
     *
     * @param dataSetListId dataSetListId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAffectedAttributesCount",
        summary = "Get affected attribute count by dsl.",
        tags = { "data-set-list-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = BigDecimal.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/dsl/{dataSetListId}/getAffectedCount",
        produces = { "application/json" }
    )
    ResponseEntity<BigDecimal> getAffectedAttributesCount(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId
    );


    /**
     * GET /dsl/{dataSetListId}/getAffectedDSL : Get affected dsl by deleting dsl( data set storage).
     *
     * @param dataSetListId dataSetListId (required)
     * @param limit limit (optional)
     * @param offset offset (optional)
     * @return OK (status code 200)
     *         or Partial Content (status code 206)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAffectedDataSetLists",
        summary = "Get affected dsl by deleting dsl( data set storage).",
        tags = { "data-set-list-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "206", description = "Partial Content", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = AffectedDataSetListDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/dsl/{dataSetListId}/getAffectedDSL",
        produces = { "application/json" }
    )
    ResponseEntity<Void> getAffectedDataSetLists(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId,
        @Parameter(name = "limit", description = "limit") @Valid @RequestParam(value = "limit", required = false) Integer limit,
        @Parameter(name = "offset", description = "offset") @Valid @RequestParam(value = "offset", required = false) Integer offset
    );


    /**
     * GET /dsl/cyclesCheck : Get affected attribute by deleting dsl( data set storage).
     *
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getCyclesCheck",
        summary = "Get affected attribute by deleting dsl( data set storage).",
        tags = { "data-set-list-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = CyclesCheckResultDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/dsl/cyclesCheck",
        produces = { "application/json" }
    )
    ResponseEntity<CyclesCheckResultDto> getCyclesCheck(
        
    );


    /**
     * GET /dsl/{dataSetListId}/ds/{ds} : Returns information about the selected DS under DSL.
     *
     * @param dataSetListId dataSetListId (required)
     * @param ds ds (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDataSetInfoByDataSetListIdAndId",
        summary = "Returns information about the selected DS under DSL.",
        tags = { "data-set-list-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/dsl/{dataSetListId}/ds/{ds}",
        produces = { "application/json" }
    )
    ResponseEntity<Object> getDataSetInfoByDataSetListIdAndId(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId,
        @Parameter(name = "ds", description = "ds", required = true) @PathVariable("ds") UUID ds
    );


    /**
     * GET /dsl/{dataSetListId}/full : Returns datasets full information of the selected DSL.
     *
     * @param dataSetListId dataSetListId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDataSetListFullInfo",
        summary = "Returns datasets full information of the selected DSL.",
        tags = { "data-set-list-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = DataSetDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/dsl/{dataSetListId}/full",
        produces = { "application/json" }
    )
    ResponseEntity<List<DataSetDto>> getDataSetListFullInfo(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId
    );


    /**
     * GET /dsl/{dataSetListId} : Returns information about the selected DSL.
     *
     * @param dataSetListId dataSetListId (required)
     * @param filterDs filterDs (optional)
     * @param filterAttr filterAttr (optional)
     * @param flat flat (optional)
     * @param _new new (optional)
     * @param evaluate evaluate (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDataSetListInfo",
        summary = "Returns information about the selected DSL.",
        tags = { "data-set-list-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/dsl/{dataSetListId}",
        produces = { "application/json" }
    )
    ResponseEntity<Object> getDataSetListInfo(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId,
        @Parameter(name = "filterDs", description = "filterDs") @Valid @RequestParam(value = "filterDs", required = false) String filterDs,
        @Parameter(name = "filterAttr", description = "filterAttr") @Valid @RequestParam(value = "filterAttr", required = false) String filterAttr,
        @Parameter(name = "flat", description = "flat") @Valid @RequestParam(value = "flat", required = false) String flat,
        @Parameter(name = "new", description = "new") @Valid @RequestParam(value = "new", required = false) String _new,
        @Parameter(name = "evaluate", description = "evaluate") @Valid @RequestParam(value = "evaluate", required = false) String evaluate
    );


    /**
     * POST /dsl/{dataSetListId}/filters : Returns information about the selected DSL.
     *
     * @param dataSetListId dataSetListId (required)
     * @param evaluate evaluate (optional)
     * @param startIndex startIndex (optional)
     * @param endIndex endIndex (optional)
     * @param sort sort (optional)
     * @param dataSetsAndAttributesFilterPairDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDataSetListInfoById",
        summary = "Returns information about the selected DSL.",
        tags = { "data-set-list-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/dsl/{dataSetListId}/filters",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<Object> getDataSetListInfoById(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId,
        @Parameter(name = "evaluate", description = "evaluate") @Valid @RequestParam(value = "evaluate", required = false) String evaluate,
        @Parameter(name = "startIndex", description = "startIndex") @Valid @RequestParam(value = "startIndex", required = false) Integer startIndex,
        @Parameter(name = "endIndex", description = "endIndex") @Valid @RequestParam(value = "endIndex", required = false) Integer endIndex,
        @Parameter(name = "sort", description = "sort") @Valid @RequestParam(value = "sort", required = false) String sort,
        @Parameter(name = "DataSetsAndAttributesFilterPairDto", description = "") @Valid @RequestBody(required = false) DataSetsAndAttributesFilterPairDto dataSetsAndAttributesFilterPairDto
    );


    /**
     * GET /dsl : Returns all dataSetLists.
     *
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDataSetLists",
        summary = "Returns all dataSetLists.",
        tags = { "data-set-list-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = DataSetListCreatedModifiedViewDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/dsl",
        produces = { "application/json" }
    )
    ResponseEntity<List<DataSetListCreatedModifiedViewDto>> getDataSetLists(
        
    );


    /**
     * GET /dsl/va/{vaId} : Returns all dataSetLists for selected visibility area.
     *
     * @param vaId vaId (required)
     * @param label label (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDataSetListsByVaId",
        summary = "Returns all dataSetLists for selected visibility area.",
        tags = { "data-set-list-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = DataSetListCreatedModifiedViewDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/dsl/va/{vaId}",
        produces = { "application/json" }
    )
    ResponseEntity<List<DataSetListCreatedModifiedViewDto>> getDataSetListsByVaId(
        @Parameter(name = "vaId", description = "vaId", required = true) @PathVariable("vaId") UUID vaId,
        @Parameter(name = "label", description = "label") @Valid @RequestParam(value = "label", required = false) String label
    );


    /**
     * GET /dsl/{dataSetListId}/ds : Returns datasets id/name information of the selected DSL.
     *
     * @param dataSetListId dataSetListId (required)
     * @param skipEvaluate skipEvaluate (optional)
     * @param label label (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDataSets",
        summary = "Returns datasets id/name information of the selected DSL.",
        tags = { "data-set-list-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = DataSetDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/dsl/{dataSetListId}/ds",
        produces = { "application/json" }
    )
    ResponseEntity<List<DataSetDto>> getDataSets(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId,
        @Parameter(name = "skipEvaluate", description = "skipEvaluate") @Valid @RequestParam(value = "skipEvaluate", required = false) String skipEvaluate,
        @Parameter(name = "label", description = "label") @Valid @RequestParam(value = "label", required = false) String label
    );


    /**
     * POST /dsl/ds/all : getDataSetsWithNameAndDataSetList
     *
     * @param UUID  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDataSetsWithNameAndDataSetList",
        summary = "getDataSetsWithNameAndDataSetList",
        tags = { "data-set-list-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = DatasetResponseDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/dsl/ds/all",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<DatasetResponseDto>> getDataSetsWithNameAndDataSetList(
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) List<UUID> UUID
    );


    /**
     * POST /dsl/dependencies : Get dataset lists dependencies trees
     *
     * @param UUID  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDependencies",
        summary = "Get dataset lists dependencies trees",
        tags = { "data-set-list-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = DataSetListDependencyNodeDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/dsl/dependencies",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<DataSetListDependencyNodeDto>> getDependencies(
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) List<UUID> UUID
    );


    /**
     * POST /dsl/dependenciesRecursive : Get dataset lists dependencies trees
     *
     * @param UUID  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDependenciesRecursive",
        summary = "Get dataset lists dependencies trees",
        tags = { "data-set-list-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = DataSetListDependencyNodeDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/dsl/dependenciesRecursive",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<DataSetListDependencyNodeDto>> getDependenciesRecursive(
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) List<UUID> UUID
    );


    /**
     * GET /dsl/{dataSetListId}/label : getLabels
     *
     * @param dataSetListId dataSetListId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getLabels",
        summary = "getLabels",
        tags = { "data-set-list-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = LabelDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/dsl/{dataSetListId}/label",
        produces = { "application/json" }
    )
    ResponseEntity<List<LabelDto>> getLabels(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId
    );


    /**
     * GET /dsl/{dataSetListId}/modifiedWhen : Get dsl modifiedWhen.
     *
     * @param dataSetListId dataSetListId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getModifiedWhen",
        summary = "Get dsl modifiedWhen.",
        tags = { "data-set-list-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = OffsetDateTime.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/dsl/{dataSetListId}/modifiedWhen",
        produces = { "application/json" }
    )
    ResponseEntity<OffsetDateTime> getModifiedWhen(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId
    );


    /**
     * POST /dsl/{dataSetListId}/import/excel : Import dsl from excel file.
     *
     * @param dataSetListId dataSetListId (required)
     * @param projectId projectId (required)
     * @param versioning versioning (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "importDataSetList",
        summary = "Import dsl from excel file.",
        tags = { "data-set-list-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = DatasetListImportResponseDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/dsl/{dataSetListId}/import/excel",
        produces = { "application/json" }
    )
    ResponseEntity<DatasetListImportResponseDto> importDataSetList(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId,
        @NotNull @Parameter(name = "projectId", description = "projectId", required = true) @Valid @RequestParam(value = "projectId", required = true) UUID projectId,
        @Parameter(name = "versioning", description = "versioning") @Valid @RequestParam(value = "versioning", required = false) Boolean versioning
    );


    /**
     * POST /dsl/{dataSetListId} : Renames selected DSL.
     *
     * @param dataSetListId dataSetListId (required)
     * @param name name (optional)
     * @param testPlan testPlan (optional)
     * @param clearTestPlan clearTestPlan (optional)
     * @param modifiedWhen modifiedWhen (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "rename",
        summary = "Renames selected DSL.",
        tags = { "data-set-list-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Boolean.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/dsl/{dataSetListId}",
        produces = { "application/json" }
    )
    ResponseEntity<Boolean> rename(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId,
        @Parameter(name = "name", description = "name") @Valid @RequestParam(value = "name", required = false) String name,
        @Parameter(name = "testPlan", description = "testPlan") @Valid @RequestParam(value = "testPlan", required = false) UUID testPlan,
        @Parameter(name = "clearTestPlan", description = "clearTestPlan") @Valid @RequestParam(value = "clearTestPlan", required = false) String clearTestPlan,
        @Parameter(name = "modifiedWhen", description = "modifiedWhen") @Valid @RequestParam(value = "modifiedWhen", required = false) Long modifiedWhen
    );

}
