package org.qubership.atp.dataset.clients.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.dataset.clients.dto.LabelCreatedModifiedViewDto;
import org.qubership.atp.dataset.clients.dto.TestPlanCreatedModifiedViewDto;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * DataSetListCreatedModifiedViewDto
 */

@JsonTypeName("DataSetListCreatedModifiedView")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-11T14:57:02.564217382Z[Etc/UTC]")
public class DataSetListCreatedModifiedViewDto {

  @JsonProperty("createdBy")
  private UUID createdBy;

  @JsonProperty("createdWhen")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime createdWhen;

  @JsonProperty("id")
  private UUID id;

  @JsonProperty("labels")
  @Valid
  private List<LabelCreatedModifiedViewDto> labels = null;

  @JsonProperty("modifiedBy")
  private UUID modifiedBy;

  @JsonProperty("modifiedWhen")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime modifiedWhen;

  @JsonProperty("name")
  private String name;

  @JsonProperty("testPlan")
  private TestPlanCreatedModifiedViewDto testPlan;

  public DataSetListCreatedModifiedViewDto createdBy(UUID createdBy) {
    this.createdBy = createdBy;
    return this;
  }

  /**
   * Get createdBy
   * @return createdBy
  */
  @Valid 
  @Schema(name = "createdBy", required = false)
  public UUID getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(UUID createdBy) {
    this.createdBy = createdBy;
  }

  public DataSetListCreatedModifiedViewDto createdWhen(OffsetDateTime createdWhen) {
    this.createdWhen = createdWhen;
    return this;
  }

  /**
   * Get createdWhen
   * @return createdWhen
  */
  @Valid 
  @Schema(name = "createdWhen", required = false)
  public OffsetDateTime getCreatedWhen() {
    return createdWhen;
  }

  public void setCreatedWhen(OffsetDateTime createdWhen) {
    this.createdWhen = createdWhen;
  }

  public DataSetListCreatedModifiedViewDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @NotNull @Valid 
  @Schema(name = "id", required = true)
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public DataSetListCreatedModifiedViewDto labels(List<LabelCreatedModifiedViewDto> labels) {
    this.labels = labels;
    return this;
  }

  public DataSetListCreatedModifiedViewDto addLabelsItem(LabelCreatedModifiedViewDto labelsItem) {
    if (this.labels == null) {
      this.labels = new ArrayList<>();
    }
    this.labels.add(labelsItem);
    return this;
  }

  /**
   * Get labels
   * @return labels
  */
  @Valid 
  @Schema(name = "labels", required = false)
  public List<LabelCreatedModifiedViewDto> getLabels() {
    return labels;
  }

  public void setLabels(List<LabelCreatedModifiedViewDto> labels) {
    this.labels = labels;
  }

  public DataSetListCreatedModifiedViewDto modifiedBy(UUID modifiedBy) {
    this.modifiedBy = modifiedBy;
    return this;
  }

  /**
   * Get modifiedBy
   * @return modifiedBy
  */
  @Valid 
  @Schema(name = "modifiedBy", required = false)
  public UUID getModifiedBy() {
    return modifiedBy;
  }

  public void setModifiedBy(UUID modifiedBy) {
    this.modifiedBy = modifiedBy;
  }

  public DataSetListCreatedModifiedViewDto modifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
    return this;
  }

  /**
   * Get modifiedWhen
   * @return modifiedWhen
  */
  @Valid 
  @Schema(name = "modifiedWhen", required = false)
  public OffsetDateTime getModifiedWhen() {
    return modifiedWhen;
  }

  public void setModifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
  }

  public DataSetListCreatedModifiedViewDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  @NotNull 
  @Schema(name = "name", required = true)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public DataSetListCreatedModifiedViewDto testPlan(TestPlanCreatedModifiedViewDto testPlan) {
    this.testPlan = testPlan;
    return this;
  }

  /**
   * Get testPlan
   * @return testPlan
  */
  @Valid 
  @Schema(name = "testPlan", required = false)
  public TestPlanCreatedModifiedViewDto getTestPlan() {
    return testPlan;
  }

  public void setTestPlan(TestPlanCreatedModifiedViewDto testPlan) {
    this.testPlan = testPlan;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataSetListCreatedModifiedViewDto dataSetListCreatedModifiedView = (DataSetListCreatedModifiedViewDto) o;
    return Objects.equals(this.createdBy, dataSetListCreatedModifiedView.createdBy) &&
        Objects.equals(this.createdWhen, dataSetListCreatedModifiedView.createdWhen) &&
        Objects.equals(this.id, dataSetListCreatedModifiedView.id) &&
        Objects.equals(this.labels, dataSetListCreatedModifiedView.labels) &&
        Objects.equals(this.modifiedBy, dataSetListCreatedModifiedView.modifiedBy) &&
        Objects.equals(this.modifiedWhen, dataSetListCreatedModifiedView.modifiedWhen) &&
        Objects.equals(this.name, dataSetListCreatedModifiedView.name) &&
        Objects.equals(this.testPlan, dataSetListCreatedModifiedView.testPlan);
  }

  @Override
  public int hashCode() {
    return Objects.hash(createdBy, createdWhen, id, labels, modifiedBy, modifiedWhen, name, testPlan);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataSetListCreatedModifiedViewDto {\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    createdWhen: ").append(toIndentedString(createdWhen)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    labels: ").append(toIndentedString(labels)).append("\n");
    sb.append("    modifiedBy: ").append(toIndentedString(modifiedBy)).append("\n");
    sb.append("    modifiedWhen: ").append(toIndentedString(modifiedWhen)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    testPlan: ").append(toIndentedString(testPlan)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

