package org.qubership.atp.dataset.clients.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.dataset.clients.dto.AttributeTypeDto;
import org.qubership.atp.dataset.clients.dto.RefParameterDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * RefDataSetListAttributeDto
 */

@JsonTypeName("RefDataSetListAttribute")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-11T14:57:02.564217382Z[Etc/UTC]")
public class RefDataSetListAttributeDto {

  @JsonProperty("containsAttributes")
  private Boolean containsAttributes;

  @JsonProperty("id")
  private UUID id;

  @JsonProperty("name")
  private String name;

  @JsonProperty("parameters")
  @Valid
  private List<RefParameterDto> parameters = null;

  @JsonProperty("type")
  private AttributeTypeDto type;

  public RefDataSetListAttributeDto containsAttributes(Boolean containsAttributes) {
    this.containsAttributes = containsAttributes;
    return this;
  }

  /**
   * Get containsAttributes
   * @return containsAttributes
  */
  
  @Schema(name = "containsAttributes", required = false)
  public Boolean getContainsAttributes() {
    return containsAttributes;
  }

  public void setContainsAttributes(Boolean containsAttributes) {
    this.containsAttributes = containsAttributes;
  }

  public RefDataSetListAttributeDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @Valid 
  @Schema(name = "id", required = false)
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public RefDataSetListAttributeDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public RefDataSetListAttributeDto parameters(List<RefParameterDto> parameters) {
    this.parameters = parameters;
    return this;
  }

  public RefDataSetListAttributeDto addParametersItem(RefParameterDto parametersItem) {
    if (this.parameters == null) {
      this.parameters = new ArrayList<>();
    }
    this.parameters.add(parametersItem);
    return this;
  }

  /**
   * Get parameters
   * @return parameters
  */
  @Valid 
  @Schema(name = "parameters", required = false)
  public List<RefParameterDto> getParameters() {
    return parameters;
  }

  public void setParameters(List<RefParameterDto> parameters) {
    this.parameters = parameters;
  }

  public RefDataSetListAttributeDto type(AttributeTypeDto type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  @Valid 
  @Schema(name = "type", required = false)
  public AttributeTypeDto getType() {
    return type;
  }

  public void setType(AttributeTypeDto type) {
    this.type = type;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RefDataSetListAttributeDto refDataSetListAttribute = (RefDataSetListAttributeDto) o;
    return Objects.equals(this.containsAttributes, refDataSetListAttribute.containsAttributes) &&
        Objects.equals(this.id, refDataSetListAttribute.id) &&
        Objects.equals(this.name, refDataSetListAttribute.name) &&
        Objects.equals(this.parameters, refDataSetListAttribute.parameters) &&
        Objects.equals(this.type, refDataSetListAttribute.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(containsAttributes, id, name, parameters, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RefDataSetListAttributeDto {\n");
    sb.append("    containsAttributes: ").append(toIndentedString(containsAttributes)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

