/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.2.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.ram.clients.api;

import org.qubership.atp.ram.clients.api.dto.catalogue.AbstractTestScenarioDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CloneTestPlanRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CompareTestPlanQaDslResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CompareTestPlansRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CompareTestPlansResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CompoundDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.DslDependencyNodeDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.LabelDto;
import java.util.List;
import org.qubership.atp.ram.clients.api.dto.catalogue.LogCollectorConditionDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.QaDslLibraryDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseGroupDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestPlanDslMappingsRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestPlanDslMappingsResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestPlanDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestPlanDtoDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestPlanEntitiesResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestPlanResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestScenarioDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestScopeDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestScopeFullInfoDto;
import java.util.UUID;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-11T14:57:00.272691897Z[Etc/UTC]")
@Validated
@Tag(name = "TestPlanController", description = "Test Plan Controller")
public interface TestPlanControllerApi {

    /**
     * PUT /catalog/api/v1/testplans/bulk : bulkUpdate
     *
     * @param testPlanDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "bulkUpdate",
        summary = "bulkUpdate",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestPlanResponseDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/catalog/api/v1/testplans/bulk",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<TestPlanResponseDto>> bulkUpdate(
        @Parameter(name = "TestPlanDto", description = "") @Valid @RequestBody(required = false) List<TestPlanDto> testPlanDto
    );


    /**
     * POST /catalog/api/v1/testplans/clone : cloneTestPlan
     *
     * @param cloneTestPlanRequestDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "cloneTestPlan",
        summary = "cloneTestPlan",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UUID.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/testplans/clone",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<UUID> cloneTestPlan(
        @Parameter(name = "CloneTestPlanRequestDto", description = "") @Valid @RequestBody(required = false) CloneTestPlanRequestDto cloneTestPlanRequestDto
    );


    /**
     * POST /catalog/api/v1/testplans/qadsllibraries/compare : compareTestPlanQaDsl
     *
     * @param compareTestPlansRequestDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "compareTestPlanQaDsl",
        summary = "compareTestPlanQaDsl",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = CompareTestPlanQaDslResponseDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/testplans/qadsllibraries/compare",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<CompareTestPlanQaDslResponseDto> compareTestPlanQaDsl(
        @Parameter(name = "CompareTestPlansRequestDto", description = "") @Valid @RequestBody(required = false) CompareTestPlansRequestDto compareTestPlansRequestDto
    );


    /**
     * POST /catalog/api/v1/testplans/compare : compareTestPlans
     *
     * @param compareTestPlansRequestDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "compareTestPlans",
        summary = "compareTestPlans",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = CompareTestPlansResponseDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/testplans/compare",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<CompareTestPlansResponseDto> compareTestPlans(
        @Parameter(name = "CompareTestPlansRequestDto", description = "") @Valid @RequestBody(required = false) CompareTestPlansRequestDto compareTestPlansRequestDto
    );


    /**
     * POST /catalog/api/v1/testplans : create
     *
     * @param testPlanDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "create",
        summary = "create",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestPlanResponseDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/testplans",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<TestPlanResponseDto> create(
        @Parameter(name = "TestPlanDto", description = "") @Valid @RequestBody(required = false) TestPlanDto testPlanDto
    );


    /**
     * DELETE /catalog/api/v1/testplans/{uuid} : delete
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     */
    @Operation(
        operationId = "delete",
        summary = "delete",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/catalog/api/v1/testplans/{uuid}"
    )
    ResponseEntity<Void> delete(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/testplans : getAll
     *
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAll",
        summary = "getAll",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestPlanResponseDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/testplans",
        produces = { "application/json" }
    )
    ResponseEntity<List<TestPlanResponseDto>> getAll(
        
    );


    /**
     * GET /catalog/api/v1/testplans/{uuid}/compounds/compound_from_ts : getAllCompoundsAndScenarioCompounds
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAllCompoundsAndScenarioCompounds",
        summary = "getAllCompoundsAndScenarioCompounds",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = AbstractTestScenarioDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/testplans/{uuid}/compounds/compound_from_ts",
        produces = { "application/json" }
    )
    ResponseEntity<List<AbstractTestScenarioDto>> getAllCompoundsAndScenarioCompounds(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/testplans/{uuid}/compounds : getAllCompoundsByTestPlan
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAllCompoundsByTestPlan",
        summary = "getAllCompoundsByTestPlan",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = CompoundDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/testplans/{uuid}/compounds",
        produces = { "application/json" }
    )
    ResponseEntity<List<CompoundDto>> getAllCompoundsByTestPlan(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/testplans/{uuid}/compound_from_ts : getAllCompoundsMadeFromTestScenario
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAllCompoundsMadeFromTestScenario",
        summary = "getAllCompoundsMadeFromTestScenario",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestScenarioDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/testplans/{uuid}/compound_from_ts",
        produces = { "application/json" }
    )
    ResponseEntity<List<TestScenarioDto>> getAllCompoundsMadeFromTestScenario(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/testplans/{uuid}/testcasegroups/short : getAllNameByTestPlanId
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAllNameByTestPlanId",
        summary = "getAllNameByTestPlanId",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestCaseGroupDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/testplans/{uuid}/testcasegroups/short",
        produces = { "application/json" }
    )
    ResponseEntity<List<TestCaseGroupDto>> getAllNameByTestPlanId(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/testplans/{uuid}/dslDependencies : getDslDependencies
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDslDependencies",
        summary = "getDslDependencies",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = DslDependencyNodeDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/testplans/{uuid}/dslDependencies",
        produces = { "application/json" }
    )
    ResponseEntity<List<DslDependencyNodeDto>> getDslDependencies(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * POST /catalog/api/v1/testplans/{testPlanId}/dslMappings : getDslMappings
     *
     * @param testPlanId  (required)
     * @param testPlanDslMappingsRequestDto  (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDslMappings",
        summary = "getDslMappings",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestPlanDslMappingsResponseDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/testplans/{testPlanId}/dslMappings",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<TestPlanDslMappingsResponseDto> getDslMappings(
        @Parameter(name = "testPlanId", description = "", required = true) @PathVariable("testPlanId") UUID testPlanId,
        @Parameter(name = "TestPlanDslMappingsRequestDto", description = "") @Valid @RequestBody(required = false) TestPlanDslMappingsRequestDto testPlanDslMappingsRequestDto
    );


    /**
     * GET /catalog/api/v1/testplans/{uuid}/enriched : getEntitiesForCopyByTestPlan
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getEntitiesForCopyByTestPlan",
        summary = "getEntitiesForCopyByTestPlan",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestPlanEntitiesResponseDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/testplans/{uuid}/enriched",
        produces = { "application/json" }
    )
    ResponseEntity<TestPlanEntitiesResponseDto> getEntitiesForCopyByTestPlan(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/testplans/{uuid}/labels : getLabelsByTestPlanId
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getLabelsByTestPlanId",
        summary = "getLabelsByTestPlanId",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = LabelDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/testplans/{uuid}/labels",
        produces = { "application/json" }
    )
    ResponseEntity<List<LabelDto>> getLabelsByTestPlanId(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/testplans/{uuid}/logcollectorconditions : getLogCollectorConditionByTestPlan
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getLogCollectorConditionByTestPlan",
        summary = "getLogCollectorConditionByTestPlan",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = LogCollectorConditionDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/testplans/{uuid}/logcollectorconditions",
        produces = { "application/json" }
    )
    ResponseEntity<List<LogCollectorConditionDto>> getLogCollectorConditionByTestPlan(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/testplans/{uuid}/testcasegroups : getTestCaseGroupedByTestPlanId
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getTestCaseGroupedByTestPlanId",
        summary = "getTestCaseGroupedByTestPlanId",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestCaseGroupDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/testplans/{uuid}/testcasegroups",
        produces = { "application/json" }
    )
    ResponseEntity<List<TestCaseGroupDto>> getTestCaseGroupedByTestPlanId(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/testplans/{uuid}/testcases : getTestCasesByTestPlanId
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getTestCasesByTestPlanId",
        summary = "getTestCasesByTestPlanId",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestCaseDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/testplans/{uuid}/testcases",
        produces = { "application/json" }
    )
    ResponseEntity<List<TestCaseDto>> getTestCasesByTestPlanId(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/testplans/{uuid} : getTestPlanByUuid
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getTestPlanByUuid",
        summary = "getTestPlanByUuid",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestPlanDtoDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/testplans/{uuid}",
        produces = { "application/json" }
    )
    ResponseEntity<TestPlanDtoDto> getTestPlanByUuid(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/testplans/{uuid}/qadsllibrary : getTestPlanQaDslLibrary
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getTestPlanQaDslLibrary",
        summary = "getTestPlanQaDslLibrary",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = QaDslLibraryDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/testplans/{uuid}/qadsllibrary",
        produces = { "application/json" }
    )
    ResponseEntity<QaDslLibraryDto> getTestPlanQaDslLibrary(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/testplans/{uuid}/testscopes : getTestScopesByTestPlanId
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getTestScopesByTestPlanId",
        summary = "getTestScopesByTestPlanId",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestScopeDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/testplans/{uuid}/testscopes",
        produces = { "application/json" }
    )
    ResponseEntity<List<TestScopeDto>> getTestScopesByTestPlanId(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/testplans/{uuid}/testscopes/enriched : getTestScopesFullInfoByTestPlanUuid
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getTestScopesFullInfoByTestPlanUuid",
        summary = "getTestScopesFullInfoByTestPlanUuid",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestScopeFullInfoDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/testplans/{uuid}/testscopes/enriched",
        produces = { "application/json" }
    )
    ResponseEntity<List<TestScopeFullInfoDto>> getTestScopesFullInfoByTestPlanUuid(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * PATCH /catalog/api/v1/testplans : patch
     *
     * @param testPlanDto  (optional)
     * @return OK (status code 200)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     */
    @Operation(
        operationId = "patch",
        summary = "patch",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden")
        }
    )
    @RequestMapping(
        method = RequestMethod.PATCH,
        value = "/catalog/api/v1/testplans",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> patch(
        @Parameter(name = "TestPlanDto", description = "") @Valid @RequestBody(required = false) List<TestPlanDto> testPlanDto
    );


    /**
     * PUT /catalog/api/v1/testplans/patch : patchUpdate
     *
     * @param testPlanDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "patchUpdate",
        summary = "patchUpdate",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UUID.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/catalog/api/v1/testplans/patch",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<UUID> patchUpdate(
        @Parameter(name = "TestPlanDto", description = "") @Valid @RequestBody(required = false) TestPlanDto testPlanDto
    );


    /**
     * PUT /catalog/api/v1/testplans : update
     *
     * @param testPlanDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "update",
        summary = "update",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UUID.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/catalog/api/v1/testplans",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<UUID> update(
        @Parameter(name = "TestPlanDto", description = "") @Valid @RequestBody(required = false) TestPlanDto testPlanDto
    );


    /**
     * PUT /catalog/api/v1/testplans/update-qa-dsl : updateQaDslLibraryField
     *
     * @param testPlanDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateQaDslLibraryField",
        summary = "updateQaDslLibraryField",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UUID.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/catalog/api/v1/testplans/update-qa-dsl",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<UUID> updateQaDslLibraryField(
        @Parameter(name = "TestPlanDto", description = "") @Valid @RequestBody(required = false) TestPlanDto testPlanDto
    );

}
