package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.ram.clients.api.dto.catalogue.ActionDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ActionGroupByTypeCompoundEntryDto
 */

@JsonTypeName("ActionGroupByTypeCompoundEntry")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-11T14:56:59.029313256Z[Etc/UTC]")
public class ActionGroupByTypeCompoundEntryDto {

  @JsonProperty("actions")
  @Valid
  private List<ActionDto> actions = null;

  @JsonProperty("typeAction")
  private String typeAction;

  public ActionGroupByTypeCompoundEntryDto actions(List<ActionDto> actions) {
    this.actions = actions;
    return this;
  }

  public ActionGroupByTypeCompoundEntryDto addActionsItem(ActionDto actionsItem) {
    if (this.actions == null) {
      this.actions = new ArrayList<>();
    }
    this.actions.add(actionsItem);
    return this;
  }

  /**
   * Get actions
   * @return actions
  */
  @Valid 
  @Schema(name = "actions", required = false)
  public List<ActionDto> getActions() {
    return actions;
  }

  public void setActions(List<ActionDto> actions) {
    this.actions = actions;
  }

  public ActionGroupByTypeCompoundEntryDto typeAction(String typeAction) {
    this.typeAction = typeAction;
    return this;
  }

  /**
   * Get typeAction
   * @return typeAction
  */
  
  @Schema(name = "typeAction", required = false)
  public String getTypeAction() {
    return typeAction;
  }

  public void setTypeAction(String typeAction) {
    this.typeAction = typeAction;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ActionGroupByTypeCompoundEntryDto actionGroupByTypeCompoundEntry = (ActionGroupByTypeCompoundEntryDto) o;
    return Objects.equals(this.actions, actionGroupByTypeCompoundEntry.actions) &&
        Objects.equals(this.typeAction, actionGroupByTypeCompoundEntry.typeAction);
  }

  @Override
  public int hashCode() {
    return Objects.hash(actions, typeAction);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ActionGroupByTypeCompoundEntryDto {\n");
    sb.append("    actions: ").append(toIndentedString(actions)).append("\n");
    sb.append("    typeAction: ").append(toIndentedString(typeAction)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

