package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraComponentDto;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * CasePatchUpdateRequestDto
 */

@JsonTypeName("CasePatchUpdateRequest")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-11T14:56:59.611219391Z[Etc/UTC]")
public class CasePatchUpdateRequestDto {

  @JsonProperty("assigneeId")
  private UUID assigneeId;

  @JsonProperty("components")
  @Valid
  private List<JiraComponentDto> components = null;

  @JsonProperty("datasetId")
  private UUID datasetId;

  @JsonProperty("datasetStorageId")
  private UUID datasetStorageId;

  @JsonProperty("description")
  private String description;

  @JsonProperty("labelIds")
  @Valid
  private List<UUID> labelIds = null;

  @JsonProperty("modifiedWhen")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime modifiedWhen;

  @JsonProperty("name")
  private String name;

  /**
   * Gets or Sets priority
   */
  public enum PriorityEnum {
    BLOCKER("BLOCKER"),
    
    CRITICAL("CRITICAL"),
    
    LOW("LOW"),
    
    MAJOR("MAJOR"),
    
    NORMAL("NORMAL");

    private String value;

    PriorityEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PriorityEnum fromValue(String value) {
      for (PriorityEnum b : PriorityEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("priority")
  private PriorityEnum priority;

  @JsonProperty("scenarioId")
  private UUID scenarioId;

  /**
   * Gets or Sets status
   */
  public enum StatusEnum {
    BLOCKED("BLOCKED"),
    
    CANCELLED("CANCELLED"),
    
    FAILED("FAILED"),
    
    IN_PROGRESS("IN_PROGRESS"),
    
    NOT_DELIVERED("NOT_DELIVERED"),
    
    OPEN("OPEN"),
    
    PASSED("PASSED"),
    
    PASSED_WITH_MINOR_DEFECTS("PASSED_WITH_MINOR_DEFECTS");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("status")
  private StatusEnum status;

  @JsonProperty("testScopeIds")
  @Valid
  private List<UUID> testScopeIds = null;

  public CasePatchUpdateRequestDto assigneeId(UUID assigneeId) {
    this.assigneeId = assigneeId;
    return this;
  }

  /**
   * Get assigneeId
   * @return assigneeId
  */
  @Valid 
  @Schema(name = "assigneeId", required = false)
  public UUID getAssigneeId() {
    return assigneeId;
  }

  public void setAssigneeId(UUID assigneeId) {
    this.assigneeId = assigneeId;
  }

  public CasePatchUpdateRequestDto components(List<JiraComponentDto> components) {
    this.components = components;
    return this;
  }

  public CasePatchUpdateRequestDto addComponentsItem(JiraComponentDto componentsItem) {
    if (this.components == null) {
      this.components = new ArrayList<>();
    }
    this.components.add(componentsItem);
    return this;
  }

  /**
   * Get components
   * @return components
  */
  @Valid 
  @Schema(name = "components", required = false)
  public List<JiraComponentDto> getComponents() {
    return components;
  }

  public void setComponents(List<JiraComponentDto> components) {
    this.components = components;
  }

  public CasePatchUpdateRequestDto datasetId(UUID datasetId) {
    this.datasetId = datasetId;
    return this;
  }

  /**
   * Get datasetId
   * @return datasetId
  */
  @Valid 
  @Schema(name = "datasetId", required = false)
  public UUID getDatasetId() {
    return datasetId;
  }

  public void setDatasetId(UUID datasetId) {
    this.datasetId = datasetId;
  }

  public CasePatchUpdateRequestDto datasetStorageId(UUID datasetStorageId) {
    this.datasetStorageId = datasetStorageId;
    return this;
  }

  /**
   * Get datasetStorageId
   * @return datasetStorageId
  */
  @Valid 
  @Schema(name = "datasetStorageId", required = false)
  public UUID getDatasetStorageId() {
    return datasetStorageId;
  }

  public void setDatasetStorageId(UUID datasetStorageId) {
    this.datasetStorageId = datasetStorageId;
  }

  public CasePatchUpdateRequestDto description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", required = false)
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public CasePatchUpdateRequestDto labelIds(List<UUID> labelIds) {
    this.labelIds = labelIds;
    return this;
  }

  public CasePatchUpdateRequestDto addLabelIdsItem(UUID labelIdsItem) {
    if (this.labelIds == null) {
      this.labelIds = new ArrayList<>();
    }
    this.labelIds.add(labelIdsItem);
    return this;
  }

  /**
   * Get labelIds
   * @return labelIds
  */
  @Valid 
  @Schema(name = "labelIds", required = false)
  public List<UUID> getLabelIds() {
    return labelIds;
  }

  public void setLabelIds(List<UUID> labelIds) {
    this.labelIds = labelIds;
  }

  public CasePatchUpdateRequestDto modifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
    return this;
  }

  /**
   * Get modifiedWhen
   * @return modifiedWhen
  */
  @Valid 
  @Schema(name = "modifiedWhen", required = false)
  public OffsetDateTime getModifiedWhen() {
    return modifiedWhen;
  }

  public void setModifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
  }

  public CasePatchUpdateRequestDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public CasePatchUpdateRequestDto priority(PriorityEnum priority) {
    this.priority = priority;
    return this;
  }

  /**
   * Get priority
   * @return priority
  */
  
  @Schema(name = "priority", required = false)
  public PriorityEnum getPriority() {
    return priority;
  }

  public void setPriority(PriorityEnum priority) {
    this.priority = priority;
  }

  public CasePatchUpdateRequestDto scenarioId(UUID scenarioId) {
    this.scenarioId = scenarioId;
    return this;
  }

  /**
   * Get scenarioId
   * @return scenarioId
  */
  @Valid 
  @Schema(name = "scenarioId", required = false)
  public UUID getScenarioId() {
    return scenarioId;
  }

  public void setScenarioId(UUID scenarioId) {
    this.scenarioId = scenarioId;
  }

  public CasePatchUpdateRequestDto status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
  */
  
  @Schema(name = "status", required = false)
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public CasePatchUpdateRequestDto testScopeIds(List<UUID> testScopeIds) {
    this.testScopeIds = testScopeIds;
    return this;
  }

  public CasePatchUpdateRequestDto addTestScopeIdsItem(UUID testScopeIdsItem) {
    if (this.testScopeIds == null) {
      this.testScopeIds = new ArrayList<>();
    }
    this.testScopeIds.add(testScopeIdsItem);
    return this;
  }

  /**
   * Get testScopeIds
   * @return testScopeIds
  */
  @Valid 
  @Schema(name = "testScopeIds", required = false)
  public List<UUID> getTestScopeIds() {
    return testScopeIds;
  }

  public void setTestScopeIds(List<UUID> testScopeIds) {
    this.testScopeIds = testScopeIds;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CasePatchUpdateRequestDto casePatchUpdateRequest = (CasePatchUpdateRequestDto) o;
    return Objects.equals(this.assigneeId, casePatchUpdateRequest.assigneeId) &&
        Objects.equals(this.components, casePatchUpdateRequest.components) &&
        Objects.equals(this.datasetId, casePatchUpdateRequest.datasetId) &&
        Objects.equals(this.datasetStorageId, casePatchUpdateRequest.datasetStorageId) &&
        Objects.equals(this.description, casePatchUpdateRequest.description) &&
        Objects.equals(this.labelIds, casePatchUpdateRequest.labelIds) &&
        Objects.equals(this.modifiedWhen, casePatchUpdateRequest.modifiedWhen) &&
        Objects.equals(this.name, casePatchUpdateRequest.name) &&
        Objects.equals(this.priority, casePatchUpdateRequest.priority) &&
        Objects.equals(this.scenarioId, casePatchUpdateRequest.scenarioId) &&
        Objects.equals(this.status, casePatchUpdateRequest.status) &&
        Objects.equals(this.testScopeIds, casePatchUpdateRequest.testScopeIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(assigneeId, components, datasetId, datasetStorageId, description, labelIds, modifiedWhen, name, priority, scenarioId, status, testScopeIds);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CasePatchUpdateRequestDto {\n");
    sb.append("    assigneeId: ").append(toIndentedString(assigneeId)).append("\n");
    sb.append("    components: ").append(toIndentedString(components)).append("\n");
    sb.append("    datasetId: ").append(toIndentedString(datasetId)).append("\n");
    sb.append("    datasetStorageId: ").append(toIndentedString(datasetStorageId)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    labelIds: ").append(toIndentedString(labelIds)).append("\n");
    sb.append("    modifiedWhen: ").append(toIndentedString(modifiedWhen)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    scenarioId: ").append(toIndentedString(scenarioId)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    testScopeIds: ").append(toIndentedString(testScopeIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

