package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.UUID;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * CompoundCompareDto
 */

@JsonTypeName("CompoundCompare")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-11T14:57:00.272691897Z[Etc/UTC]")
public class CompoundCompareDto {

  @JsonProperty("leftCompoundId")
  private UUID leftCompoundId;

  @JsonProperty("leftCompoundName")
  private String leftCompoundName;

  @JsonProperty("rightCompoundId")
  private UUID rightCompoundId;

  @JsonProperty("rightCompoundName")
  private String rightCompoundName;

  /**
   * Gets or Sets status
   */
  public enum StatusEnum {
    OK("OK"),
    
    WARNING("WARNING");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("status")
  private StatusEnum status;

  public CompoundCompareDto leftCompoundId(UUID leftCompoundId) {
    this.leftCompoundId = leftCompoundId;
    return this;
  }

  /**
   * Get leftCompoundId
   * @return leftCompoundId
  */
  @Valid 
  @Schema(name = "leftCompoundId", required = false)
  public UUID getLeftCompoundId() {
    return leftCompoundId;
  }

  public void setLeftCompoundId(UUID leftCompoundId) {
    this.leftCompoundId = leftCompoundId;
  }

  public CompoundCompareDto leftCompoundName(String leftCompoundName) {
    this.leftCompoundName = leftCompoundName;
    return this;
  }

  /**
   * Get leftCompoundName
   * @return leftCompoundName
  */
  
  @Schema(name = "leftCompoundName", required = false)
  public String getLeftCompoundName() {
    return leftCompoundName;
  }

  public void setLeftCompoundName(String leftCompoundName) {
    this.leftCompoundName = leftCompoundName;
  }

  public CompoundCompareDto rightCompoundId(UUID rightCompoundId) {
    this.rightCompoundId = rightCompoundId;
    return this;
  }

  /**
   * Get rightCompoundId
   * @return rightCompoundId
  */
  @Valid 
  @Schema(name = "rightCompoundId", required = false)
  public UUID getRightCompoundId() {
    return rightCompoundId;
  }

  public void setRightCompoundId(UUID rightCompoundId) {
    this.rightCompoundId = rightCompoundId;
  }

  public CompoundCompareDto rightCompoundName(String rightCompoundName) {
    this.rightCompoundName = rightCompoundName;
    return this;
  }

  /**
   * Get rightCompoundName
   * @return rightCompoundName
  */
  
  @Schema(name = "rightCompoundName", required = false)
  public String getRightCompoundName() {
    return rightCompoundName;
  }

  public void setRightCompoundName(String rightCompoundName) {
    this.rightCompoundName = rightCompoundName;
  }

  public CompoundCompareDto status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
  */
  
  @Schema(name = "status", required = false)
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CompoundCompareDto compoundCompare = (CompoundCompareDto) o;
    return Objects.equals(this.leftCompoundId, compoundCompare.leftCompoundId) &&
        Objects.equals(this.leftCompoundName, compoundCompare.leftCompoundName) &&
        Objects.equals(this.rightCompoundId, compoundCompare.rightCompoundId) &&
        Objects.equals(this.rightCompoundName, compoundCompare.rightCompoundName) &&
        Objects.equals(this.status, compoundCompare.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(leftCompoundId, leftCompoundName, rightCompoundId, rightCompoundName, status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CompoundCompareDto {\n");
    sb.append("    leftCompoundId: ").append(toIndentedString(leftCompoundId)).append("\n");
    sb.append("    leftCompoundName: ").append(toIndentedString(leftCompoundName)).append("\n");
    sb.append("    rightCompoundId: ").append(toIndentedString(rightCompoundId)).append("\n");
    sb.append("    rightCompoundName: ").append(toIndentedString(rightCompoundName)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

