package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.UUID;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * IssueDto
 */

@JsonTypeName("Issue")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-11T14:57:01.715155605Z[Etc/UTC]")
public class IssueDto {

  @JsonProperty("businessMessage")
  private String businessMessage;

  @JsonProperty("component")
  private String component;

  @JsonProperty("description")
  private String description;

  @JsonProperty("errorMessage")
  private String errorMessage;

  @JsonProperty("failPattern")
  private String failPattern;

  @JsonProperty("name")
  private String name;

  /**
   * Gets or Sets priority
   */
  public enum PriorityEnum {
    BLOCKER("BLOCKER"),
    
    CRITICAL("CRITICAL"),
    
    LOW("LOW"),
    
    MAJOR("MAJOR"),
    
    NORMAL("NORMAL");

    private String value;

    PriorityEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PriorityEnum fromValue(String value) {
      for (PriorityEnum b : PriorityEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("priority")
  private PriorityEnum priority;

  @JsonProperty("projectId")
  private UUID projectId;

  @JsonProperty("uuid")
  private UUID uuid;

  public IssueDto businessMessage(String businessMessage) {
    this.businessMessage = businessMessage;
    return this;
  }

  /**
   * Get businessMessage
   * @return businessMessage
  */
  
  @Schema(name = "businessMessage", required = false)
  public String getBusinessMessage() {
    return businessMessage;
  }

  public void setBusinessMessage(String businessMessage) {
    this.businessMessage = businessMessage;
  }

  public IssueDto component(String component) {
    this.component = component;
    return this;
  }

  /**
   * Get component
   * @return component
  */
  
  @Schema(name = "component", required = false)
  public String getComponent() {
    return component;
  }

  public void setComponent(String component) {
    this.component = component;
  }

  public IssueDto description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", required = false)
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public IssueDto errorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
    return this;
  }

  /**
   * Get errorMessage
   * @return errorMessage
  */
  
  @Schema(name = "errorMessage", required = false)
  public String getErrorMessage() {
    return errorMessage;
  }

  public void setErrorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
  }

  public IssueDto failPattern(String failPattern) {
    this.failPattern = failPattern;
    return this;
  }

  /**
   * Get failPattern
   * @return failPattern
  */
  
  @Schema(name = "failPattern", required = false)
  public String getFailPattern() {
    return failPattern;
  }

  public void setFailPattern(String failPattern) {
    this.failPattern = failPattern;
  }

  public IssueDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public IssueDto priority(PriorityEnum priority) {
    this.priority = priority;
    return this;
  }

  /**
   * Get priority
   * @return priority
  */
  
  @Schema(name = "priority", required = false)
  public PriorityEnum getPriority() {
    return priority;
  }

  public void setPriority(PriorityEnum priority) {
    this.priority = priority;
  }

  public IssueDto projectId(UUID projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Get projectId
   * @return projectId
  */
  @Valid 
  @Schema(name = "projectId", required = false)
  public UUID getProjectId() {
    return projectId;
  }

  public void setProjectId(UUID projectId) {
    this.projectId = projectId;
  }

  public IssueDto uuid(UUID uuid) {
    this.uuid = uuid;
    return this;
  }

  /**
   * Get uuid
   * @return uuid
  */
  @Valid 
  @Schema(name = "uuid", required = false)
  public UUID getUuid() {
    return uuid;
  }

  public void setUuid(UUID uuid) {
    this.uuid = uuid;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IssueDto issue = (IssueDto) o;
    return Objects.equals(this.businessMessage, issue.businessMessage) &&
        Objects.equals(this.component, issue.component) &&
        Objects.equals(this.description, issue.description) &&
        Objects.equals(this.errorMessage, issue.errorMessage) &&
        Objects.equals(this.failPattern, issue.failPattern) &&
        Objects.equals(this.name, issue.name) &&
        Objects.equals(this.priority, issue.priority) &&
        Objects.equals(this.projectId, issue.projectId) &&
        Objects.equals(this.uuid, issue.uuid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(businessMessage, component, description, errorMessage, failPattern, name, priority, projectId, uuid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IssueDto {\n");
    sb.append("    businessMessage: ").append(toIndentedString(businessMessage)).append("\n");
    sb.append("    component: ").append(toIndentedString(component)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("    failPattern: ").append(toIndentedString(failPattern)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

