package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.clients.api.dto.catalogue.MetaInfoDto;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ScenarioPatchUpdateRequestDto
 */

@JsonTypeName("ScenarioPatchUpdateRequest")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-11T14:57:01.206175257Z[Etc/UTC]")
public class ScenarioPatchUpdateRequestDto {

  @JsonProperty("alsoCompound")
  private Boolean alsoCompound;

  @JsonProperty("description")
  private String description;

  @JsonProperty("groupUuid")
  private UUID groupUuid;

  @JsonProperty("metainfo")
  @Valid
  private List<MetaInfoDto> metainfo = null;

  @JsonProperty("modifiedWhen")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime modifiedWhen;

  @JsonProperty("name")
  private String name;

  /**
   * Gets or Sets type
   */
  public enum TypeEnum {
    COMPOUND("COMPOUND"),
    
    TESTSCENARIO("TESTSCENARIO");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("type")
  private TypeEnum type;

  public ScenarioPatchUpdateRequestDto alsoCompound(Boolean alsoCompound) {
    this.alsoCompound = alsoCompound;
    return this;
  }

  /**
   * Get alsoCompound
   * @return alsoCompound
  */
  
  @Schema(name = "alsoCompound", required = false)
  public Boolean getAlsoCompound() {
    return alsoCompound;
  }

  public void setAlsoCompound(Boolean alsoCompound) {
    this.alsoCompound = alsoCompound;
  }

  public ScenarioPatchUpdateRequestDto description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", required = false)
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public ScenarioPatchUpdateRequestDto groupUuid(UUID groupUuid) {
    this.groupUuid = groupUuid;
    return this;
  }

  /**
   * Get groupUuid
   * @return groupUuid
  */
  @Valid 
  @Schema(name = "groupUuid", required = false)
  public UUID getGroupUuid() {
    return groupUuid;
  }

  public void setGroupUuid(UUID groupUuid) {
    this.groupUuid = groupUuid;
  }

  public ScenarioPatchUpdateRequestDto metainfo(List<MetaInfoDto> metainfo) {
    this.metainfo = metainfo;
    return this;
  }

  public ScenarioPatchUpdateRequestDto addMetainfoItem(MetaInfoDto metainfoItem) {
    if (this.metainfo == null) {
      this.metainfo = new ArrayList<>();
    }
    this.metainfo.add(metainfoItem);
    return this;
  }

  /**
   * Get metainfo
   * @return metainfo
  */
  @Valid 
  @Schema(name = "metainfo", required = false)
  public List<MetaInfoDto> getMetainfo() {
    return metainfo;
  }

  public void setMetainfo(List<MetaInfoDto> metainfo) {
    this.metainfo = metainfo;
  }

  public ScenarioPatchUpdateRequestDto modifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
    return this;
  }

  /**
   * Get modifiedWhen
   * @return modifiedWhen
  */
  @Valid 
  @Schema(name = "modifiedWhen", required = false)
  public OffsetDateTime getModifiedWhen() {
    return modifiedWhen;
  }

  public void setModifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
  }

  public ScenarioPatchUpdateRequestDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ScenarioPatchUpdateRequestDto type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  
  @Schema(name = "type", required = false)
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ScenarioPatchUpdateRequestDto scenarioPatchUpdateRequest = (ScenarioPatchUpdateRequestDto) o;
    return Objects.equals(this.alsoCompound, scenarioPatchUpdateRequest.alsoCompound) &&
        Objects.equals(this.description, scenarioPatchUpdateRequest.description) &&
        Objects.equals(this.groupUuid, scenarioPatchUpdateRequest.groupUuid) &&
        Objects.equals(this.metainfo, scenarioPatchUpdateRequest.metainfo) &&
        Objects.equals(this.modifiedWhen, scenarioPatchUpdateRequest.modifiedWhen) &&
        Objects.equals(this.name, scenarioPatchUpdateRequest.name) &&
        Objects.equals(this.type, scenarioPatchUpdateRequest.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(alsoCompound, description, groupUuid, metainfo, modifiedWhen, name, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ScenarioPatchUpdateRequestDto {\n");
    sb.append("    alsoCompound: ").append(toIndentedString(alsoCompound)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    groupUuid: ").append(toIndentedString(groupUuid)).append("\n");
    sb.append("    metainfo: ").append(toIndentedString(metainfo)).append("\n");
    sb.append("    modifiedWhen: ").append(toIndentedString(modifiedWhen)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

