package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraComponentDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * TestCaseComponentsSetRequestDto
 */

@JsonTypeName("TestCaseComponentsSetRequest")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-11T14:56:59.611219391Z[Etc/UTC]")
public class TestCaseComponentsSetRequestDto {

  @JsonProperty("projectId")
  private UUID projectId;

  @JsonProperty("testCaseIds")
  @Valid
  private List<UUID> testCaseIds = null;

  @JsonProperty("components")
  @Valid
  private List<JiraComponentDto> components = null;

  public TestCaseComponentsSetRequestDto projectId(UUID projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Get projectId
   * @return projectId
  */
  @Valid 
  @Schema(name = "projectId", required = false)
  public UUID getProjectId() {
    return projectId;
  }

  public void setProjectId(UUID projectId) {
    this.projectId = projectId;
  }

  public TestCaseComponentsSetRequestDto testCaseIds(List<UUID> testCaseIds) {
    this.testCaseIds = testCaseIds;
    return this;
  }

  public TestCaseComponentsSetRequestDto addTestCaseIdsItem(UUID testCaseIdsItem) {
    if (this.testCaseIds == null) {
      this.testCaseIds = new ArrayList<>();
    }
    this.testCaseIds.add(testCaseIdsItem);
    return this;
  }

  /**
   * Get testCaseIds
   * @return testCaseIds
  */
  @Valid 
  @Schema(name = "testCaseIds", required = false)
  public List<UUID> getTestCaseIds() {
    return testCaseIds;
  }

  public void setTestCaseIds(List<UUID> testCaseIds) {
    this.testCaseIds = testCaseIds;
  }

  public TestCaseComponentsSetRequestDto components(List<JiraComponentDto> components) {
    this.components = components;
    return this;
  }

  public TestCaseComponentsSetRequestDto addComponentsItem(JiraComponentDto componentsItem) {
    if (this.components == null) {
      this.components = new ArrayList<>();
    }
    this.components.add(componentsItem);
    return this;
  }

  /**
   * Get components
   * @return components
  */
  @Valid 
  @Schema(name = "components", required = false)
  public List<JiraComponentDto> getComponents() {
    return components;
  }

  public void setComponents(List<JiraComponentDto> components) {
    this.components = components;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestCaseComponentsSetRequestDto testCaseComponentsSetRequest = (TestCaseComponentsSetRequestDto) o;
    return Objects.equals(this.projectId, testCaseComponentsSetRequest.projectId) &&
        Objects.equals(this.testCaseIds, testCaseComponentsSetRequest.testCaseIds) &&
        Objects.equals(this.components, testCaseComponentsSetRequest.components);
  }

  @Override
  public int hashCode() {
    return Objects.hash(projectId, testCaseIds, components);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestCaseComponentsSetRequestDto {\n");
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("    testCaseIds: ").append(toIndentedString(testCaseIds)).append("\n");
    sb.append("    components: ").append(toIndentedString(components)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

