/*
 * # Copyright 2024-2025 NetCracker Technology Corporation
 * #
 * # Licensed under the Apache License, Version 2.0 (the "License");
 * # you may not use this file except in compliance with the License.
 * # You may obtain a copy of the License at
 * #
 * #      http://www.apache.org/licenses/LICENSE-2.0
 * #
 * # Unless required by applicable law or agreed to in writing, software
 * # distributed under the License is distributed on an "AS IS" BASIS,
 * # WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * # See the License for the specific language governing permissions and
 * # limitations under the License.
 */

package org.qubership.atp.ram.model.datacontext;

import java.util.List;
import java.util.Map;
import java.util.UUID;

import org.qubership.atp.ram.dto.response.TestCaseLabelResponse;
import org.qubership.atp.ram.models.LogRecord;
import org.qubership.atp.ram.models.TestRun;

import lombok.Builder;
import lombok.Data;

@Builder
@Data
public class TestRunsDataContext {
    private UUID executionRequestId;
    private Map<UUID, TestRun> testRunsMap;
    private Map<UUID, List<LogRecord>> testRunValidationLogRecordsMap;
    private Map<UUID, List<LogRecord>> testRunFailedLogRecordsMap;
    private Map<UUID, TestCaseLabelResponse> testRunTestCasesMap;
    private Map<UUID, String> rootCausesMap;
    private Map<String, String> testRunDslNamesMap;
}
