/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.clients.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.ram.clients.api.dto.catalogue.ExecuteRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.RerunRequestDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="ExecuteRequestController", description="Execute Request Controller")
public interface ExecuteRequestControllerApi {
    @Operation(operationId="execute", summary="execute", tags={"execute-request-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/executionrequests/execute/testcases"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<UUID>> execute(@Parameter(name="Authorization", description="Authorization") @RequestHeader(value="Authorization", required=false) String var1, @Parameter(name="ExecuteRequestDto", description="") @Valid @RequestBody(required=false) ExecuteRequestDto var2);

    @Operation(operationId="getExecutionOrderByLabelId", summary="getExecutionOrderByLabelId", tags={"execute-request-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/executionrequests/execute/labelsOrFolder/search"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<UUID>> getExecutionOrderByLabelId(@Parameter(name="labelId", description="labelId") @Valid @RequestParam(value="labelId", required=false) UUID var1, @Parameter(name="folderId", description="folderId") @Valid @RequestParam(value="folderId", required=false) UUID var2, @Parameter(name="Authorization", description="Authorization") @RequestHeader(value="Authorization", required=false) String var3, @Parameter(name="ExecuteRequestDto", description="") @Valid @RequestBody(required=false) ExecuteRequestDto var4);

    @Operation(operationId="getExecutionOrderBySearch", summary="getExecutionOrderBySearch", tags={"execute-request-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/executionrequests/execute/labels/{labelId}/folder/{folderId}/search"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<UUID>> getExecutionOrderBySearch(@Parameter(name="labelId", description="labelId", required=true) @PathVariable(value="labelId") UUID var1, @Parameter(name="folderId", description="folderId", required=true) @PathVariable(value="folderId") UUID var2, @Parameter(name="Authorization", description="Authorization") @RequestHeader(value="Authorization", required=false) String var3, @Parameter(name="ExecuteRequestDto", description="") @Valid @RequestBody(required=false) ExecuteRequestDto var4);

    @Operation(operationId="rerun", summary="rerun", tags={"execute-request-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/executionrequests/rerun"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<UUID> rerun(@Parameter(name="Authorization", description="Authorization") @RequestHeader(value="Authorization", required=false) String var1, @Parameter(name="RerunRequestDto", description="") @Valid @RequestBody(required=false) RerunRequestDto var2);
}

