/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.clients.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.ram.clients.api.dto.catalogue.LabelDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.LabelFilteringRequestBodyDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.LabelUsageResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.LabelWithRefsResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseShortResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestPlanAndCaseIdsRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestPlanIdRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestPlanShortResponseDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="LabelController", description="Label Controller")
public interface LabelControllerApi {
    @Operation(operationId="create", summary="create", tags={"label-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=LabelDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/labels"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<LabelDto> create(@Parameter(name="LabelDto", description="") @Valid @RequestBody(required=false) LabelDto var1);

    @Operation(operationId="delete", summary="delete", tags={"label-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/catalog/api/v1/labels/{uuid}"})
    public ResponseEntity<Void> delete(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="findTestCaseUsages", summary="findTestCaseUsages", tags={"label-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCaseShortResponseDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/labels/{uuid}/findTestCaseUsages"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<TestCaseShortResponseDto>> findTestCaseUsages(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1, @Parameter(name="TestPlanIdRequestDto", description="") @Valid @RequestBody(required=false) TestPlanIdRequestDto var2);

    @Operation(operationId="findTestPlanUsages", summary="findTestPlanUsages", tags={"label-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestPlanShortResponseDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/labels/{uuid}/findTestPlanUsages"}, produces={"application/json"})
    public ResponseEntity<List<TestPlanShortResponseDto>> findTestPlanUsages(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="findUsageCounts", summary="findUsageCounts", tags={"label-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=LabelUsageResponseDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/labels/{uuid}/findUsageCounts"}, produces={"application/json"})
    public ResponseEntity<List<LabelUsageResponseDto>> findUsageCounts(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getAll", summary="getAll", tags={"label-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=LabelDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/labels"}, produces={"application/json"})
    public ResponseEntity<List<LabelDto>> getAll(@NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var1, @Parameter(name="testPlanId", description="testPlanId") @Valid @RequestParam(value="testPlanId", required=false) UUID var2);

    @Operation(operationId="getLabelsByIds", summary="getLabelsByIds", tags={"label-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=LabelDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/labels/search"}, produces={"application/json"})
    public ResponseEntity<List<LabelDto>> getLabelsByIds(@NotNull @Parameter(name="labelIds", description="labelIds", required=true) @Valid @RequestParam(value="labelIds", required=true) Set<UUID> var1);

    @Operation(operationId="search", summary="search", tags={"label-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=LabelWithRefsResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/labels/search"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<LabelWithRefsResponseDto>> search(@NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var1, @Parameter(name="refs", description="refs") @Valid @RequestParam(value="refs", required=false) List<String> var2, @Parameter(name="page", description="page number") @Valid @RequestParam(value="page", required=false) Integer var3, @Parameter(name="size", description="size number") @Valid @RequestParam(value="size", required=false) Integer var4, @Parameter(name="LabelFilteringRequestBodyDto", description="") @Valid @RequestBody(required=false) LabelFilteringRequestBodyDto var5);

    @Operation(operationId="unassign", summary="unassign", tags={"label-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/labels/{uuid}/unassign"}, consumes={"application/json"})
    public ResponseEntity<Void> unassign(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1, @Parameter(name="TestPlanAndCaseIdsRequestDto", description="") @Valid @RequestBody(required=false) TestPlanAndCaseIdsRequestDto var2);

    @Operation(operationId="update", summary="update", tags={"label-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=LabelDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/catalog/api/v1/labels/{uuid}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<LabelDto> update(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1, @Parameter(name="LabelDto", description="") @Valid @RequestBody(required=false) LabelDto var2);
}

